#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct InstancingGeneratorParams
{
    int seed;
    int first_particle;
    int skip_particles;
    int num_particles;
    float fade_lifetime;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _128;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _152;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _175;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _225;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _334;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _439;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _462;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _483;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _491;

bool prt_is_alive(uint id)
{
    return _128.prt_states[id].life_time < _128.prt_states[id].life_span;
}

vec3 prt_get_prev_position(uint id)
{
    return vec3(_175.prt_prev_positions[(id * 3u) + 0u], _175.prt_prev_positions[(id * 3u) + 1u], _175.prt_prev_positions[(id * 3u) + 2u]);
}

vec3 prt_get_position(uint id)
{
    return vec3(_152.prt_positions[(id * 3u) + 0u], _152.prt_positions[(id * 3u) + 1u], _152.prt_positions[(id * 3u) + 2u]);
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ParticleState prt_get_state(uint id)
{
    ParticleState _145;
    _145.life_time = _128.prt_states[id].life_time;
    _145.life_span = _128.prt_states[id].life_span;
    _145.generation_id = _128.prt_states[id].generation_id;
    _145.color = _128.prt_states[id].color;
    ParticleState _144 = _145;
    return _144;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _128.prt_states[id].color;
    vec3 _202 = color_convert_uint_to_float3(param);
    c.x = _202.x;
    c.y = _202.y;
    c.z = _202.z;
    return c;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint particle_idx = (id * uint(_225.instancing_generator_params.skip_particles)) + uint(_225.instancing_generator_params.first_particle);
    if (particle_idx >= uint(_225.instancing_generator_params.num_particles))
    {
        return;
    }
    uint param = particle_idx;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    uint param_1 = particle_idx;
    vec3 pos_prev = prt_get_prev_position(param_1);
    uint param_2 = particle_idx;
    vec3 pos = prt_get_position(param_2);
    bool has_direction = true;
    bool _264 = pos.x == pos_prev.x;
    bool _272;
    if (_264)
    {
        _272 = pos.y == pos_prev.y;
    }
    else
    {
        _272 = _264;
    }
    bool _280;
    if (_272)
    {
        _280 = pos.z == pos_prev.z;
    }
    else
    {
        _280 = _272;
    }
    if (_280)
    {
        has_direction = false;
    }
    vec3 nx = vec3(1.0, 0.0, 0.0);
    vec3 ny = vec3(0.0, 1.0, 0.0);
    vec3 nz = vec3(0.0, 0.0, 1.0);
    if (has_direction)
    {
        vec3 d = normalize(pos_prev - pos);
        nz = d;
        nx = cross(nz, ny);
        ny = cross(nz, nx);
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = particle_idx;
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
    {
        return;
    }
    int _337 = atomicAdd(_334.instance_params.instance_count, 1);
    uint instance_id = uint(_337);
    if (instance_id >= uint(_334.instance_params.buffer_capacity))
    {
        return;
    }
    uint param_3 = particle_idx;
    ParticleState particle_state = prt_get_state(param_3);
    float size = 1.0;
    if (particle_state.life_time < _225.instancing_generator_params.fade_lifetime)
    {
        size = smoothstep(0.0, _225.instancing_generator_params.fade_lifetime, particle_state.life_time);
    }
    if (particle_state.life_time >= (particle_state.life_span - _225.instancing_generator_params.fade_lifetime))
    {
        size = 1.0 - smoothstep(particle_state.life_span - _225.instancing_generator_params.fade_lifetime, particle_state.life_span, particle_state.life_time);
    }
    nx *= size;
    ny *= size;
    nz *= size;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    uint param_4 = particle_idx;
    instance.c = prt_get_color(param_4);
    instance.flipbook_card = 0u;
    _439.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _439.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _439.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _462.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _462.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _483.instance_hash[instance_id] = instance.hash;
    _491.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 