#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    float min_face_size;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _267;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _326;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _384;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _961;

layout(set = 0, binding = 10, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1210;

layout(set = 0, binding = 11, std140) uniform VM1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM1_params;
} _1225;

layout(set = 0, binding = 12, std140) uniform VM2
{
    ModifierFactorClamp_Params VM2_params;
} _1240;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1261;

layout(set = 0, binding = 13, std140) uniform VM3
{
    layout(row_major) ModifierFactorNoise_Params VM3_params;
} _1315;

layout(set = 0, binding = 14, std140) uniform VM4
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM4_params;
} _1328;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1342;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1365;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1385;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1393;

layout(set = 0, binding = 15) uniform sampler2D s_Curves;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _384.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _384.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _253 = hash(param);
    uint param_1 = _253;
    float _255 = floatConstruct(param_1);
    return _255;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _326.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _326.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _326.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_267.in_vtx_data[coord_offset + 0u], _267.in_vtx_data[coord_offset + 1u], _267.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_267.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _966;
    _966.seed = _961.instancing_generator_params.seed;
    _966.transformed_data_location_idx = _961.instancing_generator_params.transformed_data_location_idx;
    _966.transformed_data_location_num = _961.instancing_generator_params.transformed_data_location_num;
    _966.surface_distance = _961.instancing_generator_params.surface_distance;
    _966.instance_scale = _961.instancing_generator_params.instance_scale;
    _966.alpha_to_modifier_factor = _961.instancing_generator_params.alpha_to_modifier_factor;
    _966.min_face_size = _961.instancing_generator_params.min_face_size;
    InstancingGeneratorParams param = _966;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _972;
    _972.seed = _961.instancing_generator_params.seed;
    _972.transformed_data_location_idx = _961.instancing_generator_params.transformed_data_location_idx;
    _972.transformed_data_location_num = _961.instancing_generator_params.transformed_data_location_num;
    _972.surface_distance = _961.instancing_generator_params.surface_distance;
    _972.instance_scale = _961.instancing_generator_params.instance_scale;
    _972.alpha_to_modifier_factor = _961.instancing_generator_params.alpha_to_modifier_factor;
    _972.min_face_size = _961.instancing_generator_params.min_face_size;
    InstancingGeneratorParams param_1 = _972;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _961.instancing_generator_params.min_face_size;
    vec3 bc;
    float _1183;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    for (int i = 0; i < 4; i++)
    {
        float fid = float(id);
        float fid_seed = (((fid * 0.0131700001657009124755859375) + float(_961.instancing_generator_params.seed)) + float(i)) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_2));
        face_idx += first_face_idx;
        uint param_3 = face_idx;
        RTFace rt_face = rt_get_face(param_3);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_4 = p0_idx;
        vec3 p0 = rt_get_vertex(param_4);
        uint param_5 = p1_idx;
        vec3 p1 = rt_get_vertex(param_5);
        uint param_6 = p2_idx;
        vec3 p2 = rt_get_vertex(param_6);
        float face_size = length(cross(p0 - p1, p0 - p2));
        if (face_size < face_min_size_threshold)
        {
            continue;
        }
        uint param_7 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_7);
        uint param_8 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_8);
        uint param_9 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_9);
        float param_10 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_10);
        float param_11 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_11);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        vec3 nx = normalize(p0 - p2);
        vec3 ny = normalize(p0 - p1);
        vec3 nz = normalize(cross(nx, ny));
        ny = cross(nz, nx);
        pos -= (nz * _961.instancing_generator_params.surface_distance);
        nx *= _961.instancing_generator_params.instance_scale.x;
        ny *= _961.instancing_generator_params.instance_scale.y;
        nz *= _961.instancing_generator_params.instance_scale.z;
        ModifierFactor modifier_factor = modifier_factor_defaults();
        if (_961.instancing_generator_params.alpha_to_modifier_factor != 0)
        {
            _1183 = col.w;
        }
        else
        {
            _1183 = 1.0;
        }
        modifier_factor.factor = _1183;
        modifier_factor.hash = floatBitsToUint(fid_seed);
        modifier_factor.id = id;
        modifier_factor.position = pos;
        modifier_factor.is_spawned = true;
        cs_transforms.mat_local_to_model = mat_identity();
        cs_transforms.mat_local_to_instance = mat_identity();
        cs_transforms.mat_local_to_model_inv = mat_identity();
        ModifierFactorNoise_Params _1215;
        _1215.transform_local_to_gizmo = _1210.VM0_params.transform_local_to_gizmo;
        _1215.noise_domain_scale = _1210.VM0_params.noise_domain_scale;
        _1215.modifier_function = _1210.VM0_params.modifier_function;
        _1215.noise_domain_offset = _1210.VM0_params.noise_domain_offset;
        _1215.noise_value_scale = _1210.VM0_params.noise_value_scale;
        _1215.noise_value_offset = _1210.VM0_params.noise_value_offset;
        _1215.influence_scope = _1210.VM0_params.influence_scope;
        _1215._pad0 = _1210.VM0_params._pad0;
        _1215._pad1 = _1210.VM0_params._pad1;
        ModifierFactorNoise_Params param_12 = _1215;
        ModifierFactor param_13 = modifier_factor;
        CoordinateSystemTrasforms param_14 = cs_transforms;
        modifier_factor_noise(param_12, param_13, param_14);
        modifier_factor = param_13;
        ModifierFactorDistanceRadial_Params _1230;
        _1230.transform_local_to_gizmo = _1225.VM1_params.transform_local_to_gizmo;
        _1230.falloff_curve_idx = _1225.VM1_params.falloff_curve_idx;
        _1230.falloff_inverse = _1225.VM1_params.falloff_inverse;
        _1230.domain_repeat_x = _1225.VM1_params.domain_repeat_x;
        _1230.domain_repeat_y = _1225.VM1_params.domain_repeat_y;
        _1230.domain_repeat_z = _1225.VM1_params.domain_repeat_z;
        _1230.influence_scope = _1225.VM1_params.influence_scope;
        _1230.modifier_function = _1225.VM1_params.modifier_function;
        ModifierFactorDistanceRadial_Params param_15 = _1230;
        ModifierFactor param_16 = modifier_factor;
        CoordinateSystemTrasforms param_17 = cs_transforms;
        modifier_factor_distance_radial(param_15, param_16, param_17);
        modifier_factor = param_16;
        ModifierFactorClamp_Params _1245;
        _1245.clamp_min = _1240.VM2_params.clamp_min;
        _1245.clamp_max = _1240.VM2_params.clamp_max;
        _1245.clamp_min_enable = _1240.VM2_params.clamp_min_enable;
        _1245.clamp_max_enable = _1240.VM2_params.clamp_max_enable;
        ModifierFactorClamp_Params param_18 = _1245;
        ModifierFactor param_19 = modifier_factor;
        modifier_factor_clamp(param_18, param_19);
        modifier_factor = param_19;
        if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
        {
            continue;
        }
        int _1264 = atomicAdd(_1261.instance_params.instance_count, 1);
        uint instance_id = uint(_1264);
        if (instance_id >= uint(_1261.instance_params.buffer_capacity))
        {
            return;
        }
        instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
        instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
        instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
        instance.hash = modifier_factor.hash;
        instance.c = vec4(1.0);
        instance.flipbook_card = 0u;
        ModifierFactorNoise_Params _1319;
        _1319.transform_local_to_gizmo = _1315.VM3_params.transform_local_to_gizmo;
        _1319.noise_domain_scale = _1315.VM3_params.noise_domain_scale;
        _1319.modifier_function = _1315.VM3_params.modifier_function;
        _1319.noise_domain_offset = _1315.VM3_params.noise_domain_offset;
        _1319.noise_value_scale = _1315.VM3_params.noise_value_scale;
        _1319.noise_value_offset = _1315.VM3_params.noise_value_offset;
        _1319.influence_scope = _1315.VM3_params.influence_scope;
        _1319._pad0 = _1315.VM3_params._pad0;
        _1319._pad1 = _1315.VM3_params._pad1;
        ModifierFactorNoise_Params param_20 = _1319;
        ModifierFactor param_21 = modifier_factor;
        CoordinateSystemTrasforms param_22 = cs_transforms;
        modifier_factor_noise(param_20, param_21, param_22);
        modifier_factor = param_21;
        ModifierFactorDistanceRadial_Params _1332;
        _1332.transform_local_to_gizmo = _1328.VM4_params.transform_local_to_gizmo;
        _1332.falloff_curve_idx = _1328.VM4_params.falloff_curve_idx;
        _1332.falloff_inverse = _1328.VM4_params.falloff_inverse;
        _1332.domain_repeat_x = _1328.VM4_params.domain_repeat_x;
        _1332.domain_repeat_y = _1328.VM4_params.domain_repeat_y;
        _1332.domain_repeat_z = _1328.VM4_params.domain_repeat_z;
        _1332.influence_scope = _1328.VM4_params.influence_scope;
        _1332.modifier_function = _1328.VM4_params.modifier_function;
        ModifierFactorDistanceRadial_Params param_23 = _1332;
        ModifierFactor param_24 = modifier_factor;
        CoordinateSystemTrasforms param_25 = cs_transforms;
        modifier_factor_distance_radial(param_23, param_24, param_25);
        modifier_factor = param_24;
        _1342.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
        _1342.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
        _1342.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
        _1365.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
        _1365.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
        _1385.instance_hash[instance_id] = instance.hash;
        _1393.instance_flipbook_card[instance_id] = instance.flipbook_card;
        return;
    }
}

 