#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _32;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _58;

layout(set = 0, binding = 4, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _114;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _125;

shared vec3 calculate_bbox_min_for_thread[64];
shared vec3 calculate_bbox_max_for_thread[64];

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _58.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _58.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _58.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_32.in_vtx_data[coord_offset + 0u], _32.in_vtx_data[coord_offset + 1u], _32.in_vtx_data[coord_offset + 2u]);
    return p;
}

void main()
{
    uint prim_idx = _114.transform_geometry_params.instance_idx;
    uint first_idx = 0u;
    uint n = _125.transformed_data_location[prim_idx].last_face_idx + 1u;
    if (prim_idx > 0u)
    {
        n -= (_125.transformed_data_location[prim_idx - 1u].last_face_idx + 1u);
        first_idx = _125.transformed_data_location[prim_idx - 1u].last_face_idx + 1u;
    }
    uint face_idx = gl_GlobalInvocationID.x;
    if (face_idx >= n)
    {
        face_idx = n - 1u;
    }
    uint param = first_idx + face_idx;
    RTFace rt_face = rt_get_face(param);
    uint v0_idx = rt_face.v0;
    uint v1_idx = rt_face.v1;
    uint v2_idx = rt_face.v2;
    uint param_1 = v0_idx;
    vec3 v0 = rt_get_vertex(param_1);
    uint param_2 = v1_idx;
    vec3 v1 = rt_get_vertex(param_2);
    uint param_3 = v2_idx;
    vec3 v2 = rt_get_vertex(param_3);
    vec3 bbox_min = v0;
    vec3 bbox_max = v0;
    bbox_min = min(bbox_min, v1);
    bbox_min = min(bbox_min, v2);
    bbox_max = max(bbox_max, v1);
    bbox_max = max(bbox_max, v2);
    calculate_bbox_min_for_thread[gl_LocalInvocationIndex] = bbox_min;
    calculate_bbox_max_for_thread[gl_LocalInvocationIndex] = bbox_max;
    memoryBarrierShared();
    barrier();
    if (gl_LocalInvocationIndex == 0u)
    {
        for (uint i = 1u; i < 64u; i++)
        {
            bbox_min = min(bbox_min, calculate_bbox_min_for_thread[i]);
            bbox_max = max(bbox_max, calculate_bbox_max_for_thread[i]);
        }
        int _249 = atomicMin(_125.transformed_data_location[prim_idx].bbox_min.x, int(bbox_min.x));
        int _255 = atomicMin(_125.transformed_data_location[prim_idx].bbox_min.y, int(bbox_min.y));
        int _261 = atomicMin(_125.transformed_data_location[prim_idx].bbox_min.z, int(bbox_min.z));
        int _268 = atomicMax(_125.transformed_data_location[prim_idx].bbox_max.x, int(bbox_max.x));
        int _274 = atomicMax(_125.transformed_data_location[prim_idx].bbox_max.y, int(bbox_max.y));
        int _280 = atomicMax(_125.transformed_data_location[prim_idx].bbox_max.z, int(bbox_max.z));
    }
}

 