#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _100;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _117;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _143;

layout(set = 0, binding = 4, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _194;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_143.prt_prev_positions[(id * 3u) + 0u], _143.prt_prev_positions[(id * 3u) + 1u], _143.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _106;
    _106.life_time = _100.prt_states[id].life_time;
    _106.life_span = _100.prt_states[id].life_span;
    _106.generation_id = _100.prt_states[id].generation_id;
    _106.color = _100.prt_states[id].color;
    ParticleState _105 = _106;
    return _105;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _113;
    _113.life_time = state.life_time;
    _113.life_span = state.life_span;
    _113.generation_id = state.generation_id;
    _113.color = state.color;
    _100.prt_states[id] = _113;
}

void prt_set_position(uint id, vec3 p)
{
    _117.prt_positions[(id * 3u) + 0u] = p.x;
    _117.prt_positions[(id * 3u) + 1u] = p.y;
    _117.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_194.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    float param_4 = _194.lifecycle_params.time_step;
    float param_5 = _194.lifecycle_params.max_lifetime;
    prt_advance_life(param_3, param_4, param_5);
    p.state = param_3;
    uint param_6 = id;
    ParticleState param_7 = p.state;
    prt_set_state(param_6, param_7);
    uint param_8 = id;
    vec3 param_9 = p.pos;
    prt_set_position(param_8, param_9);
}

 