
#ifndef VERTEX_MODIFIERS_FACE_UNWRAP_H
#define VERTEX_MODIFIERS_FACE_UNWRAP_H

#include <shaders/materials/commons_gradient.glsl>

struct VertexModifierFaceUnwrapParams
{
	float unwrap_factor;
	float face_stretch;
	float unwrap_spacing;
};

struct ModifierFactorFaceUnwrapFaceIdxParams
{
	int   modifier_function;
	float unwrap_spacing;
};

struct ModifierFactorFaceUnwrapFactorParams
{
	int   modifier_function;
	float unwrap_factor;
	float unwrap_spacing;
};

#ifndef VTXAttribute_TweenIdx
#define VTXAttribute_TweenIdx
layout(std430) buffer VTXTweenIdx {
	uint tween_idx[];
} vtx_tween_idx;

uint vtx_tween_idx_load(uint idx)
{
	return vtx_tween_idx.tween_idx[idx];
}
#endif

vec3 _TurboColormap(in float x)
{
  const vec4 kRedVec4 = vec4(0.13572138, 4.61539260, -42.66032258, 132.13108234);
  const vec4 kGreenVec4 = vec4(0.09140261, 2.19418839, 4.84296658, -14.18503333);
  const vec4 kBlueVec4 = vec4(0.10667330, 12.64194608, -60.58204836, 110.36276771);
  const vec2 kRedVec2 = vec2(-152.94239396, 59.28637943);
  const vec2 kGreenVec2 = vec2(4.27729857, 2.82956604);
  const vec2 kBlueVec2 = vec2(-89.90310912, 27.34824973);
  
  x = clamp(x, 0.0, 1.0);
  vec4 v4 = vec4( 1.0, x, x * x, x * x * x);
  vec2 v2 = v4.zw * v4.z;
  return vec3(
    dot(v4, kRedVec4)   + dot(v2, kRedVec2),
    dot(v4, kGreenVec4) + dot(v2, kGreenVec2),
    dot(v4, kBlueVec4)  + dot(v2, kBlueVec2)
  );
}

uint face_unwrap_decode_tween_distance(uint tween)
{
	return tween >> 2;
}

uint face_unwrap_decode_tween_edge(uint tween)
{
	return tween & 3;
}

void vertex_modifier_face_unwrap_apply(VertexModifierFaceUnwrapParams modifier_params, inout ModifierFactor modifier_factor, inout VertexInput vtx)
{
	// NOTE: This is not a clean design but at this point i have no idea how to make it clean. This modifier requires a custom vertex attribute
	// Rely on the UI error reporting to signal lack of it maybe? Hopefuly compiler's output is gonna be clean enough

	uint tween          = vtx_tween_idx_load(vtx.id);
	uint tween_distance = face_unwrap_decode_tween_distance(tween);
	uint tween_edge     = face_unwrap_decode_tween_edge(tween);

	// edge 0 is v0 - v1, 1 is v1 - v2, 2 is v2 - v0
	// need to extract axis of rotation. this could be optimized of all the modulos are costly
	uint v_idx = vtx.id;
	uint v_idx_in_face = v_idx % 3;
	uint axis_v0_idx, axis_v1_idx;
	if (tween_edge == 0)
	{
		axis_v0_idx = (v_idx - v_idx_in_face) + 0;
		axis_v1_idx = (v_idx - v_idx_in_face) + 1;
	}
	else if (tween_edge == 1)
	{
		axis_v0_idx = (v_idx - v_idx_in_face) + 1;
		axis_v1_idx = (v_idx - v_idx_in_face) + 2;
	}
	else // tween_edge == 2
	{
		axis_v0_idx = (v_idx - v_idx_in_face) + 2;
		axis_v1_idx = (v_idx - v_idx_in_face) + 0;
	}

	// fetch vertices. this again assumes we work in local space without instancing
	vec3 axis_v0 = vtx_coords_load(axis_v0_idx);
	vec3 axis_v1 = vtx_coords_load(axis_v1_idx);

	// use quaternion to rotate around it
	float tween_factor     = clamp(modifier_params.unwrap_factor * modifier_params.unwrap_spacing - float(tween_distance) * modifier_params.unwrap_spacing, 0.0, 1.0);
	float angle_in_radians = tween_factor * M_PI;
	float face_scale       = tween_factor;

	if (face_scale <= 0.00001)
	{
		vtx.pos = axis_v0;
	}

	vec4 q = quaternion_from_axis_angle(normalize(axis_v1 - axis_v0), angle_in_radians + M_PI);
	vec3 v = vtx.pos;

	vec3 vc = (axis_v0 + axis_v1) * 0.5;
	if (v_idx != axis_v0_idx && v_idx != axis_v1_idx)
	{
		//v = v - vc;	// for now project on the middle
		float enlarge = 1.0 + sin(face_scale * M_PI) * modifier_params.face_stretch;
		//float f = sqrt(face_scale * enlarge);
		float f = face_scale * enlarge;
		v = mix(vc, v, f);
	}

	vtx.norm = vector_rotate_by_quaternion(vtx.norm, q);
	v = vector_rotate_by_quaternion(v - axis_v0, q);
	v += axis_v0;

	if (v_idx != axis_v0_idx && v_idx != axis_v1_idx)
	{
		//v *= face_scale;
		//v += vc;
	}

	float f = fract(float(tween_distance) * 0.01731);
	vec3  c = _TurboColormap(face_scale);
	vtx.color.rgb = vec3(1.0);
	//vtx.color.rgb = c;
	vtx.pos       = v;

}

void modifier_factor_face_unwrap_face_idx(ModifierFactorFaceUnwrapFaceIdxParams modifier_params, inout ModifierFactor modifier_factor)
{
	// NOTE: This is not a clean design but at this point i have no idea how to make it clean. This modifier requires a custom vertex attribute
	// Rely on the UI error reporting to signal lack of it maybe? Hopefuly compiler's output is gonna be clean enough

	uint tween          = vtx_tween_idx_load(modifier_factor.id);
	uint tween_distance = face_unwrap_decode_tween_distance(tween);
	uint tween_edge     = face_unwrap_decode_tween_edge(tween);

	uint v_idx          = modifier_factor.id;
	uint v_idx_in_face  = v_idx % 3;

	uint axis_v0_idx, axis_v1_idx;

	if (true)
	{
		if (tween_edge == 0 && v_idx_in_face == 2)
		{
			tween_distance += 1;
		}
		if (tween_edge == 1 && v_idx_in_face == 0)
		{
			tween_distance += 1;
		}
		if (tween_edge == 2 && v_idx_in_face == 1)
		{
			tween_distance += 1;
		}
	}

	modifier_process_modifier_factor(modifier_factor, modifier_params.modifier_function, float(tween_distance));

}

void modifier_factor_face_unwrap_factor(ModifierFactorFaceUnwrapFactorParams modifier_params, inout ModifierFactor modifier_factor)
{
	// NOTE: This is not a clean design but at this point i have no idea how to make it clean. This modifier requires a custom vertex attribute
	// Rely on the UI error reporting to signal lack of it maybe? Hopefuly compiler's output is gonna be clean enough

	uint tween          = vtx_tween_idx_load(modifier_factor.id);
	uint tween_distance = face_unwrap_decode_tween_distance(tween);
	uint tween_edge     = face_unwrap_decode_tween_edge(tween);

	uint v_idx          = modifier_factor.id;
	uint v_idx_in_face  = v_idx % 3;

	uint axis_v0_idx, axis_v1_idx;
	if (tween_edge == 0 && v_idx_in_face == 2)
	{
		tween_distance += 1;
	}
	if (tween_edge == 1 && v_idx_in_face == 0)
	{
		tween_distance += 1;
	}
	if (tween_edge == 2 && v_idx_in_face == 1)
	{
		tween_distance += 1;
	}

	float tween_factor = modifier_params.unwrap_factor * modifier_params.unwrap_spacing - float(tween_distance) * modifier_params.unwrap_spacing;
	//float tween_factor  = clamp(modifier_params.unwrap_factor * modifier_params.unwrap_spacing - float(tween_distance) * modifier_params.unwrap_spacing, 0.0, 1.0);

	modifier_process_modifier_factor(modifier_factor, modifier_params.modifier_function, tween_factor);

}

#endif // VERTEX_MODIFIERS_FACE_UNWRAP_H


