precision mediump float;
uniform vec3 projector_pos;
uniform mat4 projector_rot;
uniform float projector_range;
varying vec2 vTexcoord0;
varying vec4 vPos;
varying vec4 vColor;
varying vec3 vNorm;
uniform samplerCube s_texture0;

void main() {
	vec3 dir = vPos.xyz - projector_pos;
	float dist = length(dir) / projector_range;
	dist = 1.0 - min(1.0, dist);
	
	vec4 cube = textureCube(s_texture0, dir);
	gl_FragColor = vec4((cube * dist + vColor).xyz, vPos.w); // depth in alpha component
}