#version 430

in vec2 vTexcoord0;

uniform sampler2D s_texture0;		// albedo
uniform sampler2D s_texture1;		// depth

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

uniform float max_radius;
uniform float steepnes;
uniform float far_factor;
uniform float far_plane;
uniform int show_coc;

// output for 2 buffers
layout(location = 0) out vec4 outColor;

float linearizeDepth(float d)
{
	//return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
	return (2.0 * 0.01 * 1000.0) / (1000.0 + 0.01 - d * (1000.0 - 0.01));
}

#define DOF_ITER 125
#define GOLDEN_ANGLE 2.39996
mat2 rot = mat2(cos(GOLDEN_ANGLE), sin(GOLDEN_ANGLE), -sin(GOLDEN_ANGLE), cos(GOLDEN_ANGLE));
vec3 dof(sampler2D tex, sampler2D dtex, float ref_depth, vec2 uv, float radius)
{
	vec3 acc = vec3(0.0);
	vec3 acc_center;
	float r = 1.0;
	float div = 0.0;

	vec2 vangle = vec2(0.0, radius * 0.007 / sqrt(float(DOF_ITER)));

	acc = acc_center = texture(tex, uv).rgb;
	div = 1.0;

	for(int j=0; j< DOF_ITER; j++)
	{
		r += 1.0 / r;
		vangle = rot * vangle;
		float depth = linearizeDepth(texture(dtex, uv + (r - 1.0) * 0.5 * vangle).r);
		if (depth > ref_depth)
		{
			vec3 col = texture(tex, uv + (r - 1.0) * 0.5 * vangle).rgb;
			acc += col;
			div += 1.0;
		}
		else
		{
			acc += acc_center;
			div += 1.0;
		}
	}

	return acc / div;
}

float gather_coc(vec2 uv)
{
	float depth = linearizeDepth(texture(s_texture1, uv).r);
	float r = 0.0;
	float ref_depth = far_factor;
	if (depth > ref_depth)
		r = (depth - ref_depth) / (far_plane - ref_depth);

	float coc = 0.0;
	if (r > 0.0)
	{
		coc += clamp(r * max_radius, 0.0, 1.5);
	}
	
	return coc;
}

float gather_coc_blur(vec2 uv)
{
	float coc = 0.0;
	float sum = 0.0;

	for(float v = -20.0; v < 20.0; v += 1.5)
	{
		for(float u = -20.0; u < 20.0; u += 1.5)
		{
			coc += gather_coc(uv + vec2(u, v) * vResolutionInv);
			sum += 1.0;
		}
	}

	return coc / sum;
}

void main() {

	float depth = linearizeDepth(texture(s_texture1, vTexcoord0).r);
	
	float ref_depth = far_factor;

	vec4 albedo = texture(s_texture0, vTexcoord0);
	//float coc = gather_coc(vTexcoord0);
	float coc = gather_coc_blur(vTexcoord0);

	if (coc > 0.0)
	{
		albedo.rgb = dof(s_texture0, s_texture1, ref_depth, vTexcoord0, coc);
	}
	
	outColor = albedo;
	if (show_coc != 0)
		outColor = vec4(coc);
}