
#version 430

#define MATERIAL_PROPERTIES_BINDING 1
#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;
uniform sampler2D sDepth;

void main() {

	ivec2 p = ivec2(gl_FragCoord.xy) * 2;

	// conservative
	float depth00 = texelFetch(sDepth, p + ivec2(0, 0), 0).r;
	float depth01 = texelFetch(sDepth, p + ivec2(0, 1), 0).r;
	float depth10 = texelFetch(sDepth, p + ivec2(1, 0), 0).r;
	float depth11 = texelFetch(sDepth, p + ivec2(1, 1), 0).r;

	float min_depth;
	min_depth = min(depth00, depth01);
	min_depth = min(min_depth, depth10);
	min_depth = min(min_depth, depth11);

	gl_FragDepth = min_depth;

}
