#version 300 es

in vec3 vPosition;
in vec3 vNormal;
in vec2 vTexcoord;

in float vAttribute0;

uniform mat4 mModel;
uniform vec4 vModelview[3];
uniform vec4 vModelviewInvTrans[3];
uniform mat4 mProjection;

out vec4 vCoords;
out vec3 vNorm;
out vec3 vWorldNorm;
out vec4 vPos;
out vec4 vWorldPos;
out vec2 vTCoord;


void main() {
	
	vec3 pos = vPosition;
	vec3 norm = vNormal;

	vec4 vPos1 = vec4(pos, 1.0);
	vPos.x = dot(vModelview[0], vPos1);
	vPos.y = dot(vModelview[1], vPos1);
	vPos.z = dot(vModelview[2], vPos1);
	vPos.w = 1.0;
	vWorldPos = mModel * vPos1;
	vWorldNorm = (mModel * vec4(norm, 0.0)).xyz;

	vNorm.x = dot(vModelviewInvTrans[0].xyz, norm);
	vNorm.y = dot(vModelviewInvTrans[1].xyz, norm);
	vNorm.z = dot(vModelviewInvTrans[2].xyz, norm);
	vNorm = normalize(vNorm);//vNormal;

	vec4 projected = mProjection * vPos;
	gl_Position = projected;
	vCoords = projected;
	vTCoord = vTexcoord;
}