
#ifndef COMMONS_HLSL_H
#define COMMONS_HLSL_H

#define float4 vec4
#define float3 vec3
#define float2 vec2
#define int2   ivec2
#define uint2  uvec2

vec3 saturate(vec3 a)
{
	return max(vec3(0.0), min(vec3(1.0), a));
}

float saturate(float a)
{
	return max(0.0, min(1.0, a));
}

vec3 mad(vec3 m, vec3 a, vec3 b)
{
	return m * a + b;
}

float mad(float m, float a, float b)
{
	return m * a + b;
}

vec3 lerp(vec3 a, vec3 b, vec3 t)
{
	return mix(a, b, t);
}

vec3 lerp(vec3 a, vec3 b, float t)
{
	return mix(a, b, vec3(t));
}

uint asuint(float v)
{
	return floatBitsToUint(v);
}

float asfloat(uint v)
{
	return uintBitsToFloat(v);
}


#endif