#version 300 es

in vec3 vPosition;
in vec2 vTexcoord;
uniform mat4 mModelview;
uniform mat4 mProjection;
uniform mediump float stepx;
uniform mediump float stepy;
uniform mediump float scale;

// we want 9 samples but only 8 varyings available...
out vec2 vTexcoord0;
out vec2 vTexcoord0_p1;
out vec2 vTexcoord0_p2;
out vec2 vTexcoord0_p3;
out vec2 vTexcoord0_p4;
out vec2 vTexcoord0_p5;
out vec2 vTexcoord0_m1;
out vec2 vTexcoord0_m2;

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	vTexcoord0.xy = vTexcoord.xy;
	vec2 off = vec2(stepx, stepy) * scale;
	vTexcoord0_p1 = vTexcoord0 + off * 1.0;
	vTexcoord0_p2 = vTexcoord0 + off * 2.0;
	vTexcoord0_p3 = vTexcoord0 + off * 3.0;
	vTexcoord0_p4 = vTexcoord0 + off * 4.0;
	vTexcoord0_p5 = vTexcoord0 + off * 5.0;
	vTexcoord0_m1 = vTexcoord0 - off * 1.0;
	vTexcoord0_m2 = vTexcoord0 - off * 2.0;
}