;=======================================================================
; Vintage Computing Christmas Challenge 2023 (VC3 2023) 
; Amstrad CPC / Overflow & Longshot (Logon System)
; December 2023 / 31.12.2023
; 25 bytes 
;=======================================================================
_firm_dispchar	equ #bb5a		; firmware TXT OUTPUT
_firm_locatexy	equ #bb75		; firmware TXT SET CURSOR
orgcode		equ #1341
sizecode 	equ end_c-start_c

	org orgcode
start_c
				; on run (de=orgcode=#1341 (19 & X)
				; E = #41 = 5 + 6*n ; 5 would be ok
loopbig 			; 1st loop for half of the shape
       				; 2nd loop for the other half
        			; then loops for ever on 2nd loop
	ld a,c 			; X
	ld b,d	 		; Y dec from 19 to 1
loop
	inc a 			; pre-inc X
	ld h,a 			; X=...
	ld l,b 			; Y=...
	call _firm_locatexy 	; locate X,Y ; X-- Y--	
	ld a,h
	cp d			; output windows X-1 <19
	ld a,"*" 		; 
	call c,_firm_dispchar	; print "*"
	ld a,h
	sub 6			; next start is at X-6
	jr nc,loop		; is X still > 0 ?
	sub e 			; adjust start slide for next line
	djnz loop 		; next line
	ld e,h 			; for next loop E = #03 = 3 + 6*n 
	jp (hl) 		; jp loopbig = #300 = HL
end_c
;