;=======================================================================
; Vintage Computing Christmas Challenge 2023 (VC3 2023) 
; Amstrad CPC / Longshot (Logon System)
; December 2023
; 29 bytes 
; Window strategy
;=======================================================================
_firm_dispchar	equ #bb5a		; firmware TXT OUTPUT
_firm_locatexy	equ #bb75		; firmware TXT SET CURSOR
mode_dev	equ 1
sizecode 	equ end_c-start_c

orgcode		equ #1313-2-10

		org orgcode
		run $
		ld a,1
		call #bc0e
		ld de,#0040
		ld hl,#abff
					; on run (de=#0040, hl=#abff, af=#ff80 bc=#b0ff)
start_c
display_start
		ld a,e			; X initial position (out of x windows)
display_next_line
		ld c,19
		ld h,a 			; First X position (out of windows, y not yet fixed)
		ld b,c			; Star counter on line
		push bc			; loop address 
		push af			; Save X
display_star_line
		call _firm_locatexy	; Locate cursor (exit h=x-1, l=y-1, acc=2!)
		ld e,a			; de=0002 left.down / de=0202 right.down
		ld a,h			; Is X in windows (0..18) ?
		cp c
		ld a,"*"		; Accumulator sacrificed to the star. Alleluia!
		call c,_firm_dispchar	; Display only if cursor in window
		add hl,de		; Calculate next coordinate from x-1,y-1 
		djnz display_star_line	; 
		pop af 			; restore X
		ld l,6			; Fix Y position to 6 (equal to x step)
		sub l			; move line on x
		ret po			; loop on display_next_line
		add a,e			; a=7a+2=7c (x mod 6)
		ld d,e			; switch on right.down 
		ret
end_c
