; tasm -80 -b -s -l vccc2023.asm vccc2023.p
;
;==============================================
;               ZX81 assembler
;  Vintage Computing Christmas Challenge 2023
;
; The template and definition files can be
; found at the below repository
; https://github.com/chancanasta/zx81HelloWorld
;
;==============================================
;
;defs
#include "zx81defs.asm"
;EQUs for ROM routines
#include "zx81rom.asm"
;system variables
#include "zx81sys.asm"
;the standard REM statement that will contain our 'hex' code
#include "line1.asm"
;------------------------------------------------------------
; code starts here and gets added to the end of the REM 
;------------------------------------------------------------
start
        ld   b, 0       ; Y coordinate starts at 0
        ld   c, 15      ; X coordinate starts at 15
lp1                     ; loop to move diagonally down and right
        call pr         ; print a star
        inc  c          ; move cursor right
        inc  b          ; move cursor down
        ld   a, c       ;
        cp   $12        ; check if we are at the right wall
        jr   nz, lp1    ; continue until we hit the right wall
lp2                     ; loop to move diagonally down and left
        call pr         ; print a star
        dec  c          ; move cursor left
        inc  b          ; move cursor down
        ld   a, b       ; 
        cp   $12        ; check if we are at the bottom wall
        jr   nz, lp2    ; continue until we hit the bottom wall
lp3                     ; loop to move diagonally up and left
        call pr         ; print a star
        dec  b          ; move cursor left
        dec  c          ; move cursor up
        jr   nz, lp3    ; continue until we hit the left wall
lp4                     ; loop for moving diagonally right and up
        call pr         ; print a star
        inc  c          ; move cursor right
        dec  b          ; move cursor up
        jr   nz, lp4    ; continue until we hit the top wall
        ld   a, c       ;
        sub  6          ; we are now back where we started move X 6 positions to the left
        jr   c, done    ; if we do not have space on the screen then we are done
        ld   c, a       ; set the new starting position for X
        jr   lp1        ; start drawing the next pattern
pr                      ; subroutine for printing a star at X Y location
        push bc         ; BC will be destroyed, better make a backup
        call PRINTAT    ; call the "AT" ROM routine to move the cursor to what is stored in BC (YX)
        ld (hl), $17    ; print a "*" to the screen
        pop  bc         ; restore BC
done    ret             ; return from subroutine
; ===========================================================
; code ends
; ===========================================================
;end the REM line and put in the RAND USR line to call our 'hex code'
#include "line2.asm"

;display file defintion
#include "screen.asm"               

;close out the basic program
#include "endbasic.asm"