	org $1001-2
	dw  $1001
	
	;db $0B,$10,0,0,$9E,"4109",0,0,0	; proper BASIC line with SYS
	db $03,$10,0,0,$9E,"4107",$3A		; BASE line with SYS, where the ML code immediately follows

ptr = $2D					; the BASIC end pointer ($2D) is guaranteed to work for our screen position
						; $C8 could be used, which would save 4 bytes, but the program would *only* work if autostarted

star	macro xc, yc
	ldy #yc*40+xc				; place one star on screen
	sta (ptr),y
	endm
	
	;jsr $C567				; BASIC SCNCLR command to clear the screen (omitted)
	;lda #$C8				; writing low byte can be skipped
	;sta ptr				; this saves 4 bytes, but the pattern is at an arbitrary position
	lda #$0C				; high byte is $0C (screen character map)
	sta ptr+1
	;
yloop	ldx #$02				; x loop runs 3 times
xloop	lda #$2A				; star character ($2A)
	star 3,0
	;
	;star 2,1				; this star's offset is exactly $2A (same value as the star character, which is already in A)
	tay					; instead of ldy#$2A, tay saves one byte
	sta (ptr),y
	;
	star 4,1
	star 1,2
	star 5,2
	star 0,3
	star 6,3
	star 1,4
	star 5,4
	star 2,5
	star 4,5
	star 3,6
	;
	lda ptr					; add 6 to pointer (move to the right)
	;clc					; although very bad practice, clearing carry can be skipped (which saves one byte)
	adc #$06
	sta ptr
	dex					; end of x loop
	bpl xloop
	;
	lda ptr					; add 6*40-18 to pointer (move down and left)
	;clc					; although very bad practice, clearing carry can be skipped (which saves one byte)
	adc #222
	sta ptr
	bcc *+4					; 16 bit add
	inc ptr+1
	lda ptr+1				; load high byte to check if we should stop
	cmp #$0F				; stop at $0F## range
	bcc yloop
	;
	;jmp $8003				; proper exit
	bcs *					; endless loop
;eof