"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JS_ENGINE_PROP_KEY = exports.DEFAULT_JS_ENGINE = void 0;
exports.getJsEngine = getJsEngine;
exports.setJsEngine = setJsEngine;
exports.withJsEnginePodfileProps = void 0;

function _iosPlugins() {
  const data = require("../plugins/ios-plugins");

  _iosPlugins = function () {
    return data;
  };

  return data;
}

const JS_ENGINE_PROP_KEY = 'expo.jsEngine';
exports.JS_ENGINE_PROP_KEY = JS_ENGINE_PROP_KEY;
const DEFAULT_JS_ENGINE = 'jsc';
exports.DEFAULT_JS_ENGINE = DEFAULT_JS_ENGINE;

const withJsEnginePodfileProps = config => {
  return (0, _iosPlugins().withPodfileProperties)(config, config => {
    config.modResults = setJsEngine(config, config.modResults);
    return config;
  });
};

exports.withJsEnginePodfileProps = withJsEnginePodfileProps;

function getJsEngine(config) {
  var _ref, _config$ios$jsEngine, _config$ios;

  return (_ref = (_config$ios$jsEngine = (_config$ios = config.ios) === null || _config$ios === void 0 ? void 0 : _config$ios.jsEngine) !== null && _config$ios$jsEngine !== void 0 ? _config$ios$jsEngine : config.jsEngine) !== null && _ref !== void 0 ? _ref : DEFAULT_JS_ENGINE;
}

function setJsEngine(config, podfileProperties) {
  var _ref2, _config$ios$jsEngine2, _config$ios2;

  podfileProperties[JS_ENGINE_PROP_KEY] = (_ref2 = (_config$ios$jsEngine2 = (_config$ios2 = config.ios) === null || _config$ios2 === void 0 ? void 0 : _config$ios2.jsEngine) !== null && _config$ios$jsEngine2 !== void 0 ? _config$ios$jsEngine2 : config.jsEngine) !== null && _ref2 !== void 0 ? _ref2 : DEFAULT_JS_ENGINE;
  return podfileProperties;
}
//# sourceMappingURL=JsEngine.js.map