; SNOW_256.s
; Thadoss / Dune 2K23
;

			opt		p=68030/68882,NOCASE,W+,O+	; Optimized compilation
			comment 	HEAD=%111
			output		SNOW_256.PRG



DEV_VERSION		equ		0				; delta = 24 bytes


; --------------------------------------------------------------
			section	text
; --------------------------------------------------------------

			; get phy
			addq.w    	#2,-(sp)
			trap      	#14         			; Call XBIOS


			IFNE	DEV_VERSION
			move.l		d0,d7

			; Supervisor
			clr.l	-(sp)					;super()
			move.w	#$20,-(sp)				;
			trap	#1					;
			addq.l	#6+2,sp					;

			move.l		d7,d0
			ENDC


			; Draw sky and snowy ground
			; -------------------------
			move.l		d0,a4
			move.w		#320*100-1,d7
			lea.l		(a4,d7.w*2),a3

.loop_sky:		move.w		#$759f,(a4)+			; Draw sky
			move.w		#$c618,(a3)+			; Draw snowy ground
			dbf		d7,.loop_sky


			; Draw chrismas tree
			; ------------------

			lea.l		-320*40*2+420(a4),a4		; Screen_size - tree position
			moveq		#20,d1
			bsr.s		draw_triangle

			lea.l		-320*2*5+40(a4),a4
			moveq		#30,d1
			bsr.s		draw_triangle

			lea.l		-320*2*10+60(a4),a4
			moveq		#40,d1
			bsr.s		draw_triangle



			; Set Screen
			; ----------
			move.l		d0,a4


			; Draw sun
			; --------
			move.w		#$fe4d,a0			; color : yellow
			move.w		#250,d3				; x_circle
			moveq		#35,d4				; y_circle
			moveq		#20,d5				; radius
			bsr.s		draw_circle


			; Draw bowl_1
			; -----------
			move.w		d5,a0				; color : white
			moveq		#160-50,d3			; x_circle
			lsl.w		#2,d4				; y_circle (35*4=140)
			moveq		#40,d5				; radius
			bsr.s		draw_circle


			; Draw bowl_2
			; -----------
			moveq		#80,d4				; y_circle
			moveq		#30,d5				; radius
			bsr.s		draw_circle


			; Draw carot
			; ----------
			move.w		#$f303,a0			; color orange
			bsr.s		draw_circle_rad_4		; Draw a circle of radius 4



			; Draw 3 buttons
			; --------------
			sub.l		a0,a0				; color black
			moveq		#120-15,d4			; y_circle = 120
			bsr.s		draw_circle_rad_4_y		; Draw a circle of radius 4 ; incr y_cercle by 15
			bsr.s		draw_circle_rad_4_y		; Draw a circle of radius 4 ; incr y_cercle by 15
			bsr.s		draw_circle_rad_4_y		; Draw a circle of radius 4 ; incr y_cercle by 15


			; Draw eye_1
			; ----------
			moveq		#170-50,d3			; x_circle
			moveq		#68,d4				; y_circle
			bsr.s		draw_circle_rad_4		; Draw a circle of radius 4


			; Draw eye_2
			; ----------
			moveq		#150-50,d3			; x_circle
			bsr.s		draw_circle_rad_4		; Draw a circle of radius 4





		IFEQ	DEV_VERSION
mainloop:		bra.s		mainloop
		ENDC

		IFNE	DEV_VERSION
mainloop:
			; Tst keyboard
			cmp.b		#$39,$fffffc02.w		; exit by pressing SPACE key
			bne.s		mainloop

			; Quit
			clr.w	-(sp)					;pterm()
			trap	#1
		ENDC


; draw_triangle
;	Draw a triangle
;	Input : a4.l	screen pos
;		d1.w	y size

draw_triangle:
			clr.w		d7

.draw_tree_top_y:	move.l		a4,a3				; Screen pos
			move.w		d7,d5
			addq.w		#2,d7

.draw_tree_top_x:	move.w		#$03c0,(a3)+
			dbf		d5,.draw_tree_top_x

			lea.l		320*2-2(a4),a4
			dbf		d1,.draw_tree_top_y

			rts



; draw_circle
; 	dd 15 to y_circle
;	and call draw_circle_rad_4 to set the radius
;
draw_circle_rad_4_y:	add.w		#15,d4


; draw_circle
; 	Set a radius of 4
;	and call draw_circle
;
draw_circle_rad_4:	moveq		#4,d5


; draw_circle
; 	Draw a circle
;	Input :	d3.w	x_circle
;		d4.w	y_circle
;		d5.w	r_circle
;		a0.w	color
;
draw_circle:

.loop_dec_radius:
			sub.l		a1,a1				; x = 0
			move.w		d5,d1				; y = r
			move.w		d5,d2
			subq.w		#1,d2				; d = r-1

.while:			cmp.w		a1,d1
			blt.s		.end_draw_circle

			; Bas
			move.w		d4,d7				; Y_circle
			add.w		d1,d7				; y_circle + y
			move.w		a1,a2				; x
			bsr.s		draw_circle_part

			; Haut
			sub.w		d1,d7				; y_circle - y
			bsr.s		draw_circle_part


			; Milieu Bas
			add.w		a1,d7				; y_circle + x
			move.w		d1,a2				; y
			bsr.s		draw_circle_part


			; Milieu Haut
			sub.w		a1,d7				; y_circle - x
			bsr.s		draw_circle_part


			; if (d >= 2 * x)
			move.w		a1,d6
			add.w		d6,d6				; x*2
			cmp.w		d6,d2
			blt.s		.elseif
			; d -= 2 * x + 1;
			addq.w		#1,d6
			sub.w		d6,d2
			addq.w		#1,a1				; x++
			bra.s		.while

.elseif:		; else if (d < 2 * (r - y))
			move.w		d5,d6
			sub.w		d1,d6
			add.w		d6,d6
			cmp.w		d6,d2
			bge.s		.else
			; d += 2 * y - 1;
			move.w		d1,d6
			add.w		d6,d6
			subq.w		#1,d6
			bra.s		.endif

.else:			; d += 2 * (y - x - 1);
			move.w		d1,d6
			sub.w		a1,d6
			subq.w		#1,d6
			add.w		d6,d6
			addq.w		#1,a1				; x++
.endif:			add.w		d6,d2
			subq.w		#1,d1				; y--
			bra.s		.while

.end_draw_circle:
			; Decrement radius and loop until radius < 0
			dbf		d5,.loop_dec_radius

			rts



; draw_circle_part
;	optim
;	input 	d7.w
;		a2.w : x or y
;
draw_circle_part:
			mulu.w		#320,d7
			add.w		d3,d7				; y_circle - y + x_cercle
			move.w		d7,d6
			add.w		a2,d7				; y_circle - y + x_cercle + (x or y)
			move.w		a0,(a4,d7.l*2)
			sub.w		a2,d6				; y_circle - y + x_cercle - (x or y)
			move.w		a0,(a4,d6.l*2)

			move.w		d4,d7				; load Y_circle for later (optim)

			rts


; --------------------------------------------------------------
			section	data
; --------------------------------------------------------------

; --------------------------------------------------------------
			section	bss
; --------------------------------------------------------------
