{******************************************************************************}
{*                               TAdvCheckBox                                 *}
{*----------------------------------------------------------------------------*}
{* Author: Alexander Markus, maxx@linznet.at                                  *}
{* Last Change: 14.12.2000                                                    *}
{*----------------------------------------------------------------------------*}
{* This small Component fires an Event every time the State of the Checkbox   *}
{* changes.                                                                   *}
{*----------------------------------------------------------------------------*}
{* new Event:                                                                 *}
{*   OnChange: TNotifyEvent                                                   *}
{******************************************************************************}                                                     


unit AdvCheckBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type

  TAdvCheckBox = class(TCheckBox)
  private
    FOnChange: TNotifyEvent;
  protected
    procedure Toggle; override;
  public
    { Public-Deklarationen }
  published
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Beispiele', [TAdvCheckBox]);
end;


procedure TAdvCheckBox.Toggle;
begin
  inherited Toggle;
  if Assigned(FOnChange) then
    FOnChange(Self);
end;


end.
