;
; LOD Player Version 2
;
F1LO	= $FF0E
F1HI	= $FF12
F2LO	= $FF0F
F2HI	= $FF10

OFF	= $4F
	
; COMMAND BYTES

END_MARK	= $FE
SET_VOLTAB	= $FF
SET_ARP		= $FD
VOL_UP		= $FC
VOL_DN		= $FB
SET_FREQ_TABLE	= $FA
SETINS		= $F0
SETLEN		= $50

; Constants
base_note = 0 ; shift to F
C0	= base_note + 0
Ci0	= base_note + 1
D0	= base_note + 2
Di0	= base_note + 3
E0	= base_note + 4
F0	= base_note + 5
Fi0	= base_note + 6
G0	= base_note + 7
Gi0	= base_note + 8
A0	= base_note + 9
Ai0	= base_note + 10
B0	= base_note + 11

C1	= base_note + 12
Ci1	= base_note + 13
D1	= base_note + 14
Di1	= base_note + 15
E1	= base_note + 16
F1	= base_note + 17
Fi1	= base_note + 18
G1	= base_note + 19
Gi1	= base_note + 20
A1	= base_note + 21
Ai1	= base_note + 22
B1	= base_note + 23

C2	= base_note + 24
Ci2	= base_note + 25
D2	= base_note + 26
Di2	= base_note + 27
E2	= base_note + 28
F2	= base_note + 29
Fi2	= base_note + 30
G2	= base_note + 31
Gi2	= base_note + 32
A2	= base_note + 33
Ai2	= base_note + 34
B2	= base_note + 35

C3	= base_note + 36
Ci3	= base_note + 37
D3	= base_note + 38
Di3	= base_note + 39
E3	= base_note + 40
F3	= base_note + 41
Fi3	= base_note + 42
G3	= base_note + 43
Gi3	= base_note + 44
A3	= base_note + 45
Ai3	= base_note + 46
B3	= base_note + 47

C4	= base_note + 48
Ci4	= base_note + 49
D4	= base_note + 50
Di4	= base_note + 51
E4	= base_note + 52
F4	= base_note + 53
Fi4	= base_note + 54
G4	= base_note + 55
Gi4	= base_note + 56
A4	= base_note + 57
Ai4	= base_note + 58
B4	= base_note + 59

C5	= base_note + 60
Ci5	= base_note + 61
D5	= base_note + 62

;-----
          
	;ALIGN 256
PLAYER_INIT
	jmp ACTUAL_PLAYER_INIT
	
PLAYER
	jmp ACTUAL_PLAYER

ACTUAL_PLAYER_INIT
	ldx #$FF
	stx VOLTAB_CNT
	inx       
	stx NOTE1
	stx NOTE2
	stx NOTE3
	stx ARP_CNT
	stx FREQ_TABLE
	jsr res
	inx
	stx NOTELEN1
	stx NOTELEN2
	stx NOTELEN3
	jsr res
	;
	lda #19*9
	sta VOLUME
	;
	ldx #$02
	;	
set_freq_tables
	lda $FF07
	and #$40
	beq *+3
	inx
	;
	lda freq_tables_lo_lo,x
	sta frqlo1+1
	sta frqlo2+1
	sta frqlo3+1
	lda freq_tables_lo_hi,x
	sta frqlo1+2
	sta frqlo2+2
	sta frqlo3+2
	lda freq_tables_hi_lo,x
	sta frqhi1+1
	sta frqhi2+1
	sta frqhi3+1
	lda freq_tables_hi_hi,x
	sta frqhi1+2
	sta frqhi2+2
	sta frqhi3+2
	rts

freq_tables_lo_lo
	db freqs_lo_50_pal & 255
	db freqs_lo_60_ntsc & 255
	db freqs_lo_33_pal & 255
	db freqs_lo_40_ntsc & 255
freq_tables_lo_hi
	db freqs_lo_50_pal >> 8
	db freqs_lo_60_ntsc >> 8
	db freqs_lo_33_pal >> 8
	db freqs_lo_40_ntsc >> 8
freq_tables_hi_lo
	db freqs_hi_50_pal & 255
	db freqs_hi_60_ntsc & 255
	db freqs_hi_33_pal & 255
	db freqs_hi_40_ntsc & 255
freq_tables_hi_hi
	db freqs_hi_50_pal >> 8
	db freqs_hi_60_ntsc >> 8
	db freqs_hi_33_pal >> 8
	db freqs_hi_40_ntsc >> 8
	
ch_ptrs_lo
	db Channel1 & 255
	db Channel2 & 255
	
ch_ptrs_hi
	db Channel1 >> 8
	db Channel2 >> 8

res	
	lda ch_ptrs_lo,x
	sta PCH1_LO,x
	lda ch_ptrs_hi,x
	sta PCH1_HI,x
	;
advance	
	lda PCH1_LO,x
	sta PCH_TEMP
	lda PCH1_HI,x
	sta PCH_TEMP+1
	;
	ldy #$01
	lda (PCH_TEMP),y	; HI byte
	beq res			; when high byte is zero, it's the end of the Channel
	sta CH1_HI,x
	dey
	lda (PCH_TEMP),y	; LO byte
	sta CH1_LO,x
	;
	lda PCH1_LO,x
	clc
	adc #$02
	sta PCH1_LO,x
	bcc *+4
	inc PCH1_HI,x
	rts
	
	;
	;##################
	;

ACTUAL_PLAYER
	;rts
	;lda $FF19
	;sta *+17
	;lda #$67
	;sta $FF19
	;eor #$32^$67
	;sta *-6
	;jsr PLAYER_
	;lda #$00
	;sta $FF19
	;rts
;PLAYER_
	ldx #$01
channel_loop
	inc NOTE1,x
	;
	lda NOTE1,x
	cmp NOTELEN1,x
	beq next_note
	jmp channel_loop_end
	;
next_note 
	lda CH1_LO,x
	sta CH_TEMP
	lda CH1_HI,x
	sta CH_TEMP+1
	;
	ldy #$00
	sty NOTE1,x		; reset note counter
	;   
	lda (CH_TEMP),y		; get byte
	iny
	;
	cmp #END_MARK		; $FF goes to new pattern
	bne pl_10
	;
	jsr advance
	bne next_note		; should never be zero
	;
pl_10	
	cmp #SET_VOLTAB
	bne pl_12
	;
	sta VOLTAB_CNT
	;
	lda (CH_TEMP),y		; get lo byte
	iny
	sta VOL_TAB+1
	;
	lda (CH_TEMP),y		; get hi byte
	iny
	sta VOL_TAB+2
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_12	
	cmp #SET_ARP		; instrument change?
	bne pl_13
	;
	lda (CH_TEMP),y		; get arpeggio byte
	and #$0F
	sta arpeggio_data+0
	;
	lda (CH_TEMP),y		; get same byte again
	lsr a
	lsr a
	lsr a
	lsr a
	sta arpeggio_data+1
	;
	iny
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_13	
	cmp #VOL_UP
	bne pl_14
	;
	lda VOLUME
	beq vol_at_max
	;
	sec
	sbc #$09
	sta VOLUME
	;
vol_at_max
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_14
	cmp #VOL_DN
	bne pl_15
	;
	lda VOLUME
	cmp #20*9
	beq vol_at_min
	;
	clc
	adc #$09
	sta VOLUME
	;
vol_at_min
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_15	
	cmp #SET_FREQ_TABLE
	bne pl_11
	;
	txa
	pha
	lda (CH_TEMP),y		; get byte
	tax
	jsr set_freq_tables
	pla
	tax
	iny
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_11	
	cmp #SETINS		; instrument change?
	bcc pl_01
	;
	and #$0F		; keep lower 4 bits
	sta INS_TYPE1,x   	; store instrument type
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_01	cmp #SETLEN		; set note length?
	bcc pl_02
	;
	;sec			; we know carry is always set
	sbc #SETLEN
	sta NOTELEN1,x
	;
	lda (CH_TEMP),y
	iny
	;
pl_02	; - store note!
	;
	sta TONE1,x
	;
	; --- advance pointer
	;
	tya
	clc
	adc CH1_LO,x
	sta CH1_LO,x
	bcc noi_1
	inc CH1_HI,x
noi_1	;
	;
	; -----------------------------------------------------------------
	;
channel_loop_end
	dex
	bmi pl_50
	jmp channel_loop
	;    
pl_50	
	;
	; --- SOUND PROCESSING
	;
PLAYER_SOUND
	lda #$20
	sta NOISE
	;
;	ldx #$02		; channel 3
;	jsr sound
;	;
;	cmp #$FE
;	bne do_ch2
	;
	ldx #$01		; channel 2
	jsr sound
	;
do_ch2	sta F1LO_store+1
	sty F1HI_x+1
	;
	lda F1HI
	and #$FC
F1HI_x	ora #$00
	sta F1HI_store+1
	;
F1LO_store
	lda #$00
	sta F1LO
F1HI_store
	lda #$00
	sta F1HI
	;
	; ---
	;
	ldx #$00		; channel 1
	jsr sound
	sta F2LO
	sty F2HI
	;
	; ---
	;    
	;INC TICK1
	;INC TICK2
	;
	; ---
	;
	ldy VOLTAB_CNT
	iny
res_v	
VOL_TAB
	lda vol_default,y
	bpl noi_v		; check for $FF
	ldy #$00		; reached, so warp
	beq res_v
noi_v	sty VOLTAB_CNT
	clc
	adc VOLUME
	tay
	lda volume_map,y
	ora NOISE
	;
	ldy F1LO
	cpy #$FE
	bne setvol		; not silent
	ldy F2LO
	cpy #$FE
	beq sil			; silent: skip setting $FF11 to avoid clicks
	;
setvol	sta $FF11		; self-mod
	;
sil	rts     
	;
inst_table
	dw normal, bassdrum, snare, hihat, arpeggio, vibrato1, vibrato2, vibrato3, arpCC
	;
sound	lda TONE1,x
	cmp #OFF
	beq lookup
	;
	lda INS_TYPE1,x
	asl a
	tay
	lda inst_table,y
	sta inst_jump+1
	lda inst_table+1,y
	sta inst_jump+2
	;
inst_jump
	jmp $0000
	
	;
	; ---
	;
normal	lda TONE1,x		; normal note
lookup	tax
frqlo1	lda $FFFF,x
frqhi1	ldy $FFFF,x
	rts
	;
	; ---
	;
;blipp	lda TONE1,x
;	ldy NOTE1,x
;	cpy #$03
;	bcs blipp_off
;	cpy #$02
;	bcc lookup
;	clc
;	adc #$0C
;	bne lookup
;	
;blipp_off
;	lda #OFF
;	bne lookup
;	;
;	; ---
;	;
arpCC
	ldy #$00
	lda NOTE1,x
	and #$04
	beq arpCC1
	ldy #$0C
arpCC1	tya
	clc
	adc TONE1,x
	bne lookup
	
arpeggio
	lda ARP_CNT		; load current arp counter
	clc
	adc #$01
	cmp #3*8		; reset at this frame
	bne *+4
	lda #$00
	sta ARP_CNT
	tay
	lda div8,y
	tay
	lda arpeggio_data,y	; for channel 2 (self-mod)
	clc
	adc TONE1,x
	bne lookup
	;
	; ---
	;
vibrato3
	lda NOTE1,x
	and #$0F
	tay
	lda vibrato3_data,y
	bmi vib_sub1
	bpl vib_add
	
vibrato2
	lda NOTE1,x
	and #$0F
	tay
	lda vibrato2_data,y
	bmi vib_sub1
	bpl vib_add
	
vibrato1
	lda NOTE1,x
	and #$1F
	tay
	lda vibrato1_data,y
	bmi vib_sub1
	;
vib_add
	sta vib2+1
	;
	lda TONE1,x
	tax
frqhi2	ldy $FFFF,x
frqlo2	lda $FFFF,x
	clc
vib2	adc #$01
	bcc *+3
	iny
	rts
	;
vib_sub1
	and #$7F
	;      
	sta vib4+1
	;
	lda TONE1,x
	tax
frqhi3	ldy $FFFF,x
frqlo3	lda $FFFF,x
	sec
vib4	sbc #$01
	bcs *+3
	dey
	rts
	;
	; ---
	;
hihat
	lda #$40
	sta NOISE
	lda TONE1,x
	beq hihat1
	;
	and #$03
	tay
	lda TONE1,x
	asl a
	asl a
	rts
	;
hihat1	lda NOTE1,x
	tax
	lda hihat_freq,x
	ldy #$03
	rts
	;
	; ---
	;
snare	
	lda NOTE1,x
	asl a
	tax
	lda snare_data+1,x	; 16 bit add: add snare freq
	and #$60
	sta NOISE
	lda snare_data+1,x	; 16 bit add: add snare freq
	and #$03
	tay
	lda snare_data,x
	clc
	adc TONE1
	rts
	;
	; ---
	;
bassdrum
	lda NOTE1,x
	asl a
	tax
	lda bass_freq,x
	ldy bass_freq+1,x
	rts

div8
	db 0,0,0,0,0,0,0,0
	db 1,1,1,1,1,1,1,1
	db 2,2,2,2,2,2,2,2

vibrato1_data
	db $00,$00,$01,$01,$01,$01,$02,$02
	db $02,$02,$01,$01,$01,$01,$00,$00
	db $00,$00,$81,$81,$81,$81,$82,$82
	db $82,$82,$81,$81,$81,$81,$00,$00
	
vibrato2_data
	db $00,$00,$00,$01,$01,$01,$01,$01
	db $01,$01,$01,$01,$01,$00,$00,$00
	db $00,$00,$00,$81,$81,$81,$81,$81
	db $81,$81,$81,$81,$81,$00,$00,$00
	
vibrato3_data
	db $00,$02,$04,$05,$05,$05,$04,$02
	db $00,$82,$84,$85,$85,$85,$84,$82
;[eof]