//***************************************************************************
// "scenery.c"
// Code for foreground scenery objects.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

// Required headers
#include <stddef.h>
#include "level.h"
#include "objects.h"

//***************************************************************************
// run_small_scenery
// Logic for small scenery objects.
//---------------------------------------------------------------------------
// To-do: rework level code so the sprite can be loaded on init and we can
// remove this function (so the code is called only once)
//---------------------------------------------------------------------------
// param obj: pointer to this object
//***************************************************************************

void run_small_scenery(Object *obj) {
   // Set animation
   if (obj->frame == NULL)
      set_object_anim(obj, retrieve_level_anim(LV_ANIM_SMALLSCENERY));
}

//***************************************************************************
// run_big_scenery
// Logic for big scenery objects.
//---------------------------------------------------------------------------
// To-do: rework level code so the sprite can be loaded on init and we can
// remove this function (so the code is called only once)
//---------------------------------------------------------------------------
// param obj: pointer to this object
//***************************************************************************

void run_big_scenery(Object *obj) {
   // Set animation
   if (obj->frame == NULL)
      set_object_anim(obj, retrieve_level_anim(LV_ANIM_BIGSCENERY));
}

//***************************************************************************
// init_warning
// Initializes a warning sign.
//---------------------------------------------------------------------------
// param obj: pointer to this object
//***************************************************************************

void init_warning(Object *obj) {
   // Set animation
   set_object_anim(obj, retrieve_object_anim(OB_ANIM_WARNING));
}
