//***************************************************************************
// "scene.h"
// Header file for the scene list.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef SCENE_H
#define SCENE_H

// Required headers
#include <stddef.h>

// Possible scene types
typedef enum {
   SCENE_END,           // End of game
   SCENE_LEVEL,         // Level
   SCENE_BONUS,         // Bonus level
   SCENE_CUTSCENE       // Cutscene
} SceneType;

// Used to keep track of the current scene
extern size_t curr_scene;

// Function prototypes
void load_scene_list(void);
void switch_to_scene(size_t);
void switch_to_next_scene(void);
void switch_to_first_level(void);
SceneType get_scene_type(void);
SceneType get_scene_type_by_id(size_t);
const char *get_scene_id(void);
const char *get_scene_name(void);
unsigned get_scene_number(void);
unsigned get_curr_scene(void);
size_t get_num_scenes(void);
void unload_scene_list(void);

#endif
