//***************************************************************************
// "savegame.h"
// Declarations regarding savegames
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef SAVEGAME_H
#define SAVEGAME_H

// Required headers
#include <stdint.h>

// Data stored in a savegame
typedef struct {
   uint8_t last_scene;        // Last scene reached (accessible)
   uint8_t curr_scene;        // Last scene played
   uint16_t checkpoint_x;     // Checkpoint X coordinate (0xFFFF if none)
   uint16_t checkpoint_y;     // Checkpoint Y coordinate (0xFFFF if none)
} SaveGame;

// Function prototypes
void invalidate_savegame(void);
void set_savegame_name(const char *);
void load_savegame(void);
void save_savegame(const SaveGame *);
void get_savegame(SaveGame *);
void set_savegame_scene(unsigned);
void advance_savegame_scene(void);

#endif
