//***************************************************************************
// "platforms.h"
// Definitions for collidable objects (platforms, pushables, etc.).
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef PLATFORMS_H
#define PLATFORMS_H

// Required headers
#include "level.h"
#include "objects.h"

// Function prototypes
void init_pushable(Object *);
void run_pushable(Object *);
void init_platform(Object *);
void run_platform(Object *);
void run_horizontal_platform(Object *);
void run_vertical_platform(Object *);
void run_breakable_platform(Object *);
void init_platform_leftover(Object *);
void init_obstruction(Object *);
void break_obstruction(LevelTile *, int32_t, int32_t);
void init_obstruction_leftover(Object *);
void init_door(Object *);
void run_door(Object *);
void init_generator(Object *);
void run_generator(Object *);

#endif
