//***************************************************************************
// "editor_choices.h"
// Choice grid layouts for the level editor
//---------------------------------------------------------------------------
// DO NOT INCLUDE ANYWHERE EXCEPT IN EDITOR.C
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

// Choice grid data for collision tiles
static const uint8_t choices_coll[] = {
   3,                      // Number of rows

   6,                      // Number of items in row
   TILE_EMPTY,             // Empty
   TILE_SOLID,             // Solid
   TILE_NWSE_1,            // 2:1 NWSE slope (left half)
   TILE_NWSE_2,            // 2:1 NWSE slope (right half)
   TILE_NESW_2,            // 2:1 NESW slope (left half)
   TILE_NESW_1,            // 2:1 NESW slope (right half)

   6,                      // Number of items in row
   TILE_EMPTY_BG,          // Empty w/background
   TILE_FLOOR_BG,          // Thin floor w/background
   TILE_NWSE_1_BG,         // 2:1 NWSE slope (left half) w/background
   TILE_NWSE_2_BG,         // 2:1 NWSE slope (right half) w/background
   TILE_NESW_2_BG,         // 2:1 NESW slope (left half) w/background
   TILE_NESW_1_BG,         // 2:1 NESW slope (right half) w/background

   4,                      // Number of items in row
   TILE_HIDDEN,            // Hidden passage
   TILE_BRIDGE,            // Bridge
   TILE_BELT_LEFT,         // Conveyor belt (going left)
   TILE_BELT_RIGHT         // Conveyor belt (going right)
};

// Choice grid for item objects
static const uint8_t choices_items[] = {
   3,                      // Number of rows

   5,                      // Number of items in row
   LVOBJ_HEART,            // Item: heart
   LVOBJ_INVINCIBILITY,    // Item: invincibility
   LVOBJ_SHIELD,           // Item: shield
   LVOBJ_DANCER,           // Item: dancer
   LVOBJ_BLUESTAR,         // Item: blue star

   5,                      // Number of items in row
   LVOBJ_CHECKPOINT,       // Item: checkpoint
   LVOBJ_GOAL,             // Item: goal
   LVOBJ_SPRING,           // Item: spring
   LVOBJ_SSPRING,          // Item: superspring
   LVOBJ_BALLOON,          // Item: balloon

   4,                      // Number of items in row
   LVOBJ_WINGS,            // Item: wings power-up
   LVOBJ_SPIDERPOW,        // Item: spider power-up
   LVOBJ_HAMMER,           // Item: hammer power-up
   LVOBJ_PARASOL           // Item: parasol power-up
};

// Choice grid for scenery objects
static const uint8_t choices_scenery[] = {
   3,                      // Number of rows

   4,                      // Number of items in row
   LVOBJ_PLATFORM,         // Platform: idle platform
   LVOBJ_PLATFORM_H,       // Platform: horizontal moving platform
   LVOBJ_PLATFORM_V,       // Platform: vertical moving platform
   LVOBJ_PLATFORM_B,       // Platform: breakable platform

   4,                      // Number of items in row
   LVOBJ_PUSHABLE,         // Platform: pushable
   LVOBJ_OBSTRUCTION,      // Platform: obstruction
   LVOBJ_SCENERYSMALL,     // Scenery: small
   LVOBJ_SCENERYBIG,       // Scenery: big

   2,                      // Number of items in row
   LVOBJ_GENERATOR,        // Generator
   LVOBJ_MAINGENERATOR     // Main generator
};

// Choice grid for enemy objects
static const uint8_t choices_enemies[] = {
   4,                      // Number of rows

   4,                      // Number of items in row
   LVOBJ_FLAMER,           // Enemy: flamer
   LVOBJ_SPRAYER,          // Enemy: sprayer
   LVOBJ_TURRET,           // Enemy: turret
   LVOBJ_ROLLER,           // Enemy: roller

   4,                      // Number of items in row
   LVOBJ_GRABBER,          // Enemy: grabber
   LVOBJ_SPIDER,           // Enemy: spider
   LVOBJ_HEATER,           // Enemy: heater
   LVOBJ_BOMB,             // Enemy: bomb

   3,                      // Number of items in row
   LVOBJ_BOSS1,            // Bulldozer boss
   LVOBJ_BOSS2,            // Trash truck boss
   LVOBJ_BOSS3,            // Ship boss

   3,                      // Number of items in row
   LVOBJ_BOSS4,            // Oil truck boss
   LVOBJ_BOSS5,            // Driller boss
   LVOBJ_BOSS6             // Mr. Evil
};

// Choice grid for hazard objects
static const uint8_t choices_hazards[] = {
   4,                      // Number of rows

   4,                      // Number of items in row
   LVOBJ_FIRE,             // Hazard: fire
   LVOBJ_LIQUIDHAZARD,     // Hazard: liquid
   LVOBJ_BOUNCINGHAZARD,   // Hazard: bouncing
   LVOBJ_STALACTITE,       // Hazard: stalactite

   4,                      // Number of items in row
   LVOBJ_SPIKES_U,         // Hazard: spikes pointing upwards
   LVOBJ_SPIKES_D,         // Hazard: spikes pointing downwards
   LVOBJ_SPIKES_L,         // Hazard: spikes pointing left
   LVOBJ_SPIKES_R,         // Hazard: spikes pointing right

   4,                      // Number of items in row
   LVOBJ_CRUSHER,          // Hazard: crusher
   LVOBJ_BUZZSAW,          // Hazard: buzzsaw (static)
   LVOBJ_BUZZSAW_C,        // Hazard: buzzsaw (ceiling)
   LVOBJ_BUZZSAW_F,        // Hazard: buzzsaw (floor)

   2,                      // Number of items in row
   LVOBJ_COIL_F,           // Hazard: coil (floor)
   LVOBJ_COIL_C            // Hazard: coil (ceiling)
};

// Choice grid for switch objects
static const uint8_t choices_switches[] = {
   4,                      // Number of rows

   4,                      // Number of items in row
   LVOBJ_SWITCH_1,         // Item: switch #1
   LVOBJ_SWITCH_2,         // Item: switch #2
   LVOBJ_SWITCH_3,         // Item: switch #3
   LVOBJ_SWITCH_4,         // Item: switch #4

   4,                      // Number of items in row
   LVOBJ_SWITCH_5,         // Item: switch #5
   LVOBJ_SWITCH_6,         // Item: switch #6
   LVOBJ_SWITCH_7,         // Item: switch #7
   LVOBJ_SWITCH_8,         // Item: switch #8

   4,                      // Number of items in row
   LVOBJ_DOOR_1,           // Platform: door
   LVOBJ_DOOR_2,           // Platform: door
   LVOBJ_DOOR_3,           // Platform: door
   LVOBJ_DOOR_4,           // Platform: door

   4,                      // Number of items in row
   LVOBJ_DOOR_5,           // Platform: door
   LVOBJ_DOOR_6,           // Platform: door
   LVOBJ_DOOR_7,           // Platform: door
   LVOBJ_DOOR_8            // Platform: door
};
