//***************************************************************************
// "bosses.h"
// Code for boss objects.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef BOSSES_H
#define BOSSES_H

// Required headers
#include "objects.h"

// Function prototypes
void load_bosses(void);
void unload_bosses(void);
void init_boss_spawn(Object *);
void run_boss_spawn(Object *);
void run_boss1(Object *);
void run_boss2(Object *);
void run_boss3(Object *);
void run_boss4(Object *);
void run_boss5(Object *);
void hurt_boss(Object *);
void init_ship(Object *);
void run_ship(Object *);
void init_grenade(Object *);
void run_grenade(Object *);
void init_boss4_trailer(Object *);
void run_boss4_trailer(Object *);
void init_boss6(Object *);
void run_boss6(Object *);
void init_mrevil_base(Object *);
void run_mrevil_base(Object *);
void init_mrevil_flame(Object *);
void run_mrevil_flame(Object *);
void run_mrevil_launcher(Object *);
void run_mrevil_hand(Object *);
void run_mrevil_evil(Object *);
void init_missile_in(Object *);
void run_missile_in(Object *);
void init_missile_out(Object *);
void run_missile_out(Object *);
void init_driver(Object *);

#endif
