//***************************************************************************
// "audiovideo.h"
// So audiovideo definitions can be included without having to bring in all
// of video.h and sound.h (both headers used just about everywhere)
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef AUDIOVIDEO_H
#define AUDIOVIDEO_H

// Audiovideo screen size
#define AV_WIDTH 40
#define AV_HEIGHT 25
#define AV_BUFSIZE (AV_WIDTH * (AV_HEIGHT+1))

// Audiovideo colors
enum {
   AV_EMPTY,      // Emptiness
   AV_LEVEL,      // Level layout
   AV_GOODIE,     // Thing that helps
   AV_DANGER,     // Dangerous thing

   AV_GAP,        // Gap in the map
   AV_CEIL,       // Ceiling in the map
   AV_SLOPE,      // Slope boundary
   AV_HAZARD,     // Hazardous scenery

   NUM_AVCOLORS   // Colors must be below this value
};

// Used to keep the information needed for the audiovideo status
typedef unsigned AVStatus[AV_HEIGHT][NUM_AVCOLORS][2];

#endif
