const X = 0, Y = 1, Z = 2;
const R = 0, G = 1, B = 2, A = 3;

const { round, floor, ceil, abs, sign, sin, cos, tan, asin, acos, atan, atan2, sqrt, PI, log, log2, pow, exp, random, min, max } = Math;
const TAU = PI*2;
const SQRT2 = sqrt(2);
const SQRT3 = sqrt(3);

const fract = (n) => n - floor(abs(n));


const saw = (n, m) => (n%m + m)%m;
const saw2 = ([nx, ny], [mx, my]) => [ (nx%mx + mx)%mx, (ny%my + my)%my ];
// const tri = (n, m) => (n%(m*2) + m)%m;


const is = (a, b, e=0.001) => abs(a[X] - b[X]) < e && abs(a[Y] - b[Y]) < e;

const add = (a, b) => [ a[X] + b[X], a[Y] + b[Y] ];
const sub = (a, b) => [ a[X] - b[X], a[Y] - b[Y] ];
const scl = (v, s) => [ v[X]*s, v[Y]*s ];
const len = ([ x, y ]) => sqrt(x*x + y*y);
const dst = (a, b) => sqrt((a[X] - b[X])**2 + (a[Y] - b[Y])**2);

const mul = (a, b) => [ a[X]*b[X], a[Y]*b[Y] ];
const div = (a, b) => [ a[X]/b[X], a[Y]/b[Y] ];

const lenSqr = ([ x, y ]) => x*x + y*y;
const dstSqr = (a, b) => (a[X] - b[X])**2 + (a[Y] - b[Y])**2;
const normalize = v => scl(v, 1/len(v));

const a2v = (a, r = 1) => [ cos(a)*r, sin(a)*r ];
const v2a = v => atan2(v[Y], v[X]);

const dot = (a, b) => a[X]*b[X] + a[Y]*b[Y];

const rot = (p, a) => [ p[X]*cos(a) - p[Y]*sin(a), p[Y]*cos(a) + p[X]*sin(a) ];
const perp = ([ x, y ]) => [-y, x ];


const add3 = (a, b) => [ a[X] + b[X], a[Y] + b[Y], a[Z] + b[Z] ];
const sub3 = (a, b) => [ a[X] - b[X], a[Y] - b[Y], a[Z] - b[Z] ];
const scl3 = (v, s) => [ v[X]*s, v[Y]*s, v[Z]*s ];
const len3 = ([ x, y, z ]) => sqrt(x*x + y*y + z*z);
const dst3 = (a, b) => sqrt((a[X] - b[X])**2 + (a[Y] - b[Y])**2 + (a[Z] - b[Z])**2);

const mul3 = (a, b) => [ a[X]*b[X], a[Y]*b[Y], a[Z]*b[Z] ];
const div3 = (a, b) => [ a[X]/b[X], a[Y]/b[Y], a[Z]/b[Z] ];

const lenSqr3 = ([ x, y, z ]) => x*x + y*y + z*z;
const dstSqr3 = (a, b) => (a[X] - b[X])**2 + (a[Y] - b[Y])**2 + (a[Z] - b[Z])**2;
const normalize3 = v => scl(v, 1/len3(v));



const polygonContainsP = (shapeP, shapeA, vertices, p) => {
  p = sub(p, shapeP);
  p = rot(p, -shapeA);

  let intersections = 0;
  for (let i = 0; i < vertices.length; ++i) {
    let a = vertices[saw(i, vertices.length)];
    let b = vertices[saw(i + 1, vertices.length)];

    if ((a[Y] <= p[Y] && b[Y] <= p[Y] )
      || (a[Y] >= p[Y] && b[Y] >= p[Y] )
      || (a[Y] == p[Y] && b[Y] == p[Y])) continue;

    if (p[X] < a[X] && p[X] < b[X]) intersections++;
    else {
      let d = sub(b, a);

      let dy = b[Y] - a[Y];
      let dyPrime = p[Y] - a[Y];
      let projected = add(a, scl(d, dyPrime/dy));
      if (p[X] < projected[X]) intersections++;
    }
  }

  return intersections%2;
};

const segSegIntersection = ([ a0, a1 ], [ b0, b1 ]) => {
  let dA = sub(a1, a0);
  let dB = sub(b1, b0);

  let dirA = normalize(dA);

  let dA0B0 = sub(b0, a0);

  let lenA0S = dot(dA, dA0B0)/len(dA);
  let s = add(a0, scl(dirA, lenA0S));
  let dB0S = sub(s, b0);

  let lenB0M = dot(dB0S, dB)/len(dB0S);

  let bT = len(dB0S)/lenB0M;
  let intersect = add(b0, scl(dB, bT));
  let dA0Intersect = sub(intersect, a0);
  let aT = len(dA0Intersect)/len(dA);
  
  aT *= sign(dot(dA, dA0Intersect));

  // ctx.beginPath();
  // ctx.arc(...s, 2, 0, TAU);
  // ctx.fill();
  // ctx.beginPath();
  // ctx.arc(...intersect, 2, 0, TAU);
  // ctx.fill();

  // ctx.beginPath();
  // ctx.moveTo(...a0);
  // ctx.lineTo(...a1);
  // ctx.stroke();
  // ctx.beginPath();
  // ctx.moveTo(...b0);
  // ctx.lineTo(...s);
  // ctx.stroke();
  // ctx.beginPath();
  // ctx.moveTo(...b0);
  // ctx.lineTo(...b1);
  // ctx.stroke();


  return [ intersect, aT, bT ];
};

const polygonSegIntersection = (shapeP, shapeA, vertices, seg) => {
  seg = seg.map(p => sub(p, shapeP));
  seg = seg.map(p => rot(p, -shapeA));


  let intersectionP;
  let intersected;
  let smallestD = Infinity;
  let vt;
  
  for (let i = vertices.length - 1, j = 0; j < vertices.length; i = j++) {
    let v0 = vertices[i];
    let v1 = vertices[j];
    let [ p, ds, dv ] = segSegIntersection(seg, [ v0, v1 ]);

    if (ds > 0 && dv > 0 && dv <= 1 && ds <= smallestD) {
      smallestD = ds;
      intersectionP = p;
      intersected = [ v0, v1 ];
      vt = dv;

    }
  }

  return [intersectionP, intersected, smallestD, vt];
};


const discSegIntersection = (p, r, seg) => {
  let d0 = dst(p, seg[0]), d1 = dst(p, seg[1]);
  if (false && d0 < r || d1 < r) {
    if (d0 < d1) {
      let delta = sub(seg[0], p);
      let intercept = add(p, scl(normalize(delta), r));
      return [ intercept, d0 - r ];
    } else {
      let delta = sub(seg[1], p);
      let intercept = add(p, scl(normalize(delta), r));
      return [ intercept, d1 - r ];
    }
  } else {
    let dseg = sub(seg[1], seg[0]);
    let segLen = len(dseg);
    let projectionD = dot(dseg, sub(p, seg[0]));
    let projectionP = add(seg[0], scl(dseg, projectionD/segLen/segLen));
    let obj2project = dst(projectionP, p);
  
    if (obj2project <= r) {
      let side = sqrt(r**2 - dst(p, projectionP)**2);
      let intercept = sub(projectionP, scl(dseg, side/segLen));
  
      let distance = dst(intercept, seg[0]);
      if (distance < segLen) return [ intercept, distance ];
    }
  }
};

const discContainsP = (disc, p) => dst(disc.p, p) <= disc.r;
const rectContainsP = (rect, p) => {
  let rel = sub(p, rect.p);
  return -rect.r[X] < rel[X] && rel[X] <= rect.r[X]
    && -rect.r[Y] < rel[Y] && rel[Y] <= rect.r[Y];
};
const discOverlapsRect = (p, r, rect) => {
  let result = rectContainsP({ p: rect.p, r: add(rect.r, [ r, 0 ]) }, p);
  result = result || rectContainsP({ p: rect.p, r: add(rect.r, [ 0, r ]) }, p)
  
  result = result || discContainsP({ p: add(rect.p, mul(rect.r, [-1,-1 ])), r }, p );
  result = result || discContainsP({ p: add(rect.p, mul(rect.r, [-1, 1 ])), r }, p );
  result = result || discContainsP({ p: add(rect.p, mul(rect.r, [ 1,-1 ])), r }, p );
  result = result || discContainsP({ p: add(rect.p, mul(rect.r, [ 1, 1 ])), r }, p );

  return result;
};
const rectOverlapsRect = (p1, r1, p2, r2) => rectContainsP({ p: p1, r: add(r1, r2) }, p2);


const segOverlapsRect = (seg, rect) => {
  let result = rectContainsP(rect, seg[0]) || rectContainsP(rect, seg[1]);
  let corners = [
    [-1,-1 ],
    [ 1,-1 ],
    [ 1, 1 ],
    [-1, 1 ],
  ];

  for (let i = 3, j = 0; j < 4; i = j++) {
    let c0 = corners[i], c1 = corners[j];
    let rectSide = [ add(rect.p, mul(c0, rect.r)), add(rect.p, mul(c1, rect.r)) ];
    let [ intersect, aT, bT ]  = segSegIntersection(seg, rectSide);
    
    result = result || 0 < aT && aT <= 1 && 0 < bT && bT <= 1;
  }

  return result;
}

const O8 = [
  [ 1, 0 ],
  [ 1, 1 ],
  [ 0, 1 ],
  [-1, 1 ],
  [-1, 0 ],
  [-1,-1 ],
  [ 0,-1 ],
  [ 1,-1 ],
];
const D8 = O8.map(dir => normalize(dir));
const A8 = new Array(8).fill().map((n, i) => i*TAU/8);

const O6 = [
  [ 1, 0 ],
  [ 0, 1 ],
  [-1, 1 ],
  [-1, 0 ],
  [ 0,-1 ],
  [ 1,-1 ],
];

const O4 = D4 = [
  [ 1, 0 ],
  [ 0, 1 ],
  [-1, 0 ],
  [ 0,-1 ],
];


const hex2p = ([ x, y ], s = 1) => [
  s*(SQRT3*x + (SQRT3/2)*y),
  s*(3/2)*y,
];
const p2hex = ([ x, y ], s = 1) => {
  let _y = y/s/(3/2);
  let _x = x/s;
  _x -= _y*(SQRT3/2);
  _x /= SQRT3;
  return [
    _x,
    _y,
  ];
};

const mix3 = (a, b, t) => [
  a[X]*(1 - t) + b[X]*t,
  a[Y]*(1 - t) + b[Y]*t,
  a[Z]*(1 - t) + b[Z]*t
]; 
const lerp1 = (a, b, t) => a*(1 - t) + b*t;
const lerp = (a, b, t) => add(scl(a, 1 - t), scl(b, t));
const lerp3 = (a, b, t) => add3(scl3(a, 1 - t), scl3(b, t));
const interpolateBezier = (curve, t) => {
  while (curve.length > 1) {
    let interpolatedPoints = new Array(curve.length - 1);
    for (let i = 0; i < interpolatedPoints.length; ++i) {
      interpolatedPoints[i] = lerp(curve[i], curve[i + 1], t);
    }

    curve = interpolatedPoints;
  }

  return curve[0];
}

const clamp1 = (minS, maxS, s) => min(maxS, max(minS, s));
const clamp2 = ([ minX, minY ], [ maxX, maxY ], v) => [
  min(maxX, max(minX, v[X])),
  min(maxY, max(minY, v[Y])),
];


const polygonFromDim = dim => [
  [-dim[X]/2,-dim[Y]/2 ],
  [ dim[X]/2,-dim[Y]/2 ],
  [ dim[X]/2, dim[Y]/2 ],
  [-dim[X]/2, dim[Y]/2 ]
];
const insideOutPolygonFromDim = dim => [
  [-dim[X]/2,-dim[Y]/2 ],
  [-dim[X]/2, dim[Y]/2 ],
  [ dim[X]/2, dim[Y]/2 ],
  [ dim[X]/2,-dim[Y]/2 ]
];

const pickRandom = ls => ls[floor(random()*ls.length)];
const pickWeighted = (weights, total = 1) => {
  let r = random()*total;
  let sum = 0;
  for (let i = 0; i < weights.length; ++i) {
    sum += weights[i];

    if (sum > r) return i;
  }

  invalidCodePath();
}

const weightedSample = (choices, weights, total = 0, random = Math.random) => {
  if (total <= 0) total = weights.reduce((sum, w) => sum + w, 0);

  let sample = random()*total;
  let sum = 0;
  for (let i = 0; i < weights.length; ++i) {
    sum += weights[i];

    if (sum > sample) return choices[i];
  }

  invalidCodePath();
};


let Random = {
  coin: (p = 0.5) => random() < p,
  pick: pickRandom,
  uniformI2: ([ maxX, maxY ]) => [
    floor(maxX*random()),
    floor(maxY*random())
  ],
  uniform: () => random(),
  uniform2: () => [ random(), random() ],
  uniformITo: (to) => floor(random()*to),
  uniformTo: (to) => random()*to,
  uniformBetween: (from, to) => from + random()*(to - from),
  bilat: () => 2*random() - 1,
  unilat: () => random(),
  bilat2: () => [ 2*random() - 1, 2*random() - 1 ],
  bilat3: () => [ 2*random() - 1, 2*random() - 1, 2*random() - 1 ],
  unilat2: () => [ random(), random() ],
  unit2D: () => a2v(random()*TAU),
};



const Noise = (seed) => {
  if (seed == undefined) seed = random();

  const hash11 = (p) => {
    p += seed;
    p = fract(p*.1031);
    p *= p + 33.33;
    p *= p + p;
    return fract(p);
  };


  // https://www.shadertoy.com/view/4djSRW
  const hash12 = (p) => {
    // vec3 p3  = fract(vec3(p.xyx) * .1031);
    //   p3 += dot(p3, p3.yzx + 33.33);
    // return fract((p3.x + p3.y) * p3.z);

    p = [p[X], p[Y]];

    p[X] += seed;
    p[Y] += 1/seed;
    
    let v00 = fract(p[X]*.1031);
    let v01 = fract(p[Y]*.1031);
  
    let dotres = v00*(v01 + 33.33) + v01*(v00 + 33.33) + v00*(v00 + 33.33);
    let v10 = v00 + dotres;
    let v11 = v01 + dotres;
  
    return fract((v10 + v11)*v10);
  };

  
  let i = 0;
  const uniform = () => hash11(13*i++);
  const pick = (ls) =>  {
    let index = floor(uniform()*ls.length);
    return ls[index];
  };

  return { hash11, hash12, seed, uniform, pick };
};
