/* framework header */
#version 430
layout(location = 0) out vec4 fragColor;
layout(location = 0) uniform vec4 iResolution;
layout(location = 1) uniform int iFrame;

/* vvv your shader goes here vvv */

const float EPSILON=.001;
const int MAX_STEPS=60;

float smin(float a,float b,float k)
{
    float h=max(k-abs(a-b),0.)/k;
    return min(a,b)-h*h*k*(1./4.);
}

float sdSphere(vec3 p, float r)
{
    return length(p) - r;
}

float sdEllipsoid(vec3 p,vec3 r)
{
    float k0=length(p/r);
    float k1=length(p/(r*r));
    return k0*(k0-1.)/k1;
}

void pR(inout vec2 p,float a){
    p=cos(a)*p+sin(a)*vec2(p.y,-p.x);
}

float sdRoundCone(vec3 p,float r1,float r2,float h)
{
    // sampling independent computations (only depend on shape)
    float b=(r1-r2)/h;
    float a=sqrt(1.-b*b);
    
    // sampling dependant computations
    vec2 q=vec2(length(p.xz),p.y);
    float k=dot(q,vec2(-b,a));
    if(k<0.)return length(q)-r1;
    if(k>a*h)return length(q-vec2(0.,h))-r2;
    return dot(q,vec2(a,b))-r1;
}

const int CAT = 0;
const int EYE = 1;

int mat;

float scene(vec3 p)
{
    mat=CAT;
    float sm=sdEllipsoid(p+vec3(0.,.03,0.),vec3(.17,.14,.17));
    sm=smin(sm,sdEllipsoid(p+vec3(-.08,-.13,.1),vec3(.12,.105,.12)),.04);
    vec3 p2=p;
    pR(p2.xy,.55);
    pR(p2.yz,.4);
    sm=smin(sm,sdRoundCone(p2+vec3(-.09,.4,0.),.02,.055,.28),.01);
    p2=p;
    pR(p2.xy,-.55);
    pR(p2.yz,-.4);
    sm=smin(sm,sdRoundCone(p2+vec3(.11,.25,-0),.04,.063,.17),.01);
    p2=p;
    pR(p2.xy,-.28);
    pR(p2.yz,.4);
    sm=smin(sm,sdRoundCone(p2+vec3(.174,.25,-.19),.03,.037,.13),.01);
    p2=p;
    pR(p2.xy,.24);
    pR(p2.yz,.5);
    sm=smin(sm,sdRoundCone(p2+vec3(.09,.3,.08),.04,.048,.2),.01);
    
    p2=p;
    pR(p2.xy,-.24);
    pR(p2.yz,.45);
    sm=smin(sm,sdRoundCone(p2+vec3(.185,.3,-.19),.026,.03,.05),.01);
    p2=p;
    pR(p2.xy,-.07);
    pR(p2.yz,.45);
    sm=smin(sm,sdRoundCone(p2+vec3(.22,.26,-.19),.015,.01,.05),.005);
    p2=p;
    pR(p2.xy,-.29);
    pR(p2.yz,.45);
    sm=smin(sm,sdRoundCone(p2+vec3(.19,.305,-.19),.015,.01,.05),.005);
    
    p2=p;
    pR(p2.xy,-.06);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(.02,.33,.2),.035,.035,.05),.01);
    p2=p;
    pR(p2.xy,.2);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(.052,.31,.2),.015,.01,.05),.005);
    p2=p;
    pR(p2.xy,-.29);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(-.01,.325,.2),.015,.01,.05),.005);
    
    p2=p;
    pR(p2.xy,.8);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(-.005,.43,.1),.03,.03,.06),.01);
    p2=p;
    pR(p2.xy,1.4);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(.197,.38,.1),.012,.02,.05),.005);
    p2=p;
    pR(p2.xy,.2);
    pR(p2.yz,.1);
    sm=smin(sm,sdRoundCone(p2+vec3(-.195,.365,.1),.012,.02,.05),.005);
    
    p2=p;
    pR(p2.xy,.12);
    pR(p2.yz,0.);
    sm=smin(sm,sdRoundCone(p2+vec3(-.022,-.15,.14),.045,.017,.15),.01);
    p2=p;
    pR(p2.xy,-.32);
    pR(p2.yz,0.);
    sm=smin(sm,sdRoundCone(p2+vec3(-.08,-.22,.1),.045,.005,.135),.01);
    
    p2=p;
    pR(p2.xy,.1);
    pR(p2.yz,.5);
    sm=smin(sm,sdRoundCone(p2+vec3(.082,.02,.05),.04,.03,.2),.01);
    p2=p;
    pR(p2.xy,.37);
    pR(p2.yz,.5);
    sm=smin(sm,sdRoundCone(p2+vec3(.032,-.2,.06),.03,.02,.17),.005);
    p2=p;
    pR(p2.xy,.15);
    pR(p2.yz,.5);
    sm=smin(sm,sdRoundCone(p2+vec3(.11,-.37,.055),.018,.01,.1),.005);
    p2=p;
    pR(p2.xy,.5);
    pR(p2.yz,.5);
    sm=smin(sm,sdRoundCone(p2+vec3(-.045,-.48,.065),.01,.005,.05),.005);
    
    float eye = min(sdSphere(p+vec3(-.06,-.13,.3),0.015),sdSphere(p+vec3(-.15,-.14,.27),0.015));
    if (eye < sm)
    {
        mat = EYE;
        return eye;
    }
    return sm;
}

vec3 normal(vec3 p)
{
    float d=scene(p);
    vec2 e=vec2(.001,0.);
    return normalize(vec3(scene(p+e.xyy),scene(p+e.yxy),scene(p+e.yyx))-vec3(scene(p-e.xyy),scene(p-e.yxy),scene(p-e.yyx)));
}

#define FK(k) floatBitsToInt(cos(k))^floatBitsToInt(k)
float hash(vec2 p) {
  int x = FK(p.x); int y = FK(p.y);
  return float((x-y*y)*(x*x+y)-x)/2.14e9;
}

float noise( in vec2 p )
{
    vec2 i = floor( p );
    vec2 f = fract( p );
	
	vec2 u = f*f*(3.0-2.0*f);

    return mix( mix( hash( i + vec2(0.0,0.0) ), 
                     hash( i + vec2(1.0,0.0) ), u.x),
                mix( hash( i + vec2(0.0,1.0) ), 
                     hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

vec3 spheretracing(vec3 ori,vec3 dir){
    float d=0.;
    float k;
    vec3 p;
    for(int i=0;i<MAX_STEPS;i++){
        p=ori+dir*d;
        k=scene(p);
        if(k<EPSILON)
        {
            break;
        }
        d+=(k);
    }
    if(k<EPSILON)
    {
            vec3 n = normal(p);
        //return abs(n);
        if (mat == EYE)
        {
            return vec3(1.,1.4,1.4)*2.;
        }
        float ao=.05;

        p += n*ao;
        return abs(noise((p.xy+p.z)*80.)*0.05)-(max(ao-scene(p),0.0)*2.) + abs(vec3(.08,0.05,0.05)*dot(n,normalize(vec3(0.,-1.,1.))));
    }
    return vec3(-1);
}

void main()
{
    //fragColor = texelFetch(iChannel0,ivec2(gl_FragCoord.xy),0);
    //if (iFrame > 30)
    //    return;
    vec2 uv=(gl_FragCoord.xy/iResolution.xy)*2.-1.;
    uv.y*=iResolution.y/iResolution.x;
    
    if (abs(uv.x) > iResolution.y/iResolution.x)
    {
        fragColor = vec4(0.,0.,0.,1.);
        return;
    }
    
    uv*=0.8;
    
    vec3 cam=vec3(0.,0.,-3.);
    vec3 dir=normalize(vec3(uv,2.5));
    
            vec3 attempt=spheretracing(cam+(vec3(-float(iFrame)*0.0002,float(iFrame)*0.002,0.)),dir);
            if(attempt.x>-1.){
                fragColor+=vec4(attempt,1.);
            }else
            {
                uv += 0.5/iResolution.xy*hash(uv*float(iFrame));
                fragColor += vec4(vec3(noise(uv*80.)*0.02),0.);
    
    if (uv.x-uv.y*40. > 17.)
    {
        fragColor += vec4(0.4,0.2,0.1,1.);
        return;
    }
    if (uv.x-uv.y*40. > 16.)
    {
        fragColor += vec4(0.03,0.04,0.05,1.);
        return;
    }
        if (abs(uv.x+uv.y/80.-0.42) < 0.002)
    {
        fragColor += vec4(0.03,0.04,0.05,1.);
        return;
    }
    fragColor += vec4(0.8,0.81,0.82,1.);
            }
    
    //fragColor=mix(out_color,pow(texture(texCat,(uv+vec2(0.7,0.5))*vec2(0.65,-1)),vec4(0.6)),0.8);
}