section .text
	global _start
	
_start:
; + INIT
org 100h
mov     al, 0x13 ; video mode : 320x200 : DI will move from 0 to 64 000
int     0x10	 ; switch video mode to AL

fninit ; init FPU

push 0xa000		 ; init
pop es

; + MAIN LOOP
main:

	; + DRAW LOOP
	mov cx, 64000 ; 320 x 200 pixels = 64K iterations
	
	frame: 				; will draw the whole screen, pixel per pixel
		cwd

		; get coordinates : X into DX (0 - 320), Y into AX (0 - 200) 
		xor dx, dx
		mov ax, di
		mov bx, 320
		div bx
				
		; get distance from center (from http://www.sizecoding.org/wiki/Floating-point_Opcodes)
		sub ax, 100 
		sub dx, 160
		
		mov [si], ax
		fild 	word [si]		; X
		fmul 	st0				; X²
		mov 	[si],dx			
		fild 	word [si]		
		fmul 	st0				; Y² X²
		fadd 	st0,st1			; Y²+X²
		fsqrt					; R
		fistp 	word [si]		
		mov 	ax,[si]			; nb of pixels from center, 0-160 width / 0-100 height
		
		mov [dist], ax
				
		; if distance (ax) > radius : paint black	
		cmp ax, 96
		mov [pixel], word 0
		jge draw
				
			; rand
			mov ax, [dist]
			sub ax, [time]
			call rand 
			
			; modulo
			xor dx, dx
			mov bx, 16
			div bx
			
			mov [pixel], word 31
			sub [pixel], dx
			
			; if dx (color) is < 8 (= light)
			cmp dx, 8
			jge draw
			
				; sin (time)
				mov ax, [time]
				add ax, [dist]
								
				call sin
				
				mov dx, ax
				mov ax, 56
				sub ax, dx
				
				mov [pixel], al
			
		draw: 
		mov al, [pixel]
		
		stosb ; draw pixel color stored in AL (1 byte) to address pointed by DI, and increment DI
	loop frame ; loop as long as cx > 0
		
	; increment time counter
	add [time], word 1
	
	; + INPUT
	in 	al, 0x60 	; input from port 0x60 to AL : read keyboard
	dec	al			; decrement AL by 1 : is it ESC ?	
	
jnz 	main		; go back to frame drawing if AL is > 0

; + ABORT SEQUENCE
mov al, 0x10 		; back to text mode
int 0x10			; switch video mode
ret					; quit program

rand: ; expect the parameter to be set in ax

	mov		[si],ax
	fild	word [si]
	fsin ; sin(X)
	
	mov ebx, 10
	mov [si], ebx
	fild dword [si] ; sin(X) move to s1			
	fmul st1 ; 10 * sin(X)
	
	fst dword [si]	; convert to qword
	mov ebx,[si] ; store
	
	; get fractional part
	mov [si], ebx
	fild dword [si]
	
	; fild st0              ;duplicate your number => st0=f, st1=f 
	fisttp dword [si]      ;INT(f) - store truncated value somewhere in memory
	fild dword [si]        ;load truncated value
	fsubp st1,st0         ;calculate f-INT(f)
	
	fisttp	dword [si]	; store to integer and pop
	mov		ax,[si]		; store
		
	ret
	
sin: ; expect the parameter to be set in ax
	mov ebx, 16
	mov [si], ebx
	fild dword [si] ; 16

	mov	[si],ax
	fild word [si]
	fdiv st1 ; X / 16
	fsin ; sin(X / 16)
	;fabs ; abs (sin X / 16)
	
	mov ebx, 4 ; was 4
	mov [si], ebx
	fild dword [si] ; 4	
	fmul st1 ; 4 * sin (X / 16)
			
	fistp	dword [si]	; convert to int and pop
	mov		eax,[si]		; store
	
	ret
	
section .data
	time dw 0 
	pixel db 0
	point db 0
	dist db 0