layout (location = 0) in vec2 v_uv;
layout (location = 1) in float v_focus;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    vec4 color;
    float min_alpha;
};

layout (set = 1, binding = 1) uniform sampler2D tex;

void main() {
    float alpha = max(1-v_focus*color.w, min_alpha / 100);
    vec4 texel = texture(tex, v_uv);
    f_color = vec4(color.rgb, texel.r * alpha);
}
