layout (location = 0) in vec2 v_uv;
layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D noise;

layout (set = 1, binding = 0) uniform Uniforms {
    vec3 color;
    vec3 noise_color_1;
    vec3 noise_color_2;
    vec4 noise_param_1;
    vec4 noise_param_2;
    vec4 noise_mix;
    float g_app_time;

};

float no(vec4 param) {
    float t = g_app_time * param.w;
    vec2 uv = v_uv * param.x + vec2(sin(t * param.y), cos(t * param.z));
    return texture(noise, uv).r;
}

float Noise(vec2 co) {
    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
    float noise_1 = no(noise_param_1);
    float noise_2 = no(noise_param_2);
    float noise_bias = (noise_1 + noise_2) * 0.5;
    vec3 noise = mix(noise_color_1, noise_color_2, noise_bias);
    vec3 c = mix(color * 0.03, noise, noise_mix.x * 0.1);
    vec3 dither = vec3(Noise(v_uv + fract(g_app_time)) * 1 / 256);
    f_color = vec4(c + dither, 1);
}
