layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_vertex_camera_pos;
layout (location = 2) out vec3 v_light_camera_pos;
layout (location = 3) out vec3 v_normal;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    vec3 light_position;
    float scale;
};

void main() {
    vec3 pos = a_position * (scale + 1);
    gl_Position = g_projection_from_model * vec4(pos, 1.0);
    v_vertex_camera_pos = (g_camera_from_model * vec4(pos, 1.0)).xyz;
    v_light_camera_pos = (g_camera_from_world * vec4(light_position, 1)).xyz;
    v_normal = mat3(g_camera_from_model) * a_normal;
    v_uv = a_uv;
}