layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in vec3 v_ray_eye;
layout (location = 4) in vec3 v_position;
layout (location = 5) in vec3 v_tangent;
//layout (location = 6) in vec3 v_bitangent;
layout (location = 7) in vec3 v_light_dir;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec4 color;
    vec4 ice_tint;
    vec4 ice_base_color;
    vec4 foo;
    vec4 normal_foo;
    float refact_factor;
    vec2 brightness;
    vec3 light_br;

    vec4 surface_params;
    vec4 deep_params;
};

layout (set = 1, binding = 1) uniform sampler2D tex;
layout (set = 1, binding = 2) uniform sampler2D noise;
layout (set = 1, binding = 3) uniform sampler2D underwater;

vec4 brightness_contrast(vec4 color, float brightness, float contrast) {
    return clamp((color - 0.5) * (contrast * 0.1 + 1) + 0.5 + brightness * 0.1, 0., 1.);
}

vec2 pos_to_uv(vec3 pos) {
    return (pos.xz * foo.y) + vec2(0.5, 0.5);
}

float vpos_tex(vec3 pos) {
    return texture(noise, (pos.xz * foo.z) + vec2(0.5, 0.5)).r;
}

vec4 blend_vec4(vec4 src, vec4 dst) {
    float alpha = src.a + dst.a * (1.0 - src.a);
    return vec4(src.rgb * src.a + dst.rgb * dst.a, alpha);
}

vec3 blend_vec3(vec4 src, vec3 dst) {
    return mix(dst, src.rgb, src.a);
    //    return mix(src.rgb, dst, src.a);
}

void main() {
    vec3 eye = v_ray_eye;
    vec3 world_normal = vec3(0, 1, 0);

    vec3 normal = normalize(v_normal);
    vec3 tangent = normalize(v_tangent);
    vec3 bitangent = cross(normal, tangent);

    vec3 world_tangent = vec3(1, 0, 0);
    vec3 world_bitangent = vec3(0, 0, 1);
    vec4 surface_sample = texture(noise, (v_position.xz * surface_params.x)) - 0.25;

    world_normal += world_tangent * surface_sample.r * surface_params.y;
    world_normal += world_bitangent * surface_sample.g * surface_params.y;
    world_normal = normalize(world_normal);



    vec3 ray = normalize(eye - v_position);
    vec3 ray_inside = refract(ray, world_normal, refact_factor);

    vec3 dpos = world_normal * deep_params.x * 1;
    vec2 duv = dpos.xz;
    vec2 ouv = gl_FragCoord.xy  * deep_params.y / textureSize(underwater, 0) / 4 + deep_params.zw;
    vec2 dduv = clamp(duv + ouv, 0, 1);

    vec4 deep = texture(underwater, dduv);
    vec3 c = clamp(deep.rgb * color.rgb, 0, 1);


    vec4 tint = ice_base_color;

    float loop_count = 100;
    for (float i = loop_count; i >= 0; i-=1) {
        vec3 pos = v_position - i * ray_inside * foo.x * 0.001;
        vec2 uv = pos_to_uv(pos);
        float a = texture(tex, uv).r;
        a = clamp((a - 0.5) * (brightness.y * 0.1 + 1) + 0.5 + brightness.x * 0.1, 0., 1.);
        a *= clamp(1-((1 - 1 / (i + 1)) * ice_tint.a), 0, 1);
        vec3 tint_color = mix(ice_base_color.rgb, ice_tint.rgb, i / loop_count);
        c = blend_vec3(vec4(tint_color, a), c);
    }

    float surface_1 = vpos_tex(v_position);
    float surface_x = vpos_tex(v_position + tangent * foo.w * 0.001);
    float surface_y = vpos_tex(v_position + bitangent * foo.w * 0.001);
    float nx = surface_x - surface_1;
    float ny = surface_y - surface_1;

    float light = clamp(dot(normal, v_light_dir), 0, 1);
    //    color.rgb += clamp((light + light_br.y) * light_br.x, 0, 1);

    f_color = vec4(c.rgb, 1);
}
