layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    float spread;
    float seed;
    vec3 chaos;
    vec3 offset;
};

void main() {
    float id = gl_InstanceIndex + seed;

    float local_rot = chaos.x * (0.1 + noise1d(id*21.1+0.523));
    mat4 local_rotmat = rotate_z(local_rot);

    vec3 pos = a_position + offset;
    pos = mat3(local_rotmat) * pos;

    vec3 move = vec3(noise1d(id*1120+0.2)-0.5, noise1d(sin(id*12.1+0.423))-0.5, 0) * spread;
    pos += move;

    float rot = noise1d(id*121.1+0.423) * 6.28;
    mat4 rotmat = rotate_z(rot);
    gl_Position = g_projection_from_model * rotmat * vec4(pos, 1.0);
}