layout (location = 0) in vec2 v_depth_map_uv;
//layout (location = 1) in vec2 v_wide_uv;
layout (location = 1) in vec3 v_ray_eye;
layout (location = 2) in vec3 v_ray_direction;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_camera;
    mat4 g_camera_from_world;
    vec2 depth_bias;
    float g_field_of_view;
    float g_z_near;
    vec3 sphere_center;
};

layout (set = 1, binding = 1) uniform sampler2D depth_buffer;

vec4 trace_sphere(vec3 eye, vec3 dir) {
    vec3 oc = eye - sphere_center;
    float a = dot(dir, dir);
    float b = 2.0 * dot(oc, dir);
    float c = dot(oc, oc) - 1.0;
    float discriminant = b * b - 4.0 * a * c;
    if (discriminant < 0.0) {
        return vec4(0.0, 0.0, 0.0, -1.0);
    }
    float t = (-b - sqrt(discriminant)) / (2.0 * a);
    vec3 p = eye + t * dir;
    vec3 n = normalize(p - sphere_center);

    vec3 light_dir = normalize(vec3(1.0, 1.0, -1.0));
//    light_dir = mat3(g_camera_from_world) * light_dir;
    float intensity = dot(n, light_dir);
    vec3 color = vec3(intensity, intensity, intensity);

    return vec4(color, t);
//        return vec4((mat3(g_camera_from_world) * n), t);
//    return vec4(n, t);
}


float colorize_depth(float z) {
    return (z + depth_bias.x) * depth_bias.y;
}


void main() {
    float depth_sample = texture(depth_buffer, v_depth_map_uv).r;
    float buffer_z = depth_sample_to_z(g_z_near, depth_sample);
    vec3 flop = vec3(1, 1, 1);
    vec3 eye = v_ray_eye;
    vec3 dir = normalize(v_ray_direction);

    //    eye *= flop;
    //    dir *= flop;

    vec4 color_distance = trace_sphere(eye, dir);

    float hit_z = color_distance.w / length(v_ray_direction);
    if (hit_z < 0.0 || hit_z > buffer_z) {
                discard;
//        f_color = vec4(dir - 0.5, depth_sample < 1.0 ? 0.0 : 1.0);
        f_color = vec4(eye / 10 - 0.5, depth_sample < 1.0 ? 0.0 : 1.0);
        return;
    };
    f_color = vec4(color_distance.rgb, 1);
}
