layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec2 v_uv_min;
layout (location = 2) in vec2 v_uv_max;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D tex;
layout (set = 1, binding = 2) uniform sampler2D dreams_tex;

layout (set = 1, binding = 0) uniform Uniforms {
    float g_app_time;

    float glitch_ratio;
    float glitch_hide;
    vec4 color;
    vec4 glitch_params;
    vec4 glitch_params_2;
    vec4 glitch_params_3;

    vec4 overlay_1_pos;
    vec4 overlay_1_range;
    vec4 overlay_1_color;
    vec4 overlay_1_params;

    vec4 overlay_2_pos;
    vec4 overlay_2_range;
    vec4 overlay_2_color;
    vec4 overlay_2_params;
};

float random2d(vec2 n) {
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

float randomRange(in vec2 seed, in float min, in float max) {
    return min + random2d(seed) * (max - min);
}

float insideRange(float v, float bottom, float top) {
    return step(bottom, v) - step(top, v);
}

float time = g_app_time * glitch_params.y;

vec4 blend(vec4 a, vec4 b) {
    float alpha = a.a + b.a * (1.0 - a.a);
    return vec4(a.rgb * a.a + b.rgb * b.a, alpha);
}

void sample_blend(inout vec4 source_color, vec2 uv, vec3 tint) {
    float s = 0;
    if (!(uv.x < v_uv_min.x || uv.x > v_uv_max.x || uv.y < v_uv_min.y || uv.y > v_uv_max.y)) {
        s = texture(tex, uv).r;
    }
    source_color = blend(source_color, vec4(tint, s));
}

void overlay_blend(inout vec4 source_color, vec2 uv, vec4 tint) {
    float s = texture(dreams_tex, uv).r * tint.a;
    source_color = blend(source_color, vec4(tint.rgb, s));
}

void glitch_channel(inout vec4 c, vec2 uv, vec3 tint, float seed) {
    float t = time + seed;
    t = t - mod(t, glitch_params.w / 10);
    float maxOffset = glitch_params.x * 0.1;

    for (float i = 0.0; i < glitch_params.z; i += 1.0) {
        float sliceY = random2d(vec2(t, 2345.0 + float(i + seed)));
        float sliceH = random2d(vec2(t, 9035.0 + float(i + seed))) * 0.25;
        float hOffset = randomRange(vec2(t, 9625.0 + float(i + seed)), -maxOffset, maxOffset);
        float vOffset = randomRange(vec2(t, 3645.0 + float(i + seed)), -maxOffset, maxOffset);
        vec2 uvOff = uv;
        uvOff.x += hOffset;
        uvOff.y += vOffset;
        if (insideRange(uv.y, sliceY, fract(sliceY + sliceH)) == 1.0) {
            //            outCol.rgb = texture(tex, uvOff).rgb;
            sample_blend(c, uvOff, tint);
            return;
        }
    }
    sample_blend(c, uv, tint);

}

vec2 sin_glitch(float t, float d, float m) {
    return sin(vec2(t * m + d, t * m - d)) * glitch_params_2.x * 0.1;
}

void glitch(inout vec4 c, vec2 uv) {
    float t = time * glitch_params_2.y + (time - mod(time, glitch_params_3.y)) * glitch_params_3.z + uv.y * glitch_params_2.w * 100;
    vec2 rd = sin_glitch(t, 1.434, 0.156) * sin_glitch(t, 1.2548, 0.132) * sin_glitch(t, 1.134, 0.141);
    vec2 gd = sin_glitch(t, 1.544, 0.113) * sin_glitch(t, 1.3452, 0.243) * sin_glitch(t, 1.247, 0.245);
    vec2 bd = sin_glitch(t, 1.123, 0.124) * sin_glitch(t, 1.2354, 0.456) * sin_glitch(t, 1.173, 0.243);
    float yc = sin(t * .1 + uv.y * glitch_params_2.z * 100).x * glitch_params_3.x;
    rd.x *= yc;
    gd.x *= yc;
    bd.x *= yc;

    glitch_channel(c, uv + rd, vec3(color.r, 0, 0), 10.0);
    glitch_channel(c, uv + gd, vec3(0, color.g, 0), 1.3456);
    glitch_channel(c, uv + bd, vec3(0, 0, color.b), 0.457);

    vec4 original = vec4(0);
    sample_blend(original, uv, color.rgb);
    c = mix(original, c, glitch_ratio);
}

void overlay_channel(inout vec4 c, vec2 uv, vec4 tint, float seed) {
    float t = time + seed;
    t = t - mod(t, glitch_params.w / 10);
    float maxOffset = glitch_params.x * 0.1;

    for (float i = 0.0; i < 1; i += 1.0) {
        float sliceY = random2d(vec2(t, 2345.0 + float(i + seed)));
        float sliceH = random2d(vec2(t, 9035.0 + float(i + seed))) * 0.25;
        float hOffset = randomRange(vec2(t, 9625.0 + float(i + seed)), -maxOffset, maxOffset);
        float vOffset = randomRange(vec2(t, 3645.0 + float(i + seed)), -maxOffset, maxOffset);
        vec2 uvOff = uv;
        uvOff.x += hOffset;
        uvOff.y += vOffset;
        if (insideRange(uv.y, sliceY, fract(sliceY + sliceH)) == 1.0) {
            //            outCol.rgb = texture(tex, uvOff).rgb;
            overlay_blend(c, uvOff, tint);
            return;
        }
    }
    overlay_blend(c, uv, tint);
}

void glitch_overlay(inout vec4 c, vec2 uv, vec4 params, vec4 tint) {
    //    vec2 tscale = vec2(1, 0.60) * range.z;

    float t = time + (time - mod(time, params.y)) * 10 + uv.y * params.w * 100;
    vec2 rd = sin_glitch(t, 1.434, 0.156) * sin_glitch(t, 1.2548, 0.132) * sin_glitch(t, 1.434, 0.141);
    vec2 gd = sin_glitch(t, 1.544, 0.113) * sin_glitch(t, 1.2435, 0.243) * sin_glitch(t, 1.247, 0.245);
    vec2 bd = sin_glitch(t, 1.376, 0.124) * sin_glitch(t, 1.2354, 0.456) * sin_glitch(t, 1.173, 0.243);

    //    vec2 o_uv = uv * tscale - range.xy / 5;
    //    float o = texture(dreams_tex, o_uv).r;
    //    vec4 oc = vec4(overlay_color.rgb, o * overlay_color.a);
    //    c = blend(c, oc);

    overlay_channel(c, uv + gd * params.z, vec4(0, tint.g, 0, tint.a), 2.3456);
    overlay_channel(c, uv + bd * params.z, vec4(0, 0, tint.b, tint.a), 4.457);
    overlay_channel(c, uv + rd * params.z, vec4(tint.r, 0, 0, tint.a), 10.123);
}

bool is_in_range(vec2 p, vec2 start, vec2 size) {
    return p.x >= start.x && p.x <= start.x + size.x && p.y >= start.y && p.y <= start.y + size.y;
}

bool draw_overlay(inout vec4 c,
                        vec4 overlay_pos,
                        vec4 overlay_range,
                        vec4 overlay_color,
                        vec4 overlay_params) {
    vec2 uv = v_uv;
    float flip = overlay_params.x * 2 - 1;
    vec2 osize = overlay_pos.zw * 0.1;
    vec2 opos = overlay_pos.xy * 0.1;
    opos.x -= overlay_params.x * osize.x;

    bool debug = !true;

    if (debug) {
        vec2 tscale = vec2(1, 0.60) * overlay_range.z;
        vec2 o_uv = uv * tscale + vec2(flip, -1) * overlay_range.xy / 5;
        o_uv.x += flip * osize.x * 0.5;
        float o = texture(dreams_tex, o_uv).r;
        vec4 oc = vec4(1, 0, 1, o * overlay_color.a * 0.7);
        c = blend(c, oc);
        //            return true;
    }

    vec2 origin_uv = v_uv;
    if (is_in_range(uv, opos, osize)) {
        vec2 tscale = vec2(1, 0.60) * overlay_range.z;
        vec2 o_uv = uv * tscale + vec2(flip, -1) * overlay_range.xy / 5;
        o_uv.x += flip * osize.x * 0.5;
        if (debug) {
            c = blend(c, vec4(1, 0, 1, 0.5));
        }
        glitch_overlay(c, o_uv, overlay_params, overlay_color);
        return true;
    } else if (is_in_range(uv + vec2(osize.x * flip, 0), opos, osize)) {
        glitch(c, uv + vec2(osize.x * flip, 0));
        return true;
    }
    return false;
}

void main() {
    vec4 c = vec4(0);

    //    float flip = overlay_params.x * 2 - 1;
    //    vec2 osize = overlay_pos.zw * 0.1;
    //    vec2 opos = overlay_pos.xy * 0.1;
    //    opos.x -= overlay_params.x * osize.x;
    //    vec2 origin_uv = v_uv;
    //    if (is_in_range(uv, opos, osize)) {
    //        vec2 tscale = vec2(1, 0.60) * overlay_range.z;
    //        vec2 o_uv = uv * tscale + vec2(flip, -1) * overlay_range.xy / 5;
    //        o_uv.x += flip * osize.x * 0.5;
    //        //        float o = texture(dreams_tex, o_uv).r;
    //        //        vec4 oc = vec4(overlay_color.rgb, o * overlay_color.a);
    //        //        c = blend(c, oc);
    //        glitch_overlay(c, o_uv, overlay_params, overlay_color);
    //
    //    } else if (is_in_range(uv + vec2(osize.x * flip, 0), opos, osize)) {
    //        glitch(c, uv + vec2(osize.x * flip, 0));
    //    }
    //    else {
    //        glitch(c, uv);
    //    }

    if (!draw_overlay(c, overlay_1_pos, overlay_1_range, overlay_1_color, overlay_1_params)
    && !draw_overlay(c, overlay_2_pos, overlay_2_range, overlay_2_color, overlay_2_params)) {
        glitch(c, v_uv);
    }

//        c.b = 1;
//        c.a = 0.05 + c.a * 0.95;
    f_color = vec4(c.rgb, c.a *(1-glitch_hide));
}
