layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in float v_time;
layout (location = 3) in vec3 v_vertex_camera_pos;
layout (location = 4) in vec3 v_light_camera_pos;
layout (location = 5) in vec3 v_tangent;

layout (location = 6) in vec3 v_vertex_world_pos;
layout (location = 7) in vec3 v_normal_world;
layout (location = 8) in vec3 v_tangent_world;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_camera_from_world;
    mat4 g_camera_from_model;
    float g_chart_time;
    vec4 color;
    vec4 color2;
    vec4 ambient;
    vec4 params;
    float atten;

    vec4 noise_params;
    vec4 noise_params_2;
    vec3 noise_params_3;
};

layout (set = 1, binding = 1) uniform sampler2D noise_tex;
layout (set = 1, binding = 2) uniform sampler2D env_tex;

float single_sample(vec3 p) {
    float sx = texture(noise_tex, p.yz).r;
    float sy = texture(noise_tex, p.zx).r;
    float sz = texture(noise_tex, p.xy).r;
    return sx + sy + sz;
}

float sample_noise_e(vec3 p, vec4 params, float count) {
    vec3 p2 = p * params.w;
    float s = 0;
    float intensity = 0.3;
    for (float i=0; i<count; i+=1.) {
        p2 *= 2;
        p2 = p2.yzx;
        s += single_sample(p2) * intensity;
        intensity *= params.x;
    }
    s /= count * 3.;
    return s;
}

float sample_noise(vec3 p) {
    return sample_noise_e(p, noise_params, 5);
}

float sample_noise_env(vec3 p) {
    return sample_noise_e(p, noise_params_2, 5);
}

void main() {
    vec3 tangent = v_tangent_world;
    vec3 normal = v_normal_world;
    vec3 binormal = cross(normal, tangent);
    float normal_scale = noise_params.z * 10;
    vec3 p = v_vertex_world_pos;

    // Lighting
    vec3 light_vec = v_vertex_camera_pos - v_light_camera_pos;
    float dist = length(light_vec);
    vec3 light_dir_norm = light_vec / dist;
    vec3 col;

    float spec_comp = color.w;
    vec3 penv = p * noise_params_2.w *0.1;
    float mat_select = sample_noise_env(penv);
    float mx = noise_params_3.x * 0.1;
    if (mat_select > mx) {
        float sampling_diff = noise_params_2.y * 0.01;

        mat_select = min(mat_select, mx);
        float disp_norm = min(sample_noise_env(penv + normal * sampling_diff), mx) - mat_select;
        float disp_binorm = min(sample_noise_env(penv + binormal * sampling_diff), mx) - mat_select;
        normal = normalize(normal + noise_params_2.z * 100*  (normal * disp_norm + binormal * disp_binorm));

        normal = mat3(g_camera_from_model) * normal;
        col = texture(env_tex, penv.xz * params.y + normal.xz * params.z + 0.5).rgb * color.rgb;
        col *= color.rgb;

    } else {
        col = color2.rgb;
        float sampling_diff = noise_params.y * 0.1;

        float disp = sample_noise(p);
        float disp_norm = sample_noise(p + normal * sampling_diff) - disp;
        float disp_binorm = sample_noise(p + binormal * sampling_diff) - disp;
        normal = normalize(normal - normal_scale * (normal * disp_norm + binormal * disp_binorm));
        normal = mat3(g_camera_from_model) * normal;

        spec_comp = 0;
    }
    float intensity = max(dot(normalize(normal), light_dir_norm), 0);
    intensity *= 1 / (1 + dist * atten);


//    vec4 c = color + (color2 - color) * pow(v_time, color2.w);
    float specular = max(pow(dot(normal, light_dir_norm), params.x), 0.0);
    f_color = vec4(ambient.rgb + intensity * col + vec3(1,1,1) * specular * spec_comp, 1);
}
