layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_vertex_camera_pos;
layout (location = 2) in vec3 v_light_camera_pos;
layout (location = 3) in vec3 v_normal;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D noise;

layout (set = 1, binding = 0) uniform Uniforms {
    vec3 ambient;
    vec3 diffuse;
    float g_app_time;
    float atten;
};

float Noise(vec2 co) {
    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

vec3 dither = vec3(Noise(v_uv + fract(g_app_time)) * 1 / 256);

void main() {
    vec3 light_vec = v_vertex_camera_pos - v_light_camera_pos;
    float dist = length(light_vec);
    vec3 light_dir_norm = light_vec / dist;
    float intensity = dot(normalize(v_normal), light_dir_norm);
    intensity *= 1 / (1 + dist * atten);
//    float specular = max(pow(dot(normalize(v_normal), light_dir_norm), params.x), 0.0);
    vec3 dither = vec3(Noise(v_uv + fract(g_app_time)) * 1 / 256);
    vec3 c = ambient * 0.01 + diffuse * intensity + dither;
    f_color = vec4(c, 1);
}
