layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in vec3 v_world_pos;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec4 color;
    vec3 depth_color;
    vec3 depth_bias;
};

layout (set = 1, binding = 1) uniform sampler2D tex;

vec3 fog_of_depth(vec3 color) {
    float m = depth_bias.y * 0.1;
    float z = clamp((gl_FragCoord.z - m) * depth_bias.x * 10 + m, 0, 1);
    return mix(color, depth_color, z);
}

float alpha_of_depth(float alpha) {
    float m = -depth_bias.y * 0.1;
    float z = clamp((v_world_pos.y - m) * depth_bias.x * 10 + m, 0, 1);
    float a = alpha * z;
    a = a*a;
    return a;
}

void main() {
    float s = texture(tex, v_uv).r;
    vec3 c = color.rgb;
    //    f_color = vec4(fog_of_depth(c), s * color.a);
    f_color = vec4(c, alpha_of_depth(s * color.a));
}
