layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in vec3 v_tangent;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec4 color;
    vec3 depth_color;
    vec3 depth_bias;
};

layout (set = 1, binding = 1) uniform sampler2D tex;

vec3 fog_of_depth(vec3 color) {
    float m = depth_bias.y * 0.1;
    float z = clamp((gl_FragCoord.z - m) * depth_bias.x  * 10+ m, 0, 1);
    return mix(color, depth_color, z);
}

void main() {
    vec3 light_dir = normalize(vec3(1.0, 1.0, -1.0));
    float intensity = dot(normalize(v_normal), light_dir);
    float specular = max(pow(dot(normalize(v_normal), light_dir), 5.0), 0.0);
    vec3 c = depth_color + max(texture(tex, v_uv).rgb * intensity + specular * 0.3, 0);
    f_color = vec4(fog_of_depth(c), 1);
}
