layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec3 color1;
    vec3 color2;
    float intensity;
    vec3 balance;
};

void main() {
    float f = pow(gl_FragCoord.w * balance.z + balance.y,balance.x) * intensity;
    vec3 c = mix(color1, color2, clamp(f, 0, 1));
    f_color = vec4(c, 1);
}
