layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in float v_time;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    float g_chart_time;
    vec4 color;
    vec4 color2;
    vec4 ambient;
    vec4 params;
    vec3 light_dir;
};

void main() {
    vec4 c = color + (color2 - color) * pow(v_time, color2.w);
    vec3 light_dir_norm = normalize(light_dir);
    float intensity = max(dot(normalize(v_normal), light_dir_norm), 0);
    float specular = max(pow(dot(normalize(v_normal), light_dir_norm), params.x), 0.0);
    f_color = ambient + intensity * c + specular * color.w;
}
