"use strict";

class PersistentScene extends BaseScene {
    load(loadingContext) {
        const ctx = loadingContext;
        ctx.loadSprite("marker", "tinySkull.png");
    }

    initialize() {   
    }

    update(renderContext, _localTime, globalTime) {
        const ctx = renderContext;



        // Karaoke (code needs to move to a more generic over-the-scenes-place)
        const karaokeManager = ctx.karaokeManager;
        const karaokeLine = karaokeManager.getLine(globalTime);

        if (!karaokeLine) {
            ctx.text = "";
            return;
        }

        if (globalTime > 179) {
            ctx.text = " ";
            return;
        }
        
        ctx.text = karaokeLine.text;
        const textRect = renderContext.getTextRect();
        const position = karaokeLine.getMarkerPosition(globalTime, textRect)
        if (position) {
            ctx.sprite("marker", position.x, position.y, 6.5);
        }

    }
}