"use strict";

class MusicManager {
    _camera;
    _music;

    constructor(camera) {
        this._camera = camera; 
    }

    get currentTime() {
        return this._music ? this._music.currentTime : 0;
    }

    load(path) {
        var music = new Audio(path);
        // music.volume = 0.1; // Turn down the volumne if you get sick of the tune during development
        this._music = music;

        return new Promise((resolve) => {
            music.addEventListener("canplaythrough", function() {
                resolve();
            })
        });
    }

    play(offsetMS) {
        if (offsetMS)
            this._music.currentTime = offsetMS / 1000;
        this._music.play();
    }

    pause() {
        this._music.pause();
    }

}