;                                     _____
;                                    / ___ \
; nikhotmsk_u2023s v0.2 by nikhotmsk  /_o_\
;
; use this command to compile this thing:
; wine ../../sjasmplus-1.18.3.win/sjasmplus.exe nikhotmsk_u2023s.asm --lst=nikhotmsk_u2023s.lst --sym=nikhotmsk_u2023s.sym && ../bas2tap/bas2tap -a10 loader.bas && cat loader.tap nikhotmsk_u2023s_code.tap > nikhotmsk_u2023s.tap
;
; run in emulator:
; wine ../../../unreal_speccy/us0.38.1/unreal.exe nikhotmsk_u2023s.tap
;

;
; message for humans. If you want to learn Z80 assembly language, try
; this tutorial: https://www.chibiakumas.com/z80
;

	DEVICE ZXSPECTRUM128
	org $a000
	;
	; This is a fischinger engine, it is used to draw multiple objects
	; at many places using precompiled drawing code. Ask nikhotmsk if you
	; want to understand how it works.
	;
code_start:
	di
	ld (saved_iy), iy ; save IY register, because it is needed for rst #10
	
	; find the page that was active at boot and place it to player_page
	ld a, (stored_paging_byte_address) ; which is $5b5c (23388)
	and 0b00000111
	ld (player_page), a
	
code_again:
	di
	ld hl, machine_stack_end
	ld sp, hl
	
	; TODO make sure keyboard keys are released
	
	
	ld hl, 0
	ld (frame_counter), hl
	ld hl, draw_text_empty_byte
	ld (draw_text_pointer), hl
	ld hl, $4000
	ld (draw_text_screen_address), hl
	; turbo sound setting should survive
	; TODO cancel pause
	
	ld a, 0
	out (#FE),A      ; border black
	ld HL, #5800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
	ld hl, vars
	ld bc, erase_queue_end - vars
	ld d, 0
	call fill_mem ; clear variables and shedule
	
	;ld ix, vars     ; put four dots
	;ld de, 0x0202	;
	;ld (ix+0), de	;    A-------B
	;ld de, 0x0214	;    |       |
	;ld (ix+2), de	;    |       |
	;ld de, 0x1414	;    |       |
	;ld (ix+4), de	;    D-------C
	;ld de, 0x1402	;
	;ld (ix+6), de
	
	ld a,2
	call $1601 ; select S channel for text
	
	di
	ld hl, im2_interrupt_block ; prepare interrupt mode 2
	ld a, h
	ld i, a
	;ld bc, 257 ; size of interrupt block
interrupt_setup_loop:
	;ld (hl), $80
	;inc hl
	;dec bc
	;ld a, b
	;or c
	;jr nz, interrupt_setup_loop
	im 2
	
stored_paging_byte_address: EQU $5b5c
	
	; initSong
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	or l
	or 16 ; always select basic48 ROM
	ld bc, #7ffd
	ld (stored_paging_byte_address), a
	; always store this byte, so interrupt can restore it back
	out (c),a
	
	ld a, (no_music)
	or a
	call z, initSong
	
	
	jp code_main
saved_iy:	WORD 0
	
	; ORG ahead, do not put extra code here, because not much space

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	org #a0a0 ; interrupt routine here
	push af
	;ld a, 0b00000111 ; debug border white
	;out (#fe), a
	push bc
	push de
	push hl
	push ix
	push iy
	
	; frame counter here
	ld hl, (frame_counter)
	inc hl ; normal flow
	ld (frame_counter), hl ; TODO pause
	
	jp interrupt_routine_continue

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ALIGN 2 ; hardcoded interrupt table here
im2_interrupt_block:
	.257 BYTE #a0 ; this is an interrupt table (size 257 bytes)
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_routine_continue
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_music: BYTE 0
flip_mask: BYTE 0
flip_override: BYTE 0
flip_override_storage: BYTE 0
paging_available: BYTE 0
player_page: BYTE 0
interrupt_choosen_file: WORD 0
interrupt_chosen_erase_queue: WORD 0
interrupt_chosen_queue: WORD 0
interrupt_routine_continue:
	; do flip
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override
	ld a, (flip_mask)
	ld (flip_override_storage), a ; save flip_mask for later recovery
interrupt_no_override:
	
	ld hl, (frame_counter)
	ld a, l
	and 0b00000010
	jr z, interrupt_frame_is_0
	; set active file to IY
	ld iy, asm_file_for_screen_1
	ld a, 0
	ld (flip_mask), a ; and show screen 0
	jr interrupt_frame_is_not_0_skip
interrupt_frame_is_0:
	; set active file IY
	ld iy, asm_file_for_screen_0 ; writing to screen 0, displayng 1
	ld a, 8
	ld (flip_mask), a ; frame 1 is displayed
interrupt_frame_is_not_0_skip:
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override_2
	ld a, (flip_override_storage) ; recover
	ld (flip_mask), a
interrupt_no_override_2:
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; do not save a byte, because it is for interrupt only
	out  (c),a	; flip shadow screen
	ld (interrupt_choosen_file), iy

	ld a, (no_music)
	or a
	jr nz, interrupt_routine_no_music
	; page in a player
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	call player+5 ; run music ; TODO implement pause
	
interrupt_routine_no_music:
	
	; read keyboard
	ld bc, #7ffe ; keys b,n,m,sym,space
	in a, (c)
	and 0b00000001
	jr nz, interrupt_routine_no_break_key
interrupt_routine_goto_code_again:
	; reset program back to the beginning
	ld de, code_again
	push de
	; ei
	reti ; start the program from the beginning
interrupt_routine_no_break_key:
	ld bc, #fdfe ; keys g,f,d,s,a
	in a, (c)
	ld b, a
	and 0b00000010 ; the 's' key
	jr nz, interrupt_routine_no_s_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 0
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_s_key:
	ld a, b
	and 0b00000001 ; the 'a' key
	jr nz, interrupt_routine_no_a_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 1
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_a_key:

	; draw text here
	ld a, (flip_mask)
	or 7  ; select page 7 for text drawing
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a
	
	ld hl, (draw_text_pointer)
	ld a, (hl)
	cp '$'
	jr z, interrupt_no_draw_text
	ld b, 15 ; speed of text drawing here
interrupt_draw_text_cycle:
	ld a, (hl)
	cp '$'
	jr z, interrupt_draw_text_end
	; catch a ctl_at byte here
	cp ctl_at
	jr nz, interrupt_draw_text_to_ctl_at
	inc hl
	ld c, (hl)
	inc hl
	ld b, (hl)
	inc hl
	or a ; drop carry
	rl c
	rl c
	rl c
	call get_video_pos ; returns de
	ld (draw_text_screen_address), de
	jr interrupt_draw_text_cycle
	
interrupt_draw_text_to_ctl_at:
	
	push bc
	push hl
	
	ld hl, 0
	sub 32 ; substract non-printable chars
	ld l, a
	or a ; drop carry bit
	rl l
	rl h
	rl l
	rl h
	rl l
	rl h ; multiply by eight
	ld de, $3d00 ; Character set
	add hl, de
	ld b, 8
	ld de, (draw_text_screen_address)
	push de
interrupt_draw_text_cycle_cycle:
	ld a, (hl)
	ld (de), a ; write to screen
	ld ixl, a
	ld a, (paging_available)
	or a
	jr z, interrupt_draw_text_no_shadow_screen
	push de
	set 7, d ; extended instruction, set bit 7 in register d
	ld a, ixl
	ld (de), a ; write the same thing to shadow screen
	pop de
	
interrupt_draw_text_no_shadow_screen:
	inc d      ; step down
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle_cycle
	pop de
	inc e ; step right
	ld (draw_text_screen_address), de
	
	pop hl
	pop bc
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle
interrupt_draw_text_end:
	ld (draw_text_pointer), hl
interrupt_no_draw_text:


	; page in a screen file & shedule & erase shedule
	ld iy, (interrupt_choosen_file)
	ld hl, (iy+12) ; [erase_queue]
	ld (interrupt_chosen_erase_queue), hl
	ld hl, (iy+10)
	ld (interrupt_chosen_queue), hl
	
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	
	
	; the engine makes flip and then erases shapes, on next frame it draws shapes
	ld hl, (frame_counter)
	ld a, l
	and 1
	jp nz, interrupt_routine_no_erase_this_time
	
	
	; erase thing on even frames
	ld b, erase_queue_size
	ld ix, (interrupt_chosen_erase_queue)
	ld a, (iy+6) ; [asm enable]
	or a
	jr z, interrupt_routine_no_erase_this_time
	
interrupt_c0:
	ld hl, (ix+0) ; [hl register] [drawing code] [ret patch]
	ld a, h
	or l
	jr z, interrupt_skip0
	ld de, (ix+2) ; drawing code pointer
	push bc
	ld b, 0 ; draw black
	call call_de
	pop bc
	ld hl, 0
	ld (ix+0), hl ; mark this entry as empty
	
interrupt_skip0:
	ld de, 6 ; [hl register] [drawing code] [ret patch]
	add ix, de
	dec b
	jr nz, interrupt_c0
	jp do_not_draw_this_time_wait_for_next_interrupt

interrupt_routine_no_erase_this_time:

	; draw some figurines
	ld b, shedule_size
	ld hl, (interrupt_chosen_queue) ; [shedule]
	ld ix, hl
interrupt_c1:
	ld hl, (ix+0) ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	ld a, h
	or l
	jp z, interrupt_skip1 ; FIXME enable byte
	ld de, (ix+7) ; target frame number
	ld hl, (frame_counter) ; i will restore hl back
	or a ; clear carry flag
	sbc hl, de
	add hl, de ; compare two numbers
	jp c, interrupt_skip1
	ld hl, (ix+0) ; restore hl back
	ld de, (ix+2) ; load drawing code
	push bc
	ld b, #ff
	call call_de ; run drawing code

	pop bc
	
	push bc
	ld b, erase_queue_size ; move iy to empty entry in erase_queue
	ld iy, (interrupt_chosen_erase_queue)
interrupt_find_empty_c1:
	ld de, (iy+0)
	ld a, d
	or e
	jr z, interrupt_find_empty_skip1 ; found empty slot
	ld de, 6
	add iy, de ; move to next entry
	dec b
	jr nz, interrupt_find_empty_c1
	ld iy, (interrupt_chosen_erase_queue) ; no space left, use first entry
interrupt_find_empty_skip1:
	pop bc
	
	ld de, (ix+0) ; [hl register] [drawing code] [ret patch]
	ld (iy+0), de
	ld de, (ix+2)
	ld (iy+2), de
	ld de, (ix+4)
	ld (iy+4), de ; put entry into erase_queue to be erased on next frame
	
	ld a, 0
	ld (ix+6), a ; drop enable byte
	ld (ix+0), a
	ld (ix+1), a ; mark this entry empty
	
interrupt_skip1:
	; TODO check frame number
	ld de, shedule_entry_size
	add ix, de
	dec b
	jp nz, interrupt_c1
	
do_not_draw_this_time_wait_for_next_interrupt:
	
	ld a, (flip_mask)
	ld l, a
	ld a, (stored_paging_byte_address)
	and 0b11110111
	or l
	or 16 ; basic48
	ld bc, #7ffd
	out (c),a ; restore page as it was before interrupt
	
	;ld a, 0b00000000 ; border black again
	;out (#fe), a
	; .6 call busy_wait
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti

;;;;;;;;;;;;;;;;;
; rewind_music
;;;;;;;;;;;;;;;;;
rewind_frame: EQU 950
rewind_music:
	ld a, (no_music)
	or a
	ret nz
	ld bc, rewind_frame
	ld hl, (frame_counter)
	ld de, rewind_frame
	add hl, de
	ld (frame_counter), hl
rewind_music_loop:
	push bc
	call player+5
	pop bc
	dec bc
	ld a, b
	or c
	jr nz, rewind_music_loop
	ret
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;test_figurine_asm:	WORD 0
code_main:
	
	; WANTFIX the loader of music is probably to be located here, make user
	; able to cancel music loading on device that does not
	; support AY sound, by pressing a key
	
	; check if paging available
	ld a, 1
	ld (paging_available), a
	
	ld a, (flip_mask)
	ld h, a
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, 16
	ld ($ffff), a
	
	ld a, 7
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld a, 17
	ld ($ffff), a
	
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, ($ffff)
	cp 17
	jr nz, code_main_paging_ok
	ld a, 0
	ld (paging_available), a
	
	ld a, 2
	out (#FE),A ; border red means that paging is failed (48k compatibility mode)
	
	; change asm_file so it assembles into $6000 and drop even frames
	ld ix, asm_file_for_screen_0
	ld (ix+6), 0 ; [enable asm] screen 0 does not compile
	ld hl, shedule_6000
	ld (ix+10), hl
	ld hl, erase_queue_6000
	ld (ix+12), hl
	
	ld ix, asm_file_for_screen_1
	ld hl, 0
	ld (ix+8), hl ; [screen file offset]
	
	
	jr code_main_paging_not_available_skip_music_check
code_main_paging_ok:
	; player page should not be 4 or 7, if so, disable music
	; it would probably always be 0 at load, but I put a check to be sure
	ld a, (player_page)
	and 0b00000111
	cp 7
	jr z, code_main_disable_music
	cp 4
	jr z, code_main_disable_music
	jr code_main_music_ok
code_main_disable_music:
	ld a, 1
	ld (no_music), a
	
code_main_music_ok:
	
	ld hl, vault_c000
	ld bc, erase_queue_c000_end - vault_c000 ; page 4
	ld d, 0
	call fill_mem ; clear shedule at c000
	
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld HL, #d800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
code_main_paging_not_available_skip_music_check:
	
	ei
	call clear_slow
	
	; set player page, so the code has access to shapes
	ld a, (player_page)
	ld l, a
	di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page (where shapes are stored)
	ei
	
	jp frame_0_program_start ; program moved to $c000 at page 0




;;;;;;;;;;;;;;;;;;;;;;;;;;;
; on screen display text
;;;;;;;;;;;;;;;;;;;;;;;;;;;
ctl_paper:	EQU $11
ctl_ink:	EQU $10
ctl_at:		EQU $16
ctl_bright:	EQU $13
text_nikhotmsk_presents: ; BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
	BYTE ctl_at,8, 6,'       _____'
	BYTE ctl_at,9, 6,'      / ___ \'
	BYTE ctl_at,10,6,'       /   \'
	BYTE ctl_at,11,6,'      /__O__\'
	BYTE ctl_at,13,6,'     nikhotmsk', '$'
text_chan1:	BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
			BYTE ctl_at,4,12,'AY chan 1', '$'
text_chan2: BYTE ctl_at,5,12,'AY chan 2', '$'
text_chan3: BYTE ctl_at,6,12,'AY chan 3', '$'
text_chan4: BYTE ctl_at,7,12,'AY chan 4', '$'
text_chan5: BYTE ctl_at,8,12,'AY chan 5', '$'
text_chan6: BYTE ctl_at,9,12,'AY chan 6', '$'
text_chan1b: BYTE ctl_at,4,12,'         ', '$'
text_chan2b: BYTE ctl_at,5,12,'         ', '$'
text_chan3b: BYTE ctl_at,6,12,'         ', '$'
text_chan4b: BYTE ctl_at,7,12,'         ', '$'
text_chan5b: BYTE ctl_at,8,12,'         ', '$'
text_chan6b: BYTE ctl_at,9,12,'         ', '$'
text_channel_fix: BYTE ctl_at,14,3,'Press [a] or [s] to escape'
				BYTE ctl_at,16,7,'NedoPC TurboSound', '$'
text_title1: BYTE ctl_at,8,0, '## # ## ## # # # ##  #### ## ###'
			 BYTE             '#    #  #  # #   # # #  # #  # #'
			 BYTE             '#  # #  #  # # # # # #    #  # #'
			 BYTE             '## # ## #  ### # # # #    ## ## '
			 BYTE             '#  #  # #  # # # # # # ## #  # #'
			 BYTE             '#  #  # #  # # # # # #  # #  # #'
			 BYTE             '#  #  # #  # # # # # #  # #  # #'
			 BYTE             '#  # ## ## # # # # # #### ## # #'
			 BYTE             '$'

text_title2: BYTE ctl_at,20,14,'v. 2', '$'
text_story1: BYTE ctl_at,0,11,'STORY 1/2:'
	BYTE ctl_at,2,0
	BYTE 'This demo is inspired  by  early'
	BYTE 'experimental abstract  animation'
	BYTE 'movies from the year 1920 or so.'
	BYTE 'It was the time when people used'
	BYTE 'their  mechanical   and  optical'
	BYTE 'skills to create unusual  visual',ctl_at,8,0
	BYTE 'effects way before computer ani-'
	BYTE 'mation was  invented.  Also they'
	BYTE 'compete with each  other.  IMHO,'
	BYTE 'it was the DEMOSCENE back then. '
	BYTE '                                '
	       
	BYTE 'Oskar  Fischinger  was  a famous'
	BYTE 'animator who  worked on the idea'
	BYTE 'of visual music.  This demo is a',ctl_at,16,0
	BYTE 'tribute  to him  (thus  the name'
	BYTE '"Fischinger") and it is made  in'
	BYTE 'his style.  Idea of VISUAL MUSIC'
	BYTE 'is simple.  First, you  have  to'
	BYTE 'pick a melody, then draw visuals' ; 19 lines
	BYTE '$'
	
text_story2: BYTE ctl_at,0,11,'STORY 2/2:'
	BYTE ctl_at,2,0
	BYTE 'that correspond to musical phra-'
	BYTE 'ses or so,  I duno, and then  it'
	BYTE 'all plays together. Easy, right?'
	BYTE '                                '
	BYTE 'This demo uses Rachmaninoff mus-'
	BYTE 'ic because there will be Rachma-',ctl_at,8,0
	BYTE 'ninoffs anniversary soon,  also,'
	BYTE 'it is a cool thing to try.      '		    
	BYTE '                                '
	BYTE 'Scriabins Prometheus color music'
	BYTE 'experiment is  also a thing,  it'
	BYTE 'maps musical chords  to the col-'
	BYTE 'ors, and it should be here. (but'
	BYTE 'not today, because  color  logic',ctl_at,16,0
	BYTE 'is not ready).  This demo is un-'
	BYTE 'der construction, it ends on the'
	BYTE 'frame 3895    (1 min 30 sec).  I'
	BYTE 'will  fix  all  this  in release'
	BYTE 'version.'
	BYTE '$' ; end of text
text_controls: BYTE ctl_at,4,11,'Controls:'
	BYTE ctl_at,7,0
	BYTE '[break] - play from beginning   '
	BYTE '                                ',ctl_at,8,0
	BYTE '[a] [s] - disable TurboSound    '
	BYTE '$'
text_music_by: BYTE ctl_at,7,13,'Music:'
	BYTE ctl_at,11,2
	BYTE '       Rachmaninoff',39,'s           ' ;
	BYTE '                                ' ;
	BYTE '       Concerto  No.1'
	BYTE '$'
	
place_single:
	BYTE 1, 0, 0, 0, 0 ; [enable] [dY dX] [dFrame]
	BYTE 0 ; terminator
place_loop_22_4:
	BYTE 1, 0, 0,  0, 0
	BYTE 1, 0, 0, 22, 0
	BYTE 1, 0, 0, 44, 0
	BYTE 1, 0, 0, 66, 0
	BYTE 0
place_leftright_twice:
	BYTE 1, -5, 0, 12, 0
	BYTE 1, +5, 0, 12, 0
	; fallthrough
place_leftright:
	BYTE 1, -5, 0, 0, 0
	BYTE 1, +5, 0, 0, 0
	BYTE 0
place_one_by_one:
	BYTE 1, -7, 0, 0, 0
	BYTE 1, -4, 0, 8, 0
	BYTE 1,  0, 0, 16, 0
	BYTE 1,  4, 0, 24, 0
	BYTE 0
place_parapam:
	BYTE 1,  0, 0, 0, 0
	BYTE 1,  0, 0, 8, 0
	BYTE 1,  0, 0, #1c, 0
	BYTE 1,  0, 0, #22, 0
	BYTE 1,  0, 0, #2a, 0
	BYTE 1,  0, 0, #30, 0
	BYTE 0
place_sparkle_small_7:
	BYTE 1,  0, 0, 0, 0
	BYTE 1,  1,-6, 6, 0
	BYTE 1,  0,-2, 12, 0
	BYTE 1, -2, 0, 18, 0
	BYTE 1,  1, 0, 24, 0
	BYTE 1,  0,-3, 30, 0
	BYTE 1,  1,-2, 36, 0
	BYTE 0
place_four_times:
	BYTE 1,  1,-2, 0, 0
	BYTE 1, -2, 0, 8, 0
	BYTE 1,  0, 2, 16, 0
	BYTE 1,  2, 0, 24, 0
	BYTE 0

place_afraid_forward:
	BYTE 1, 0, 8, 0, 0
	BYTE 1, 0, 6, 30, 0
	BYTE 1, 0, 4, 60, 0
	BYTE 1, 0, 2, 100, 0
	BYTE 1, 0, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1, 0, 6, 165, 0
	BYTE 1, 0, 4, 180, 0
	BYTE 1, 0, 2, 195, 0
	BYTE 1, 0, 0, 210, 0
	BYTE 0

place_afraid_right:
	BYTE 1, 0, 8, 0, 0
	BYTE 1, 2, 6, 30, 0
	BYTE 1, 4, 4, 60, 0
	BYTE 1, 6, 2, 100, 0
	BYTE 1, 8, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1, 2, 6, 165, 0
	BYTE 1, 4, 4, 180, 0
	BYTE 1, 6, 2, 195, 0
	BYTE 1, 8, 0, 210, 0
	BYTE 0
place_afraid_left:
	BYTE 1, 0, 8, 0, 0
	BYTE 1,-2, 6, 30, 0
	BYTE 1,-4, 4, 60, 0
	BYTE 1,-6, 2, 100, 0
	BYTE 1,-8, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1,-2, 6, 165, 0
	BYTE 1,-4, 4, 180, 0
	BYTE 1,-6, 2, 195, 0
	BYTE 1,-8, 0, 210, 0
	BYTE 0

place_go_go_go:
	BYTE 1, 0, 0, 0, 0
	BYTE 1, 4, 3, 4, 0
	BYTE 1, 6, 2, 8, 0
	BYTE 1,-2,-2, 12, 0
	BYTE 1, 4,-3, 16, 0
	BYTE 1,-5, 0, 20, 0
	BYTE 1, 2,-3, 24, 0
	BYTE 1,-4, 2, 28, 0
	BYTE 1, 0,-2, 32, 0
	BYTE 1, 0, 5, 36, 0
	BYTE 1,-1,-4, 40, 0
	BYTE 1, 3, 0, 44, 0
	BYTE 1, 0,-4, 48, 0
	BYTE 1, 4,-6, 52, 0
	BYTE 1,-2, 2, 56, 0
	BYTE 1, 0, 0, 60, 0
	BYTE 1, 0,-4, 64, 0
	BYTE 1,-2, 4, 68, 0
	BYTE 1, 0, 2, 72, 0
	BYTE 1, 3, 0, 76, 0
	BYTE 0
place_go_go_go_wide:
	BYTE 1, 0, 0, 0, 0
	BYTE 1, 10, -1, 4, 0
	BYTE 1, 6, 4, 8, 0
	BYTE 1,-2,-7, 12, 0
	BYTE 1, 4,5, 16, 0
	BYTE 1,-5, 0, 20, 0
	BYTE 1, 2,6, 24, 0
	BYTE 1,11, 4, 28, 0
	BYTE 1, 6,-2, 32, 0
	BYTE 1,-4, 5, 36, 0
	BYTE 1,-6,-4, 40, 0
	BYTE 1,-2, 0, 44, 0
	BYTE 1, -5,-4, 48, 0
	BYTE 1,-4,-6, 52, 0
	BYTE 1,3, 2, 56, 0
	BYTE 1, -10, 0, 60, 0
	BYTE 1, 3,-4, 64, 0
	BYTE 1,-2, 4, 68, 0
	BYTE 1, 0, -7, 72, 0
	BYTE 1, 3, 0, 76, 0
	BYTE 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FRAME 0 PROGRAM START CHANNEL CHECKER
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
frame_0_program_start:
	
	ld de, 30
	call wait_for_frame
	ld a, 0
	out (#FE),A ; border black (chancel red border on boot)
	call clear_slow
	
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 410 TITLE
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 410
	call wait_for_frame
	ld a, 1
	ld (flip_override), a ; prevent screen flip
	
	ld a, (player_page)
	and 0b11110111 ; select screen 0
	or 16 ; select 48k basic
	di
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; page
	ei
	
	ld hl, the_logo_svg
	ld (polyline_pointer), hl
	call fischinger_draw_polyline
	
	ld de, (10 * 256) + 57
	call fill
	ld de, (37 * 256) + 57
	call fill
	ld de, (37 * 256) + 70
	call fill
	ld de, (49 * 256) + 70
	call fill
	ld de, (74 * 256) + 70
	call fill
	ld de, (101 * 256) + 70
	call fill
	ld de, (131 * 256) + 70
	call fill
	ld de, (131 * 256) + 57
	call fill
	ld de, (143 * 256) + 70
	call fill
	ld de, (194 * 256) + 70
	call fill
	ld de, (205 * 256) + 70
	call fill
	ld de, (237 * 256) + 70
	call fill

	ld de, 450
	call wait_for_frame
	ld hl, text_title2 ; v. 2
	ld (draw_text_pointer), hl
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 610 MUSIC START
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 550
	call wait_for_frame
	call clear_slow
	
	; enable flip
	ld a, 0
	ld (flip_override), a
	
	ld hl, place_leftright_twice
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1
	ld de, 610
	call shedule_add_shape ; assemble thing before clear and shedule it after clear
	ld hl, shape_quicker_up_1
	ld de, 610
	call shedule_add_shape
	
	
	ld hl, place_one_by_one
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1_small
	ld de, 639
	call shedule_add_shape
	
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld hl, shape_flyby_1
	ld de, 666
	call shedule_add_shape
	
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 715 ; it was 1115 before big move (delta -400)
	call place_total_wipe
	
	
	ld hl, place_parapam
	ld (add_shape_places_table), hl
	ld de, 735
	ld hl, shape_quicker_1
	call shedule_add_shape
	
	ld hl, place_sparkle_small_7
	ld (add_shape_places_table), hl
	ld de, 792
	;ld hl, shape_needle1
	;call shedule_add_shape
	call place_needle
	ld de, 792
	call wait_for_frame
	
	ld hl, place_four_times
	ld (add_shape_places_table), hl
	ld de, 841
	push de
	ld hl, shape_salute_small_left
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_right
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_up
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_down
	call shedule_add_shape
	pop de
	ld de, 841
	call wait_for_frame
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 862
	ld hl, shape_flyer_84_part_1
	call shedule_add_shape ; long thing, 168 frames
	
	ld de, 910
	call wait_for_frame
	ld de, 926
	ld hl, shape_flyer_84_part_2
	call shedule_add_shape
	
	; add duet here
	ld de, 926
	ld hl, shape_flyby_1
	call shedule_add_shape
	
	ld de, 910
	call wait_for_frame
	ld de, 954
	ld hl, shape_flyer_84_part_3
	call shedule_add_shape
	
	ld de, 1020
	call wait_for_frame
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 1030
	ld hl, shape_stairs_21
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 1072 PATTERN 3
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 1032
	call wait_for_frame
	ld hl, place_loop_22_4
	ld (add_shape_places_table), hl
	ld de, 1072
	ld hl, shape_circle
	call shedule_add_shape
	ld de, 1086
	push de
	ld hl, shape_salute_small_left
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_right
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_up
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_down
	call shedule_add_shape
	pop de
	
	ld hl, place_leftright_twice
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1
	ld de, 1156
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 3495 END OF MUSIC
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	ld bc, 2000 ; 40 sec
code_loop:
	halt ; program autorestart
	;dec bc
	ld a, b
	or c
	jr nz, code_loop
	jp interrupt_routine_goto_code_again
	
	
spectrum_screensaver:
	ld hl, $5800
	ld de, 0
	ld a, (de)
	ld (hl), a
	inc de
	inc hl
	jr spectrum_screensaver
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;;
; filler
;;;;;;;;;;;;;;;;;;;;;;;;;
filler_figurine: WORD shape_froggy_center
filler_frame_number: WORD 4000
filler_scary_table: WORD place_afraid_forward
filler:
	; this demo takes too long, and deadline is so near, I have to use filler
	
	ld hl, (filler_frame_number)
	ld de, -20
	add hl, de
	ex de, hl
	call wait_for_frame
	
	ld hl, (filler_scary_table)
	ld (add_shape_places_table), hl
	
	ld hl, (filler_frame_number)
	ld de, 0 ; offset 0
	add hl, de
	ex hl, de
	;ld de, 1619
	ld hl, (filler_figurine)
	call shedule_add_shape

	ld hl, (filler_frame_number)
	ld de, 221
	add hl, de
	ex de, hl
	call wait_for_frame

	ld hl, place_go_go_go
	ld (add_shape_places_table), hl
	
	ld hl, (filler_frame_number)
	ld de, 241
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	ld hl, (filler_frame_number)
	ld de, 321
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 336
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	; one more time
	ld hl, (filler_frame_number)
	ld de, 401
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 416
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	; and once more
	ld hl, (filler_frame_number)
	ld de, 481
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 496
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	ld hl, (filler_frame_number) ; keep time just to make sure
	ld de, 576
	add hl, de ; this is total length of this filler - 576 frames (11 sec)
	ex de, hl
	call wait_for_frame
	ret

;;;;;;;;;;;;;;;;;;;;;
; place_needle
;;;;;;;;;;;;;;;;;;;;;
place_needle:
	ld hl, shape_needle_1_phase_1
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_needle_1_phase_2
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_needle_1_phase_3
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ret



;;;;;;;;;;;;;;;;;;;
; place_total_wipe
;;;;;;;;;;;;;;;;;;;
place_total_wipe:
	ld hl, shape_wipe_phase1
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase2
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase3
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase4
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase5
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase6
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase7
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	
	ret
	
shape_wipe_phase1:
	BYTE 3,13,48,5
	BYTE 2,21,77,8
	BYTE 0,0,0,0
shape_wipe_phase2:
	BYTE 3,32,119,5
	BYTE 160,8,5,41
	BYTE 0,0,0,0
shape_wipe_phase3:
	BYTE 7,65,170,24
	BYTE 174,29,22,68
	BYTE 0,0,0,0
shape_wipe_phase4:
	BYTE 61,105,208,53
	BYTE 210,59,66,108
	BYTE 0,0,0,0
shape_wipe_phase5:
	BYTE 116,119,225,114
	BYTE 121,127,224,123
	BYTE 0,0,0,0
shape_wipe_phase6:
	BYTE 148,160,215,154
	BYTE 216,160,155,164
	BYTE 0,0,0,0
shape_wipe_phase7:
	BYTE 160,178,221,172
	BYTE 222,178,161,183
	BYTE 0,0,0,0



;;;;;;;;;;;;;;;
; call_de
;;;;;;;;;;;;;;;
call_de:
	push de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a structure for shadow screen pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
asm_file_for_screen_0: WORD vault_c000	; [*assembler_running_w]
	WORD vault_c000						; [*vault]
	WORD vault_c000_wraparound			; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 4								; [memory page]
	WORD $0000							; [*screen file offset]
	WORD shedule_c000					; [*shedule]
	WORD erase_queue_c000				; [*erase queue]
	
asm_file_for_screen_1: WORD drawing_code_vault	; [*assembler_running_w]
	WORD drawing_code_vault						; [*vault]
	WORD wraparound_area				; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 7								; [memory page]
	WORD $8000							; [*screen file offset]
	WORD shedule_6000					; [*shedule]
	WORD erase_queue_6000				; [*erase queue]
; [*assembler_running_w] [*vault] [*wraparound] [enable asm] [memory page] [*screen file offset] [*screen file offset] [*shedule] [*erase queue]

	; FIXME initialize shedules

vault_c000: EQU $c000 ; on page 4
	; size 13384
vault_c000_wraparound: EQU vault_c000 + 13384
vault_c000_end: EQU vault_c000_wraparound + 16
shedule_c000: EQU vault_c000_end
shedule_c000_end: EQU shedule_c000 + (shedule_entry_size * shedule_size)
erase_queue_c000: EQU shedule_c000_end
erase_queue_c000_end: EQU erase_queue_c000 + erase_queue_size * 6


;;;;;;;;;;;;;;;;;;;;;
; shedule_add_shape
; hl - shape sequence
; de - base frame number
; add_shape_places_table - places sequence
;;;;;;;;;;;;;;;;;;;;;
shedule_prev_line_a: WORD 0 ; X Y (like in memory)
shedule_prev_line_b: WORD 0
shedule_base_frame_number: WORD 0
add_shape_places_table: WORD place_single
asm_chosen_shedule: WORD 0
asm_chosen_screen_offset: BYTE 0
shedule_add_shape:
	ld (shedule_base_frame_number), de
	ld ix, hl
	ld hl, 0
	ld (shedule_prev_line_a), hl ; reset prev_line
	ld (shedule_prev_line_b), hl
shedule_add_shape_cycle1:
	; decide where to put the drawing code, which shadow screen to use
	push hl
	ld iy, asm_file_for_screen_0
	ld hl, (shedule_base_frame_number)
	ld a, l ; choice the memory page here
	and 0b00000010
	jr z, shedule_add_shape_screen_0
	ld iy, asm_file_for_screen_1
shedule_add_shape_screen_0:
	ld hl, (iy+8)
	ld a, h
	ld (asm_chosen_screen_offset), a
	ld hl, (iy+10) ; [shedule]
	ld (asm_chosen_shedule), hl
	
	; select page with shapes, so IX will work
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	ei
	
	pop hl
	
	ld bc, (ix+0)
	ld a, b
	or c
	ret z ; sequence ready
	ld bc, (shedule_prev_line_a)
	ld de, (shedule_prev_line_b)
	ld a, b
	or c
	or d
	or e ; check if prev line empty
	jr nz, shedule_add_shape_draw ; do not draw, just remember prev line
	ld bc, (ix+0) ; c = X, b = Y ??
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de
	
	jr shedule_add_shape_cycle1
shedule_add_shape_draw:
	
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_shape_asm_disabled
	
	; silkscreen (do not forget to push ix)
	ld hl, vars
	ld bc, (ix+0) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (ix+2)
	ld (hl), c
	inc hl
	ld (hl), b ; fill vars with figurine parameters
	inc hl
	ld bc, (shedule_prev_line_b) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (shedule_prev_line_a)
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	
	push ix
	
	push hl	; select page with drawing code vault
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	pop hl
	
	call silkscreen_figurine
	; call debug_lines
	; .8 call busy_wait
	
	; do not forget to set asm_file IY
	call silkscreen.silkscreen_assembler ; (returns HL)
	pop ix
shedule_add_shape_asm_disabled:
	; remember prev line
	push hl ; select page with shapes
	ld a, (player_page)
	ld l, a
	di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	ei
	pop hl
	ld bc, (ix+0)
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de ; also move ix forvard
	
	; put it in draw queue
	push ix
	
	push hl ; select page with shedule
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	pop hl
	
	ld a, (iy+6) ; [enable asm]
	or a
	call nz, shedule_add_figurine_many_places
	pop ix
	ld de, (shedule_base_frame_number)
	inc de
	inc de
	ld (shedule_base_frame_number), de
	
	jp shedule_add_shape_cycle1

	
;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine_many_places
; hl - drawing code
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_many_places:
	ld ix, (add_shape_places_table)
shedule_add_figurine_many_places_cycle:
	ld a, (ix+0)
	or a
	ret z
	push hl
	ld hl, (shedule_base_frame_number)
	ld de, (ix+3) ; [enable] [dY dX] [dFrame]
	add hl, de ; frame number displacement
	ex de, hl
	ld bc, (ix+1) ; position displacement
	pop hl
	push ix
	call shedule_add_figurine
	pop ix
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_add_figurine_many_places_cycle
	
	
	
	;call silkscreen_figurine
	;call debug_draw_silkscreen
	;call silkscreen.silkscreen_assembler ; returns hl
	;ld (test_figurine_asm), hl
	;call debug_lines
	
	;ld hl, (test_figurine_asm)
	;ld de, 41 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #0404 ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 47 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #000c ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 51 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #060c ; shift (Y X)
	;call shedule_add_figurine


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; wait_for_frame
; de - frame number (function will hang if frame_counter is less then de)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wait_for_frame:
	ld hl, (frame_counter)
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	ret nc		; carry is set if (hl < de)
	halt
	jr wait_for_frame

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine
; hl - drawing code
; de - frame numer (must not be even (because erase runs at 25 fps))
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine:
	ld ix, (asm_chosen_shedule)
	push bc
	push de
	ld b, shedule_size
	; di
shedule_add_figurine_c1:
	; move ix to empty slot here
	ld de, (ix+0)
	ld a, d ; FIXME enable byte here and there
	or e
	jr z, shedule_add_figurine_found_slot1
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, shedule_add_figurine_c1
	ld ix, (asm_chosen_shedule) ; no space left, clobber the first entry
shedule_add_figurine_found_slot1:
	pop de
	pop bc
	
	ld a, e
	or 0b00000001 ; force odd number (bug fixed)
	; FIXME force right number depending on shadow screen
	ld e, a       ; frame number ready
	ld (ix+7), de ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	
	
	push hl
	push bc
	sla b
	sla b
	sla b ; multiply by 8
	ld a, b
	ld hl, (upper_point_lower_point)
	add h
	ld b, a ; add vertical shift ; TODO add return path crop
	ld a, (upper_point_x)
	ld c, a
	call Get_Pixel_Address ; returns hl
debug_point_4:
	ld a, (asm_chosen_screen_offset)
	or h
	ld h, a ; 
	pop bc
	ld a, l      ; add horizontal shift value
	add c
	ld l, a
	ld (ix+0), l ; screen address ready
	ld (ix+1), h
	pop hl
	di
	ld (ix+2), l
	ld (ix+3), h ; drawing code address ready
	ei
	ld a, 1
	ld (ix+6), a ; enable byte
	ei
	ret


;;;;;;;;;;;;;;;;;;
; empty_routine
;;;;;;;;;;;;;;;;;;
empty_routine:
	
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
; clear screen data
;;;;;;;;;;;;;;;;;;;;;;;;;
clear_slow:
	di
	ld a, (flip_mask)
	or 7
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page 7 (no op if it is spectrum48)
	ei
debug_point_6:
	ld a, (paging_available)
	or a
	jr nz, clear_slow_paging_ok
	ld a, $00 ; nop
	ld (clear_slow_mod1), a ; self modify code so it does not write to c000
clear_slow_paging_ok:

	ld HL, #4000
	ld de, #c000 ; on page 7
	ld BC, 6144      ; clear image data (slow and nice)
clear_slow_c1:
	xor a
	ld (hl), a ; draw on screen
clear_slow_mod1:
	ld (de), a ; draw on shadow screen
	inc hl
	inc de
	dec bc
	ld a, c
	or a
	jr nz, clear_slow_skip1
	halt
clear_slow_skip1:
	or b
	jr nz, clear_slow_c1
	
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page, because program is there
	ei
	ret
	
;
; fill memory with constant byte
;
; D  - byte
; HL - start address
; BC - size
;
fill_mem:
  ld A, D
  ld (HL), A
  inc HL
  dec BC
  ld A,B
  or C
  jr nz, fill_mem
  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_figurine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_figurine:
	; TODO clear the header
	ld h, 255
	ld l, 0
	ld (upper_point_lower_point), hl ; reset upper point
	
	; clear the buffer
	ld c, 192
	ld hl, silk_data
	ld b, 255 ; these are the shape coordinates
	ld a, 0   ; they are invalid, so drawing code will fix them
silkscreen_figurine_c1:
	ld (hl), b
	inc hl
	ld (hl), a ; set second point to zero to mark it as disabled
	inc hl
	dec c
	jr nz, silkscreen_figurine_c1
	
	; do silkscreen drawing
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call silkscreen.Draw_Line
	
	
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_draw_silkscreen
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_draw_silkscreen:
;	ld hl, silk_data
;	ld c, 192 ; counter
;	ld b, 0   ; Y coordinate
;debug_draw_silkscreen_c1:
;	push bc
;	ld d, b ; make horisontal line
;	ld c, (hl) ; load X left
;	inc hl
;	ld e, (hl) ; load X right
;	inc hl
;	push hl
;	ld a, e ; check if the line is active
;	or a
;	jr z, debug_draw_silkscreen_s
;	ld a, e ; check if line is valid
;	cp c
;	jr c, debug_draw_silkscreen_s
;	jr z, debug_draw_silkscreen_s
;	dec e ; last point is not included
;	;call nz, Plot
;	;ld b, d
;	;ld c, e
;	;call nz, Plot
;	call Draw_Line
;debug_draw_silkscreen_s:
;	pop hl
;	pop bc
;	inc b
;	dec c
;	jr nz, debug_draw_silkscreen_c1
;	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_lines
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_lines:
;	ld ix, vars
;	ld bc, (ix+0) ; AB
;	ld de, (ix+2)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+2) ; BC
;	ld de, (ix+4)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+4) ; CD
;	ld de, (ix+6)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+6) ; DA
;	ld de, (ix+0)
;	call Draw_Line
;	ret
	
	
;
; this code comes from ChibiAkumas. Compute spectrum video address
;
; B  - X in bytes
; C  - Y
; return DE - mem pos in video memory
;;;;;;;;;;;;;;;;;;;;;;;;;
; get_video_pos
;;;;;;;;;;;;;;;;;;;;;;;;;
get_video_pos:
  ld a, c
  and %00111000
  rlca
  rlca
  or b
  ld e, a ; first byte is ready
  ld a, c
  and %00000111
  ld d, a
  ld a, c
  and %11000000
  rrca
  rrca
  rrca
  or d
  or #40
  ld d, a ; second byte is ready
  ret


;
; this code comes from ChibiAkumas too.
;
; DE - address in video mem
; returns DE - new address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; get_next_line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_next_line:
  inc d
  ld a, d
  and    %00000111 ; check bits Y5 Y4 Y3 overflow
  ret nz
  ld a, e
  add a, %00100000
  ld e, a
  ret c            ; check bits Y2 Y1 Y0 overflow
  ld a, d
  sub    %00001000 ; fix overflow bit Y6
  ld d, a
  ret


;;;;;;;;;;;;;;;;;;;;;;
; busy_wait
;;;;;;;;;;;;;;;;;;;;;;
busy_wait:
	push bc
	ld bc, 5000
busy_wait_loop:
	dec bc
	ld a, b
	or c
	jr nz, busy_wait_loop
	pop bc
	ret

;;;;;;;;;;;;;;;;;
; initSong
; hl,de - address of raw pt3 file
;;;;;;;;;;;;;;;;;
initSong:
	ld hl,music
	ld de,music
	ld a, (turbosound_flip_modules)
	or a
	jr z, initSong_noflip
	ex de, hl
initSong_noflip:
	ld a, (turbosound_setting_byte)
	ld (player+10),a
	     ;set bit0, if you want to play without looping
	     ;(optional);
	     ;set bit1 for PT2 and reset for PT3 before
	     ;calling INIT;
	     ;bits2-3: %00-ABC, %01-ACB, %10-BAC (optional);
	     ;bits4-5: %00-no TS, %01-2 modules TS, %10-
	     ;autodetect PT3 TS-format by AlCo (PT 3.7+);
	     ;Remark: old PT3 TS-format by AlCo (PT 3.6) is not
	     ;documented and must be converted to new standard.
	     ;bit6 is set each time, when loop point of 2nd TS
	     ;module is passed (optional).
	     ;bit7 is set each time, when loop point of 1st TS
	     ;or of single module is passed (optional).
	call player+3
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	INCLUDE "vector.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector_silkscreen.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MODULE silkscreen
	INCLUDE "vector_silkscreen.asm"
	ENDMODULE


;;;;;;;;;;;;;;;;;;;;;;;;;
; prerecorded variables here
;;;;;;;;;;;;;;;;;;;;;;;;;

frame_counter: WORD 0
draw_text_pointer: WORD draw_text_empty_byte
draw_text_screen_address: WORD $4000
draw_text_empty_byte: BYTE '$'
turbosound_setting_byte: BYTE 00010001b ; turbosound enabled
turbosound_flip_modules: BYTE 0

;
; end of code
;
code_end:

; variables here (moved to 5ccb)
vars: EQU $5ccb
	; 8 bytes
upper_point_lower_point: EQU vars + 8
	; 2 bytes
upper_point_x: EQU upper_point_lower_point + 2
	; 1 byte
silk_header: EQU upper_point_x + 1
	; 2 bytes
silk_data: EQU silk_header + 2
	; 192*2 bytes
silk_end: EQU silk_data + 192*2
drawing_code_vault: EQU silk_end
	; 13384 bytes
wraparound_area: EQU drawing_code_vault + 13384
	; 16 bytes
drawing_code_vault_end: EQU wraparound_area + 16

shedule_6000: EQU drawing_code_vault_end
shedule_size: EQU 100
shedule_entry_size: EQU 9
	; 9 * 100 bytes ; [hl register] [drawing code] [ret patch] [enable] [frame number]
erase_queue_6000: EQU shedule_6000 + shedule_entry_size * shedule_size
erase_queue_size: EQU 32
	; 32 * 6 ; [hl register] [drawing code] [ret patch]
erase_queue_end: EQU erase_queue_6000 + erase_queue_size * 6
machine_stack: EQU erase_queue_end
	; stack size 128
machine_stack_end: EQU machine_stack + 128



;;;;;;;;;;;;;;;;;;;;;;;;
; music code here
;;;;;;;;;;;;;;;;;;;;;;;;
	ORG $c000 ; it will be loaded from tape by loader
	; loader will decide to load this big piece if RAM paging is available
	; TODO or just load it anyway and then wipe it
player:
	MODULE ptsplay
	include "PTSPlay.asm"
	ENDMODULE
music:
	incbin "m.pt3"


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; scanline fill by John Metcalf
; call with d=x-coord, e=y-coord
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; set end marker

fill:
  ld l,255
  push hl

; calculate bit position of pixel

nextrun:
  ld a,d
  and 7
  inc a
  ld b,a
  ld a,1
bitpos:
  rrca
  djnz bitpos
  ld c,b
  ld b,a

; move left until hitting a set pixel or the screen edge

seekleft:
  ld a,d
  or a
  jr z,goright
  dec d
  rlc b
  call scrpos
  jr nz,seekleft

; move right until hitting a set pixel or the screen edge,
; setting pixels as we go. Check rows above and below and
; save their coordinates to fill later if necessary

seekright:  
  rrc b
  inc d
  jr z,rightedge
goright:
  call scrpos
  jr z,rightedge
  ld (hl),a
  inc e
  call checkadj
  dec e
  dec e
  call checkadj
  inc e
  jr seekright

; check to see if there's another row waiting to be filled

rightedge:
  pop de
  ld a,e
  inc a
  jr nz,nextrun
  ret  

; calculate the pixel address and whether or not it's set

scrpos:
  ld a,e
  and 248
  rra
  scf
  rra
  rra
  ld l,a
  xor e
  and 248
  xor e
  ld h,a
  ld a,l
  xor d
  and 7
  xor d
  rrca
  rrca
  rrca
  ld l,a
  ld a,b
  or (hl)
  cp (hl)
  ret

; check and save the coordinates of an adjacent row

checkadj:
  sla c
  ld a,e
  cp 192
  ret nc
  call scrpos+1
  ret z
  inc c
  bit 2,c
  ret nz
  pop hl
  push de
  jp (hl)

polyline_pointer: WORD the_logo_svg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_draw_polyline
; hl - polyline array
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_draw_polyline:
draw_polyline_cycle: ; draw logo
	ld hl, (polyline_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_draw_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_draw_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	call Draw_Line
	pop bc
	
	;ld bc, (ix+0) ; AB
	;ld de, (ix+2)
	;call Draw_Line
	
	ld hl, (polyline_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_pointer), hl
	
	jr draw_polyline_cycle
no_draw_polyline:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
shape_froggy_right:
	BYTE 129,107,124,102
	BYTE 130,105,126,101
	BYTE 136,99,131,95
	BYTE 141,93,137,89
	BYTE 143,91,138,87
	BYTE 0,0,0,0

shape_froggy_center:
	BYTE 129,105,123,105
	BYTE 129,103,123,103
	BYTE 129,97,123,97
	BYTE 129,90,123,90
	BYTE 129,88,123,87
	BYTE 0,0,0,0
shape_froggy_left:
	BYTE 124,107,128,102
	BYTE 122,105,127,101
	BYTE 117,99,121,95
	BYTE 111,93,115,89
	BYTE 109,91,114,87
	BYTE 0,0,0,0



shape_quicker_1:
	BYTE 132,185,144,185
	BYTE 128,161,149,161
	BYTE 120,130,158,130
	BYTE 0,0,0,0
shape_quicker_up_1:
	BYTE 132,5,144,5
	BYTE 128,29,149,29
	BYTE 120,60,158,60
	BYTE 0,0,0,0
shape_quicker_1_small:
	BYTE 118,179,132,180
	BYTE 112,151,139,151
	BYTE 102,139,149,140
	BYTE 0,0,0,0
shape_flyby_1:
	BYTE 10,115,14,119
	BYTE 40,82,44,87
	BYTE 118,51,119,59
	BYTE 189,66,185,70
	BYTE 198,114,192,112
	BYTE 160,132,162,125
	BYTE 126,113,134,110
	BYTE 130,83,135,88
	BYTE 199,71,201,63
	BYTE 224,105,234,107
	BYTE 186,149,187,154
	BYTE 120,137,112,143
	BYTE 114,100,108,96
	BYTE 143,64,141,54
	BYTE 211,71,219,66
	BYTE 212,128,220,132
	BYTE 164,148,160,156
	BYTE 151,111,142,114
	BYTE 177,55,172,50
	BYTE 225,23,218,17
	BYTE 0,0,0,0
shape_needle_1_phase_1:
	BYTE 221,172,223,169
	BYTE 192,156,196,152
	BYTE 0,0,0,0
shape_needle_1_phase_2:
	BYTE 162,136,164,133
	BYTE 134,118,137,114
	BYTE 0,0,0,0
shape_needle_1_phase_3:
	BYTE 71,79,74,76
	BYTE 44,62,47,58
	BYTE 0,0,0,0
shape_salute_small_left:
	BYTE 113,83,113,84
	BYTE 90,82,90,84
	BYTE 57,80,57,85
	BYTE 0,0,0,0
shape_salute_small_right:
	BYTE 121,83,121,84
	BYTE 139,83,139,84
	BYTE 177,83,177,85
	BYTE 0,0,0,0
shape_salute_small_up:
	BYTE 116,77,117,77
	BYTE 114,71,117,71
	BYTE 0,0,0,0
shape_salute_small_down:
	BYTE 116,88,118,88
	BYTE 116,97,119,97
	BYTE 0,0,0,0

shape_flyer_84_part_1:
	BYTE 103,97,104,95
	BYTE 93,94,93,91
	BYTE 79,91,80,89
	BYTE 69,91,68,89
	BYTE 60,102,58,102
	BYTE 69,126,67,128
	BYTE 113,129,114,132
	BYTE 142,120,143,123
	BYTE 158,120,157,122
	BYTE 162,127,160,127
	BYTE 159,131,157,129
	BYTE 151,132,151,129
	BYTE 133,127,134,126
	BYTE 123,118,122,116
	BYTE 115,121,114,119
	BYTE 97,124,99,122
	BYTE 89,114,91,114
	BYTE 91,105,96,106
	BYTE 98,98,119,99
	BYTE 113,91,122,90
	BYTE 120,84,122,84
	BYTE 117,80,118,77
	BYTE 105,81,105,78
	BYTE 99,87,96,84 ; 24
	BYTE 85,99,88,102
	BYTE 81,117,85,116
	BYTE 91,135,95,132
	BYTE 122,144,122,141
	BYTE 148,128,145,126
	BYTE 161,95,163,97
	BYTE 172,86,174,89
	BYTE 195,85,193,89
	BYTE 221,98,219,100 ; 64 frames, 32 phases
	BYTE 0,0,0,0
shape_flyer_84_part_2:
	BYTE 221,98,219,100
	BYTE 227,120,224,121
	BYTE 218,137,217,134
	BYTE 203,145,200,137
	BYTE 172,140,175,136
	BYTE 150,137,149,133
	BYTE 58,133,59,129
	BYTE 35,127,38,123
	BYTE 27,111,31,111
	BYTE 29,98,32,99
	BYTE 38,85,39,89
	BYTE 59,84,58,88 ; 44
	BYTE 107,89,108,86
	BYTE 134,92,136,89
	BYTE 183,101,183,97 ; 14 phases, 28 frames
	BYTE 0,0,0,0
shape_flyer_84_part_3:
	BYTE 183,101,183,97
	BYTE 214,107,217,105
	BYTE 211,133,214,136
	BYTE 183,140,184,144
	BYTE 130,138,130,143
	BYTE 77,137,77,141
	BYTE 35,129,34,134
	BYTE 27,112,22,113
	BYTE 37,88,33,85
	BYTE 58,86,59,82
	BYTE 86,87,87,83
	BYTE 120,80,119,75
	BYTE 151,80,153,75
	BYTE 179,83,179,79
	BYTE 197,86,198,82
	BYTE 211,92,216,92
	BYTE 209,111,214,113
	BYTE 199,121,200,126
	BYTE 172,129,173,134
	BYTE 160,144,166,148
	BYTE 150,153,150,159
	BYTE 132,153,131,157
	BYTE 118,151,118,155
	BYTE 102,152,102,156
	BYTE 88,152,85,156
	BYTE 84,140,80,140
	BYTE 83,99,78,98
	BYTE 100,55,96,53
	BYTE 151,61,150,56
	BYTE 187,66,191,63
	BYTE 189,113,196,111
	BYTE 189,143,197,144
	BYTE 176,150,176,156
	BYTE 93,142,93,147
	BYTE 68,131,64,133
	BYTE 73,115,47,118
	BYTE 107,105,47,97
	BYTE 118,84,58,77 ; 37 phases
	BYTE 0,0,0,0
shape_stairs_21:
	BYTE 23,31,30,31
	BYTE 24,39,29,40
	BYTE 24,47,28,47
	BYTE 23,58,29,58
	BYTE 27,67,72,67
	BYTE 70,73,74,72
	BYTE 71,78,75,78
	BYTE 72,84,75,84
	BYTE 72,90,108,92
	BYTE 77,97,113,98
	BYTE 84,104,124,105
	BYTE 120,111,130,112
	BYTE 122,117,128,117
	BYTE 126,123,130,123
	BYTE 127,129,131,129
	BYTE 130,133,176,135
	BYTE 151,141,177,141
	BYTE 175,146,179,145
	BYTE 177,152,181,153
	BYTE 177,158,183,157
	BYTE 176,162,184,164
	BYTE 180,170,186,169
	BYTE 0,0,0,0
shape_circle:
	BYTE 189,158,188,165
	BYTE 90,155,89,161
	BYTE 58,153,55,158
	BYTE 60,142,53,142
	BYTE 66,133,66,126
	BYTE 94,135,95,128
	BYTE 124,135,124,129
	BYTE 152,136,152,129
	BYTE 200,137,200,130
	BYTE 208,146,216,145
	BYTE 202,157,203,165
	BYTE 189,158,188,165
	BYTE 0,0,0,0

the_logo_svg:
	; path
	.BYTE 130, 58, 129, 57
	.BYTE 129, 57, 128, 57
	.BYTE 128, 57, 128, 55
	.BYTE 128, 55, 128, 53
	.BYTE 128, 53, 129, 52
	.BYTE 129, 52, 130, 52
	.BYTE 130, 52, 132, 52
	.BYTE 132, 52, 133, 52
	.BYTE 133, 52, 134, 52
	.BYTE 134, 52, 135, 53
	.BYTE 135, 53, 135, 55
	.BYTE 135, 55, 135, 57
	.BYTE 135, 57, 134, 57
	.BYTE 134, 57, 134, 58
	.BYTE 134, 58, 132, 58
	.BYTE 132, 58, 130, 58
	; path
	.BYTE 36, 58, 35, 57
	.BYTE 35, 57, 34, 57
	.BYTE 34, 57, 34, 55
	.BYTE 34, 55, 35, 53
	.BYTE 35, 53, 35, 52
	.BYTE 35, 52, 36, 52
	.BYTE 36, 52, 37, 51
	.BYTE 37, 51, 38, 52
	.BYTE 38, 52, 39, 52
	.BYTE 39, 52, 40, 52
	.BYTE 40, 52, 40, 53
	.BYTE 40, 53, 41, 54
	.BYTE 41, 54, 41, 56
	.BYTE 41, 56, 40, 57
	.BYTE 40, 57, 40, 58
	.BYTE 40, 58, 39, 58
	.BYTE 39, 58, 36, 58
	; path
	.BYTE 235, 91, 234, 90
	.BYTE 234, 90, 234, 89
	.BYTE 234, 89, 234, 77
	.BYTE 234, 77, 234, 64
	.BYTE 234, 64, 235, 63
	.BYTE 235, 63, 235, 62
	.BYTE 235, 62, 236, 62
	.BYTE 236, 62, 237, 62
	.BYTE 237, 62, 238, 62
	.BYTE 238, 62, 239, 63
	.BYTE 239, 63, 240, 64
	.BYTE 240, 64, 240, 65
	.BYTE 240, 65, 240, 66
	.BYTE 240, 66, 241, 64
	.BYTE 241, 64, 246, 61
	.BYTE 246, 61, 248, 61
	.BYTE 248, 61, 249, 61
	.BYTE 249, 61, 250, 62
	.BYTE 250, 62, 251, 63
	.BYTE 251, 63, 252, 63
	.BYTE 252, 63, 252, 65
	.BYTE 252, 65, 252, 66
	.BYTE 252, 66, 251, 67
	.BYTE 251, 67, 250, 68
	.BYTE 250, 68, 249, 68
	.BYTE 249, 68, 247, 67
	.BYTE 247, 67, 245, 67
	.BYTE 245, 67, 244, 67
	.BYTE 244, 67, 243, 68
	.BYTE 243, 68, 242, 69
	.BYTE 242, 69, 240, 71
	.BYTE 240, 71, 240, 72
	.BYTE 240, 72, 240, 81
	.BYTE 240, 81, 240, 90
	.BYTE 240, 90, 239, 91
	.BYTE 239, 91, 238, 91
	.BYTE 238, 91, 237, 91
	.BYTE 237, 91, 235, 91
	; path
	.BYTE 143, 91, 142, 90
	.BYTE 142, 90, 141, 90
	.BYTE 141, 90, 141, 77
	.BYTE 141, 77, 141, 64
	.BYTE 141, 64, 142, 64
	.BYTE 142, 64, 142, 63
	.BYTE 142, 63, 143, 62
	.BYTE 143, 62, 144, 62
	.BYTE 144, 62, 147, 64
	.BYTE 147, 64, 147, 65
	.BYTE 147, 65, 147, 66
	.BYTE 147, 66, 149, 64
	.BYTE 149, 64, 150, 63
	.BYTE 150, 63, 152, 62
	.BYTE 152, 62, 154, 61
	.BYTE 154, 61, 156, 61
	.BYTE 156, 61, 158, 61
	.BYTE 158, 61, 160, 62
	.BYTE 160, 62, 162, 63
	.BYTE 162, 63, 165, 69
	.BYTE 165, 69, 165, 70
	.BYTE 165, 70, 165, 80
	.BYTE 165, 80, 165, 89
	.BYTE 165, 89, 165, 90
	.BYTE 165, 90, 162, 92
	.BYTE 162, 92, 159, 90
	.BYTE 159, 90, 159, 89
	.BYTE 159, 89, 159, 80
	.BYTE 159, 80, 159, 71
	.BYTE 159, 71, 158, 70
	.BYTE 158, 70, 157, 68
	.BYTE 157, 68, 154, 67
	.BYTE 154, 67, 153, 67
	.BYTE 153, 67, 152, 68
	.BYTE 152, 68, 148, 71
	.BYTE 148, 71, 147, 72
	.BYTE 147, 72, 147, 81
	.BYTE 147, 81, 147, 90
	.BYTE 147, 90, 146, 91
	.BYTE 146, 91, 145, 91
	.BYTE 145, 91, 143, 91
	; path
	.BYTE 130, 91, 129, 90
	.BYTE 129, 90, 129, 89
	.BYTE 129, 89, 129, 77
	.BYTE 129, 77, 129, 64
	.BYTE 129, 64, 129, 63
	.BYTE 129, 63, 130, 62
	.BYTE 130, 62, 131, 62
	.BYTE 131, 62, 132, 62
	.BYTE 132, 62, 133, 62
	.BYTE 133, 62, 134, 63
	.BYTE 134, 63, 134, 64
	.BYTE 134, 64, 135, 64
	.BYTE 135, 64, 135, 77
	.BYTE 135, 77, 135, 89
	.BYTE 135, 89, 134, 90
	.BYTE 134, 90, 133, 91
	.BYTE 133, 91, 130, 91
	; path
	.BYTE 100, 91, 99, 90
	.BYTE 99, 90, 99, 89
	.BYTE 99, 89, 98, 89
	.BYTE 98, 89, 98, 71
	.BYTE 98, 71, 98, 53
	.BYTE 98, 53, 99, 52
	.BYTE 99, 52, 99, 51
	.BYTE 99, 51, 100, 51
	.BYTE 100, 51, 101, 50
	.BYTE 101, 50, 102, 51
	.BYTE 102, 51, 103, 51
	.BYTE 103, 51, 104, 52
	.BYTE 104, 52, 105, 52
	.BYTE 105, 52, 105, 59
	.BYTE 105, 59, 105, 66
	.BYTE 105, 66, 106, 65
	.BYTE 106, 65, 111, 62
	.BYTE 111, 62, 113, 61
	.BYTE 113, 61, 115, 61
	.BYTE 115, 61, 117, 62
	.BYTE 117, 62, 118, 62
	.BYTE 118, 62, 119, 63
	.BYTE 119, 63, 120, 64
	.BYTE 120, 64, 122, 70
	.BYTE 122, 70, 122, 72
	.BYTE 122, 72, 122, 80
	.BYTE 122, 80, 122, 89
	.BYTE 122, 89, 122, 90
	.BYTE 122, 90, 121, 91
	.BYTE 121, 91, 120, 91
	.BYTE 120, 91, 119, 92
	.BYTE 119, 92, 118, 91
	.BYTE 118, 91, 117, 91
	.BYTE 117, 91, 117, 90
	.BYTE 117, 90, 116, 89
	.BYTE 116, 89, 116, 81
	.BYTE 116, 81, 116, 73
	.BYTE 116, 73, 116, 71
	.BYTE 116, 71, 115, 70
	.BYTE 115, 70, 114, 69
	.BYTE 114, 69, 111, 67
	.BYTE 111, 67, 105, 71
	.BYTE 105, 71, 105, 72
	.BYTE 105, 72, 105, 81
	.BYTE 105, 81, 104, 90
	.BYTE 104, 90, 104, 91
	.BYTE 104, 91, 103, 91
	.BYTE 103, 91, 102, 91
	.BYTE 102, 91, 101, 92
	.BYTE 101, 92, 100, 91
	; path
	.BYTE 36, 91, 35, 90
	.BYTE 35, 90, 34, 89
	.BYTE 34, 89, 34, 77
	.BYTE 34, 77, 34, 65
	.BYTE 34, 65, 35, 64
	.BYTE 35, 64, 35, 63
	.BYTE 35, 63, 36, 62
	.BYTE 36, 62, 37, 62
	.BYTE 37, 62, 38, 62
	.BYTE 38, 62, 39, 62
	.BYTE 39, 62, 40, 63
	.BYTE 40, 63, 40, 64
	.BYTE 40, 64, 40, 77
	.BYTE 40, 77, 40, 89
	.BYTE 40, 89, 40, 90
	.BYTE 40, 90, 39, 91
	.BYTE 39, 91, 38, 91
	.BYTE 38, 91, 36, 91
	; path
	.BYTE 8, 91, 7, 91
	.BYTE 7, 91, 6, 89
	.BYTE 6, 89, 6, 88
	.BYTE 6, 88, 6, 72
	.BYTE 6, 72, 6, 56
	.BYTE 6, 56, 6, 55
	.BYTE 6, 55, 7, 54
	.BYTE 7, 54, 7, 53
	.BYTE 7, 53, 8, 53
	.BYTE 8, 53, 18, 53
	.BYTE 18, 53, 27, 53
	.BYTE 27, 53, 28, 53
	.BYTE 28, 53, 29, 56
	.BYTE 29, 56, 29, 57
	.BYTE 29, 57, 28, 58
	.BYTE 28, 58, 27, 59
	.BYTE 27, 59, 20, 59
	.BYTE 20, 59, 12, 59
	.BYTE 12, 59, 12, 64
	.BYTE 12, 64, 12, 69
	.BYTE 12, 69, 19, 69
	.BYTE 19, 69, 25, 69
	.BYTE 25, 69, 26, 70
	.BYTE 26, 70, 27, 71
	.BYTE 27, 71, 27, 72
	.BYTE 27, 72, 27, 73
	.BYTE 27, 73, 26, 74
	.BYTE 26, 74, 25, 75
	.BYTE 25, 75, 24, 75
	.BYTE 24, 75, 18, 75
	.BYTE 18, 75, 12, 75
	.BYTE 12, 75, 12, 82
	.BYTE 12, 82, 12, 89
	.BYTE 12, 89, 12, 90
	.BYTE 12, 90, 11, 91
	.BYTE 11, 91, 10, 91
	.BYTE 10, 91, 9, 92
	.BYTE 9, 92, 8, 91
	; path
	.BYTE 222, 73, 221, 71
	.BYTE 221, 71, 218, 68
	.BYTE 218, 68, 217, 67
	.BYTE 217, 67, 215, 67
	.BYTE 215, 67, 213, 67
	.BYTE 213, 67, 212, 68
	.BYTE 212, 68, 210, 69
	.BYTE 210, 69, 208, 73
	.BYTE 208, 73, 215, 73
	.BYTE 215, 73, 222, 73
	; path
	.BYTE 213, 92, 210, 90
	.BYTE 210, 90, 208, 90
	.BYTE 208, 90, 206, 88
	.BYTE 206, 88, 203, 83
	.BYTE 203, 83, 202, 81
	.BYTE 202, 81, 202, 78
	.BYTE 202, 78, 202, 75
	.BYTE 202, 75, 202, 73
	.BYTE 202, 73, 206, 65
	.BYTE 206, 65, 208, 64
	.BYTE 208, 64, 210, 63
	.BYTE 210, 63, 212, 62
	.BYTE 212, 62, 214, 61
	.BYTE 214, 61, 215, 61
	.BYTE 215, 61, 217, 61
	.BYTE 217, 61, 220, 63
	.BYTE 220, 63, 222, 63
	.BYTE 222, 63, 224, 65
	.BYTE 224, 65, 226, 67
	.BYTE 226, 67, 227, 69
	.BYTE 227, 69, 228, 75
	.BYTE 228, 75, 228, 77
	.BYTE 228, 77, 228, 78
	.BYTE 228, 78, 227, 79
	.BYTE 227, 79, 217, 79
	.BYTE 217, 79, 208, 79
	.BYTE 208, 79, 211, 84
	.BYTE 211, 84, 213, 85
	.BYTE 213, 85, 214, 86
	.BYTE 214, 86, 217, 86
	.BYTE 217, 86, 219, 86
	.BYTE 219, 86, 221, 85
	.BYTE 221, 85, 223, 84
	.BYTE 223, 84, 224, 84
	.BYTE 224, 84, 225, 84
	.BYTE 225, 84, 226, 85
	.BYTE 226, 85, 227, 85
	.BYTE 227, 85, 227, 86
	.BYTE 227, 86, 224, 90
	.BYTE 224, 90, 221, 91
	.BYTE 221, 91, 219, 92
	.BYTE 219, 92, 217, 92
	.BYTE 217, 92, 215, 92
	.BYTE 215, 92, 213, 92
	; path
	.BYTE 81, 92, 78, 91
	.BYTE 78, 91, 76, 90
	.BYTE 76, 90, 75, 88
	.BYTE 75, 88, 73, 87
	.BYTE 73, 87, 72, 85
	.BYTE 72, 85, 71, 81
	.BYTE 71, 81, 70, 79
	.BYTE 70, 79, 70, 77
	.BYTE 70, 77, 70, 74
	.BYTE 70, 74, 71, 72
	.BYTE 71, 72, 72, 68
	.BYTE 72, 68, 73, 67
	.BYTE 73, 67, 75, 65
	.BYTE 75, 65, 76, 63
	.BYTE 76, 63, 78, 63
	.BYTE 78, 63, 80, 62
	.BYTE 80, 62, 82, 61
	.BYTE 82, 61, 84, 61
	.BYTE 84, 61, 86, 61
	.BYTE 86, 61, 89, 62
	.BYTE 89, 62, 91, 63
	.BYTE 91, 63, 92, 64
	.BYTE 92, 64, 93, 64
	.BYTE 93, 64, 93, 65
	.BYTE 93, 65, 93, 67
	.BYTE 93, 67, 93, 68
	.BYTE 93, 68, 93, 69
	.BYTE 93, 69, 92, 70
	.BYTE 92, 70, 91, 70
	.BYTE 91, 70, 90, 70
	.BYTE 90, 70, 89, 69
	.BYTE 89, 69, 88, 68
	.BYTE 88, 68, 86, 68
	.BYTE 86, 68, 84, 67
	.BYTE 84, 67, 82, 68
	.BYTE 82, 68, 81, 68
	.BYTE 81, 68, 79, 70
	.BYTE 79, 70, 77, 71
	.BYTE 77, 71, 77, 73
	.BYTE 77, 73, 77, 75
	.BYTE 77, 75, 77, 77
	.BYTE 77, 77, 77, 80
	.BYTE 77, 80, 77, 81
	.BYTE 77, 81, 81, 85
	.BYTE 81, 85, 82, 86
	.BYTE 82, 86, 85, 86
	.BYTE 85, 86, 87, 86
	.BYTE 87, 86, 89, 85
	.BYTE 89, 85, 90, 84
	.BYTE 90, 84, 91, 84
	.BYTE 91, 84, 92, 84
	.BYTE 92, 84, 93, 85
	.BYTE 93, 85, 94, 85
	.BYTE 94, 85, 94, 87
	.BYTE 94, 87, 94, 88
	.BYTE 94, 88, 93, 89
	.BYTE 93, 89, 92, 90
	.BYTE 92, 90, 90, 91
	.BYTE 90, 91, 83, 92
	.BYTE 83, 92, 81, 92
	; path
	.BYTE 53, 92, 49, 90
	.BYTE 49, 90, 47, 89
	.BYTE 47, 89, 46, 88
	.BYTE 46, 88, 45, 87
	.BYTE 45, 87, 45, 86
	.BYTE 45, 86, 45, 85
	.BYTE 45, 85, 45, 84
	.BYTE 45, 84, 46, 83
	.BYTE 46, 83, 47, 83
	.BYTE 47, 83, 48, 82
	.BYTE 48, 82, 50, 84
	.BYTE 50, 84, 55, 87
	.BYTE 55, 87, 57, 87
	.BYTE 57, 87, 58, 87
	.BYTE 58, 87, 59, 86
	.BYTE 59, 86, 60, 86
	.BYTE 60, 86, 61, 85
	.BYTE 61, 85, 61, 84
	.BYTE 61, 84, 61, 83
	.BYTE 61, 83, 61, 82
	.BYTE 61, 82, 59, 81
	.BYTE 59, 81, 55, 79
	.BYTE 55, 79, 50, 77
	.BYTE 50, 77, 48, 76
	.BYTE 48, 76, 47, 75
	.BYTE 47, 75, 46, 73
	.BYTE 46, 73, 46, 72
	.BYTE 46, 72, 46, 69
	.BYTE 46, 69, 46, 67
	.BYTE 46, 67, 47, 66
	.BYTE 47, 66, 51, 62
	.BYTE 51, 62, 52, 62
	.BYTE 52, 62, 54, 61
	.BYTE 54, 61, 56, 61
	.BYTE 56, 61, 58, 62
	.BYTE 58, 62, 66, 66
	.BYTE 66, 66, 66, 67
	.BYTE 66, 67, 66, 68
	.BYTE 66, 68, 65, 69
	.BYTE 65, 69, 64, 70
	.BYTE 64, 70, 63, 70
	.BYTE 63, 70, 62, 70
	.BYTE 62, 70, 61, 69
	.BYTE 61, 69, 60, 68
	.BYTE 60, 68, 58, 67
	.BYTE 58, 67, 57, 67
	.BYTE 57, 67, 55, 67
	.BYTE 55, 67, 53, 67
	.BYTE 53, 67, 53, 68
	.BYTE 53, 68, 52, 69
	.BYTE 52, 69, 52, 70
	.BYTE 52, 70, 52, 71
	.BYTE 52, 71, 53, 72
	.BYTE 53, 72, 53, 73
	.BYTE 53, 73, 57, 74
	.BYTE 57, 74, 66, 79
	.BYTE 66, 79, 66, 80
	.BYTE 66, 80, 67, 82
	.BYTE 67, 82, 67, 84
	.BYTE 67, 84, 66, 86
	.BYTE 66, 86, 66, 87
	.BYTE 66, 87, 64, 89
	.BYTE 64, 89, 62, 91
	.BYTE 62, 91, 61, 91
	.BYTE 61, 91, 59, 92
	.BYTE 59, 92, 57, 92
	.BYTE 57, 92, 55, 92
	.BYTE 55, 92, 53, 92
	; path
	.BYTE 187, 85, 191, 81
	.BYTE 191, 81, 192, 80
	.BYTE 192, 80, 192, 77
	.BYTE 192, 77, 192, 74
	.BYTE 192, 74, 191, 72
	.BYTE 191, 72, 185, 67
	.BYTE 185, 67, 184, 67
	.BYTE 184, 67, 182, 68
	.BYTE 182, 68, 181, 68
	.BYTE 181, 68, 179, 69
	.BYTE 179, 69, 178, 70
	.BYTE 178, 70, 177, 72
	.BYTE 177, 72, 177, 73
	.BYTE 177, 73, 177, 77
	.BYTE 177, 77, 177, 80
	.BYTE 177, 80, 177, 81
	.BYTE 177, 81, 179, 84
	.BYTE 179, 84, 180, 85
	.BYTE 180, 85, 181, 86
	.BYTE 181, 86, 183, 86
	.BYTE 183, 86, 184, 86
	.BYTE 184, 86, 186, 86
	.BYTE 186, 86, 187, 85
	; path
	.BYTE 180, 102, 177, 101
	.BYTE 177, 101, 175, 101
	.BYTE 175, 101, 174, 100
	.BYTE 174, 100, 173, 99
	.BYTE 173, 99, 173, 98
	.BYTE 173, 98, 175, 95
	.BYTE 175, 95, 176, 94
	.BYTE 176, 94, 177, 95
	.BYTE 177, 95, 180, 96
	.BYTE 180, 96, 183, 96
	.BYTE 183, 96, 184, 96
	.BYTE 184, 96, 190, 95
	.BYTE 190, 95, 190, 94
	.BYTE 190, 94, 191, 93
	.BYTE 191, 93, 192, 92
	.BYTE 192, 92, 192, 90
	.BYTE 192, 90, 192, 88
	.BYTE 192, 88, 190, 89
	.BYTE 190, 89, 187, 91
	.BYTE 187, 91, 186, 92
	.BYTE 186, 92, 183, 92
	.BYTE 183, 92, 181, 92
	.BYTE 181, 92, 179, 91
	.BYTE 179, 91, 176, 90
	.BYTE 176, 90, 174, 88
	.BYTE 174, 88, 173, 87
	.BYTE 173, 87, 171, 79
	.BYTE 171, 79, 170, 77
	.BYTE 170, 77, 170, 75
	.BYTE 170, 75, 171, 71
	.BYTE 171, 71, 173, 67
	.BYTE 173, 67, 175, 65
	.BYTE 175, 65, 178, 63
	.BYTE 178, 63, 181, 61
	.BYTE 181, 61, 183, 61
	.BYTE 183, 61, 185, 61
	.BYTE 185, 61, 190, 64
	.BYTE 190, 64, 192, 65
	.BYTE 192, 65, 192, 64
	.BYTE 192, 64, 194, 61
	.BYTE 194, 61, 195, 61
	.BYTE 195, 61, 196, 62
	.BYTE 196, 62, 197, 62
	.BYTE 197, 62, 197, 63
	.BYTE 197, 63, 198, 64
	.BYTE 198, 64, 198, 76
	.BYTE 198, 76, 198, 88
	.BYTE 198, 88, 198, 91
	.BYTE 198, 91, 197, 94
	.BYTE 197, 94, 197, 96
	.BYTE 197, 96, 196, 97
	.BYTE 196, 97, 194, 99
	.BYTE 194, 99, 193, 100
	.BYTE 193, 100, 191, 101
	.BYTE 191, 101, 189, 102
	.BYTE 189, 102, 187, 102
	.BYTE 187, 102, 180, 102
	.BYTE 0,0,0,0


	
player_n_shapes_end:



  EMPTYTAP "nikhotmsk_u2023s_code.tap"
  SAVETAP "nikhotmsk_u2023s_code.tap",CODE,"usr40960",code_start,code_end - code_start,code_start
  SAVETAP "nikhotmsk_u2023s_code.tap",CODE,"ptsplay",player,player_n_shapes_end - player, player

	; debug messages to the console of compiler
	DISPLAY "free space before $c000: ", /A, $c000 - code_end
	DISPLAY "free space before $ffff: ", /A, $ffff - player_n_shapes_end
	IF code_end < $c000
	; DISPLAY "boundary test succeed"
	ELSE
	DISPLAY "*** WARNING the boundary test failed, to much code ***"
	ENDIF

  ; basic loader will be concatenated later by make.sh script
