		device ZXSPECTRUM48

DOTS_COUNT EQU 500

		org $8000

plot_point:
		DB %10000000,%01000000,%00100000,%00010000,%00001000,%00000100,%00000010,%00000001

		org $8100
unplot_point:
		DB %01111111,%10111111,%11011111,%11101111,%11110111,%11111011,%11111101,%11111110

get_pixel_address:	
	ld a,b
	and %00000111
	or %01000000
	ld h,a
	ld a,b
	rra
	rra
	rra
	and %00011000
	or h
	ld h,a
	ld a,b
	rla
	rla
	and %11100000
	ld l,a
	ld a,c
	rra
	rra
	rra
	and %00011111
	or l
	ld l,a
	ld a,c
	and 7
	ret

; Plot routine
; B = Y pixel position
; C = X pixel position
;
plot:			
	call get_pixel_address
	ld bc,plot_point
	add a,c
	ld c,a
	ld a,(bc)
	or (hl)
	ld (hl),a
	ret

unplot:			
	call get_pixel_address
	ld bc,unplot_point
	add a,c
	ld c,a
	ld a,(bc)
	and (hl)
	ld (hl),a
	ret

patrik_rak_cmwc_rnd:
	ld  hl,.table
.idx:
	ld  bc,0       ; i
	add  hl,bc
	ld  a,c
	inc  a
	and  7
	ld  (.idx+1),a  ; i = ( i + 1 ) & 7
	ld  c,(hl)    ; y = q[i]
	ex  de,hl
	ld  h,c    ; t = 256 * y
	ld  l,b
	sbc  hl,bc    ; t = 255 * y
	sbc  hl,bc    ; t = 254 * y
	sbc  hl,bc    ; t = 253 * y
.car:
	ld  c,0    ; c
	add  hl,bc    ; t = 253 * y + c
	ld  a,h    ; c = t / 256
	ld  (.car+1),a
	ld  a,l    ; x = t % 256
	cpl      ; x = (b-1) - x = -x - 1 = ~x + 1 - 1 = ~x
	ld  (de),a
	ret

.table    db   82,97,120,111,102,116,20,12


demo_start:
	ei

	call init_dots

loop_dots:
	halt
	ld a,1
	out ($fe),a

	ld bc,DOTS_COUNT
	ld hl, dots
show_loop:
	push bc
	ld c,(hl)	; x
	inc hl
	ld b,(hl)	; y
	inc hl
	
	ld a,(hl)	; frame
	inc a
	ld (hl),a
	inc hl

	push hl
	
	cp 127
	jr c, reset_dot
set_dot:
	call plot
	jr dot_done
	
reset_dot:
	call unplot
	
dot_done:	
	pop hl
	pop bc
	
	dec bc
	ld a,b
	or c
	jr nz, show_loop
	
	jr loop_dots


init_dots:	
	ld bc,DOTS_COUNT
init_loop:
	push bc

get_frame:
	call patrik_rak_cmwc_rnd
	push af

get_y:
	call patrik_rak_cmwc_rnd
	cp 191
	jr nc,get_y
	push af
	
get_x:
	call patrik_rak_cmwc_rnd

	ld hl,dots
dot_index:
	ld (hl),a	; x
	inc hl
	pop af
	ld (hl),a	; y
	inc hl
	pop af
	ld (hl),a	; frame
	inc hl
	ld (dot_index-2),hl
	pop bc
	dec bc
	
	ld a,b
	or c
	
	jr nz,init_loop
	
	ret

	display "dots: ", /A, $

dots:
	ds DOTS_COUNT*3

	
	SAVESNA "starfield.sna", demo_start