SKIP_TO=0

import sys_display
import bl00mbox as b
import leds, audio
import cpython.wave as wave
import time
import random
import ctx
wv=wave.open("/sd/potential_for_anything.wav","r")
assert wv.getframerate() == 48000
SAMPRATE=48000#wv.getframerate()
assert wv.getnchannels()==1
assert wv.getcomptype()=="NONE"
ch=b.Channel()
ch.volume=65535
BUFSIZE=16000
MIDPOINT=BUFSIZE//2+2
ws=ch.new(b.plugins._wavstream,BUFSIZE+2) # custom plugin
ch.mixer=ws.signals.output

leds.set_brightness(255)
#audio.speaker_set_volume_dB(14) # full volume distorts, so let's not do that

buf16=ws.table_int16_array

def random_shuffle(L):
	for i in range(len(L)):
		p=random.randint(0,i)
		L[i],L[p]=L[p],L[i]

primseccols=[(255,0,0),(0,255,0),(0,0,255),(255,255,0),(255,0,255),(0,255,255),(255,255,255)]
single_sparkles=[x for x in range(40) if x%8!=0]
sparklesAroundCounter=-1
framerate=wv.getframerate()
cues=[]
with open("/sd/potential_for_anything.txt","r") as f:
	for line in f:
		if line.endswith("\n"): line=line[:-1]
		start,end,label=line.split("\t")
		label=label.strip(" ")
		start,end=int(float(start)*framerate+0.5),int(float(end)*framerate+0.5)
		if label=="sparkles_up16":
			bright=70
			for i in range(16):
				# fade blue to white
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_up", (bright, i*bright//15, i*bright//15)))
		elif label=="sparkles_up":
			bright=70
			for i in range(8):
				# fade blue to white
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_up", (bright, i*bright//15, i*bright//15)))
		elif label=="sparkles_randomalldirs":
			bright=70
			for i in range(32):
				cues.append((start+86016*(SAMPRATE/44100)*i//8,"sparkle_randomdir", random.choice(primseccols)))
		elif label=="sparkle_singles_16":
			bright=70
			for i in range(16):
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_single", random.choice(single_sparkles)))
		elif label=="sparkle_singles_upwards_16":
			bright=70
			ordered=single_sparkles[:]
			ordered.sort(key=lambda x: abs(20-x))
			# have 35 (17.5 pairs), need only 16 pairs so discard the bottom pair and the top point
			ordered=ordered[2:-1]
			for i in range(16):
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_single", ordered[i*2]))
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_single", ordered[i*2+1]))
		elif label=="sparkle_singles_downwards_16":
			bright=70
			ordered=single_sparkles[:]
			ordered.sort(key=lambda x: abs(20-x))
			# have 35 (17.5 pairs), need only 16 pairs so discard the bottom pair and the top point
			ordered=ordered[2:-1]
			ordered=ordered[::-1] # the only difference with the upwards one
			for i in range(16):
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_single", ordered[i*2]))
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_single", ordered[i*2+1]))
		elif label=="sparkles_sidesonly_16":
			col=(0,0,255)
			for i in range(0,16,2):
				cues.append((start+86016*(SAMPRATE/44100)*i//8,"sparkle_random", 2, col))
				cues.append((start+86016*(SAMPRATE/44100)*i//8,"sparkle_random", 3, col))
				cues.append((start+86016*(SAMPRATE/44100)*(i+1)//8,"sparkle_random", 6, col))
				cues.append((start+86016*(SAMPRATE/44100)*(i+1)//8,"sparkle_random", 7, col))
		elif label=="sparkles_randomup":
			bright=192 # much brighter than regular sparkles
			sparkle_colours=[(255,0,0),(0,255,0),(0,0,255),(255,255,0),(0,255,255),(255,0,255)]*2
			random_shuffle(sparkle_colours)
			i=0
			for r,g,b in sparkle_colours[:8]:
				# fade blue to white
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_up", (bright*r//255, bright*g//255, bright*b//255)))
				i+=1
		elif label=="sparkles_random":
			# plan the whole cluster to avoid overwriting segments more than once, or too much of the same colour
			segments=[0,1,2,3,4,5,6,7,8,9]
			random_shuffle(segments)
			sparkle_colours=[(255,0,0),(0,255,0),(0,0,255),(255,255,0),(0,255,255),(255,0,255)]*2
			random_shuffle(sparkle_colours)
			for i in range(8):
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", segments[i], sparkle_colours[i]))
		elif label=="sparkles_bigrandom":
			# 32 randoms in 168000 samples; use whole petals
			segments=[]
			lastseg=None
			sparkle_colours=[(255,0,0),(0,255,0),(0,0,255),(255,255,0),(0,255,255),(255,0,255)]*2
			random_shuffle(sparkle_colours)
			for i in range(64):
				if len(segments)==0:
					segments=[0,1,2,3,4]
					random_shuffle(segments)
					if segments[0]==lastseg:
						segments=segments[1:]+segments[:1]
					random_shuffle(sparkle_colours) # not so critical to avoid duplicate colours
				lastseg=segments[0]
				segments[0:1]=[]
				col=sparkle_colours[i%10]
				cues.append((start+168000*(SAMPRATE/44100)*i//64,"sparkle_random",lastseg*2,col))
				cues.append((start+168000*(SAMPRATE/44100)*i//64,"sparkle_random",lastseg*2+1,col))
		elif label=="sparkles_windupanddown":
			colours=[]
			bright=128
			# fade blue to white then white to red
			for i in range(16):
				colours.append((i*bright//15, i*bright//15, bright))
			colours = colours+[(b,g,r) for (r,g,b) in colours[::-1]]
			startseg=random.randint(0,4)*2
			segments=[(startseg+i)%10 for i in range(17)]
			segments=segments[:-1]+segments[::-1][:-1]
			for i in range(32):
				cues.append((start+168000*(SAMPRATE/44100)*i//32,"sparkle_random",segments[i],colours[i]))
		elif label=="sparkles_around":
			sparklesAroundCounter=(sparklesAroundCounter+1)%3
			if sparklesAroundCounter==0:
				startseg=random.randint(0,4)
				for i in range(8):
					j=(i+startseg)%5
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2, (255,255,255)))
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2+1, (255,255,255)))
			elif sparklesAroundCounter==1:
				startseg=random.randint(0,9)
				for i in range(8):
					j=i+startseg
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", (j%10), (255,255,255)))
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", ((j+5)%10), (255,255,255)))
			elif sparklesAroundCounter==2:
				segments=[0,1,2,3,4]
				random_shuffle(segments)
				for i in range(8):
					j=segments[i%5]
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2, (255,255,255)))
					cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2+1, (255,255,255)))
		elif label=="sparkles_around6":
			segments=[2,3,4,0,1,2]
			for i in range(6):
				j=segments[i]
				# TODO note sure 86016 is the right number
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2, (90,90,90)))
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2+1, (90,90,90)))
		elif label=="sparkles_blue16":
			segments=[0,1,2,3,4]*4
			random_shuffle(segments)
			for i in range(16): # not 16
				j=segments[i]
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2, (0,0,180)))
				cues.append((start+86016*(SAMPRATE/44100)*i//16,"sparkle_random", j*2+1, (0,0,180)))
		else:
			cues.append((start,label))

cues=sorted(cues)

end=False
def fill(low,hi):
	fr=wv.readframes(hi-low)
	if len(fr)<(hi-low)*2:
		# end of file? TODO drain gradually and don't discard last data
		global end
		end=True
		return
	ws.table_bytearray[low*2:hi*2] = fr	

samplebase=SKIP_TO
wv.setpos(SKIP_TO)
SKIP_TO=0 # TODO: delete old skipping code below


fill(2,BUFSIZE+2)
buf16[0]=2
buf16[1]=BUFSIZE # approx. Doesn't have to be precise as we keep cycling it

# TODO: use slew rate, then maybe also need autoupdate
leds.set_slew_rate(255)
#leds.set_slew_rate(50) # slow slew (5) is too slow, fast slow (50) is too "temporally pixelated", so do the slewing ourselves with the system set to maximum slew
# TODO: set brightness 255

led2type1seg=[1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1]
assert len(led2type1seg)==40

class LedLayer():
	def __init__(self):
		self.leds=[0]*120 # r,g,b,r,g,b,r,g,b,...
	def update(self, nsamples): pass

class LedLayerFader(LedLayer):
	def __init__(self, base, fadetime_seconds):
		super().__init__()
		self.base = base
		self.timing_error=0
		self.fadetime_samples=int(0.5+SAMPRATE*fadetime_seconds/255.0)
	def update(self, nsamples):
		self.timing_error += nsamples
		if self.timing_error > self.fadetime_samples:
			delta=int(self.timing_error/self.fadetime_samples)
			self.timing_error -= delta*self.fadetime_samples
		else:
			return
		basel=self.base.leds
		selfl=self.leds
		for _ in range(120):
			diff=basel[_]-selfl[_]
			if diff<-delta: diff=-delta
			if diff>delta: diff=delta
			selfl[_]+=diff

class LedLayerAdditiveBlend(LedLayer):
	def __init__(self, *bases):
		super().__init__()
		self.bases=bases
	def update(self,nsamples):
		selfl=self.leds
		for _ in range(120): selfl[_]=0
		for b in self.bases:
			bl=b.leds
			for _ in range(120):
				selfl[_]+=bl[_]
		for _ in range(120):
			if selfl[_]>255: selfl[_]=255

class LedLayerUpSparkler(LedLayer):
	def __init__(self,offset):
		super().__init__()
		self.queue=[0]*(21*3)
		self.updateInterval=SAMPRATE//25
		self.sampleCounter=0
		self.reversed=False
		self.offset=offset
	def update(self,nsamples):
		queue=self.queue
		self.sampleCounter += nsamples
		nupdates = self.sampleCounter // self.updateInterval
		if nupdates == 0: return
		self.sampleCounter -= self.updateInterval * nupdates
		if nupdates >= len(queue):
			queue = [0]*(21*3)
		else:
			queue = queue[nupdates*3:]+[0]*(nupdates*3)
		self.queue=queue
		offset=self.offset*3
		for _ in range(0,21):
			if self.reversed:
				i1=(20-_)*3
				i2=(40-(20-_))*3
				if _ == 20: i2 = i1
			else:
				i1=_*3
				i2=(40-_)*3
				if _ == 0: i2 = i1
			i1=(i1+offset)%120
			i2=(i2+offset)%120
			j=_*3
			self.leds[i1]=queue[j]
			self.leds[i1+1]=queue[j+1]
			self.leds[i1+2]=queue[j+2]
			self.leds[i2]=queue[j]
			self.leds[i2+1]=queue[j+1]
			self.leds[i2+2]=queue[j+2]
	def reverseDirection(self):
		self.reversed = not self.reversed

single_sparkle_cols=[(255,0,0),(0,255,0),(0,0,255),(255,0,255),(255,255,0),(0,255,255),(255,255,255)]
class LedLayerRandomSparkler(LedLayerFader):
	def __init__(self):
		super().__init__(LedLayer(), 0.7)
	def sparkle(self, segment, colour):
		start=segment*4+1
		k=start*3
		selfl=self.leds
		r,g,b=colour
		for _ in range(3):
			selfl[k]=r
			selfl[k+1]=g
			selfl[k+2]=b
			k+=3
	def sparkle_single(self, which=None):
		if which is None:
			which=random.choice(single_sparkles)*3
		else:
			which=which*3
		r,g,b=random.choice(single_sparkle_cols)
		selfl=self.leds
		selfl[which]=r
		selfl[which+1]=g
		selfl[which+2]=b



bash_states=[
	[], # state 0, idle
	[4+n*8 for n in range(5)],
	[4+n*8+1 for n in range(5)]+[4+n*8-1 for n in range(5)],
	[4+n*8+2 for n in range(5)]+[4+n*8-2 for n in range(5)],
	[4+n*8+3 for n in range(5)]+[4+n*8-3 for n in range(5)],
	[4+n*8 for n in range(5)]
]
bash_state_bright=[0,255,200,150,100,50]
class LedLayerBash(LedLayer):
	def __init__(self):
		super().__init__()
		self.updateInterval=SAMPRATE//4
		self.sampleCounter=0
		self.state=0
	def update(self,nsamples):
		self.sampleCounter += nsamples
		if self.sampleCounter >= self.updateInterval:
			self.sampleCounter -= self.updateInterval
			if self.sampleCounter > self.updateInterval: self.sampleCounter = 0 # don't run too far behind (e.g. when SKIP_TO is set)
		else:
			return
		if self.state==0: return
		sleds=self.leds
		for i in bash_states[self.state]:
			i*=3
			sleds[i]=0
			sleds[i+1]=0
			sleds[i+2]=0
		self.state+=1
		if self.state==len(bash_states): self.state=0
		bright=bash_state_bright[self.state]
		for i in bash_states[self.state]:
			i*=3
			sleds[i]=255
			sleds[i+1]=255
			sleds[i+2]=255
			
	def bash(self):
		self.state=1


roundgreen_offsets=[0,8,16,24,32]
class LedLayerRoundGreen(LedLayerFader):
	def __init__(self):
		super().__init__(LedLayer(),1)
		self.enabled=False
		self.updateInterval=SAMPRATE//20
		self.sampleCounter=0
		self.state=0
	def update(self,nsamples):
		super().update(nsamples)
		self.sampleCounter += nsamples
		if self.sampleCounter >= self.updateInterval:
			self.sampleCounter -= self.updateInterval
			if self.sampleCounter > self.updateInterval: self.sampleCounter = 0 # don't run too far behind (e.g. when SKIP_TO is set)
		else:
			return
		sleds=self.leds
		for r in roundgreen_offsets:
			i=(self.state+r)%40*3
			sleds[i:i+3]=0,0,0
		self.state=(self.state+1)%40
		if self.enabled:
			for r in roundgreen_offsets:
				i=(self.state+r)%40*3
				sleds[i:i+3]=0,255,0
	

roundgreen=LedLayerRoundGreen()
introLeds=LedLayer()
introFader=LedLayerFader(introLeds,0.16)
sparklerDirs=[LedLayerUpSparkler(8*k) for k in range(5)]
upSparkler=sparklerDirs[0]
randomSparkler=LedLayerRandomSparkler()
basher=LedLayerBash()
bashFader=LedLayerFader(basher,1)
rootMixer=LedLayerAdditiveBlend(introFader,randomSparkler,bashFader,roundgreen,*sparklerDirs)

def process_type_1_cue(cue):
	flags=0
	pos=0
	for k,letter in enumerate("123rgb"):
		if cue[pos]==letter:
			flags |= 1 << k
			pos+=1
			if pos==len(cue): break
		
	#assert pos==len(cue) or cue[pos:]=="off"
	
	# now reset active
	segflags=[0,0,0,0] # first always 0
	if flags & 4: segflags[1] = flags
	if flags & 2: segflags[2] = flags
	if flags & 1: segflags[3] = flags
	
	k=0
	ledslist=introLeds.leds
	for led in range(40):
		rgb=segflags[led2type1seg[led]]
		ledslist[k]=255 if rgb&8 else 0
		ledslist[k+1]=255 if rgb&16 else 0
		ledslist[k+2]=255 if rgb&32 else 0
		k+=3

last_setleds=0
def set_leds(cursample):
	global last_setleds
	delta=cursample-last_setleds
	last_setleds=cursample
	
	introFader.update(delta)
	for sp in sparklerDirs:
		sp.update(delta)
	randomSparkler.update(delta)
	basher.update(delta)
	bashFader.update(delta)
	roundgreen.update(delta)
	rootMixer.update(delta)
	
	root=rootMixer
	k=0
	l=root.leds
	for _ in range(40):
		leds.set_rgb(_,l[k],l[k+1],l[k+2])
		k+=3

def update_display(ctx, cursample):
	if False: # test display
		x = (cursample // 441) % 100 - 50
		ctx.rgb(255,0,0).rectangle(x,-50,100,100).fill()

last_disp_update=0
def checkcues(cursample):
	global last_disp_update
	if len(cues) > 0 and cues[0][0] < cursample:
		cue=cues[0][1]
		whole_cue=cues[0]
		nothing_but_the_cue=cues[0][1:]
		cues[0:1]=[]
		if cue.startswith("="):
			process_type_1_cue(cue[1:])
		elif cue.startswith("sparkle_"):
			if cue=="sparkle_up":
				b,g,r=whole_cue[2] # reversed for some reason
				upSparkler.queue[-1]=b
				upSparkler.queue[-2]=g
				upSparkler.queue[-3]=r
			elif cue=="sparkle_randomdir":
				r,g,b=whole_cue[2]
				sp=random.choice(sparklerDirs)
				sp.queue[-1]=r
				sp.queue[-2]=g
				sp.queue[-3]=b
			elif cue=="sparkle_random":
				randomSparkler.sparkle(whole_cue[2], whole_cue[3])
			elif cue=="sparkle_single":
				randomSparkler.sparkle_single(whole_cue[2])
			elif cue=="sparkle_blue":
				upSparkler.queue[-1]=255
			else:
				print("unknown cue ",cue)
		elif cue=="sparkles_upisnowdown":
			upSparkler.reverseDirection()
		elif cue=="bash":
			basher.bash()
		elif cue=="roundgreen_on": roundgreen.enabled=True
		elif cue=="roundgreen_off": roundgreen.enabled=False
		else:
			print("unknown cue ",cue)
	else:
		# update continuously with no regard for battery life
		set_leds(cursample)
		leds.update()
		if cursample>last_disp_update+48000//30:
			c=sys_display.get_ctx()
			c.start_frame()
			c.rgba(0,0,0,255).rectangle(-120,-120,240,240).fill()
			update_display(c, cursample)
			# no end_frame as this breaks it
			sys_display.update(c)
			last_disp_update=cursample

while not end:
	if SKIP_TO >= MIDPOINT-2:
		SKIP_TO -= MIDPOINT-2
	else:
		while buf16[0] < MIDPOINT:
			readpos = buf16[0]
			if readpos >= MIDPOINT: break # time to refill buffer
			checkcues(readpos+samplebase)
	fill(2,MIDPOINT)
	buf16[1]=MIDPOINT
	if SKIP_TO >= MIDPOINT-2:
		SKIP_TO -= MIDPOINT-2
	else:
		while True:
			readpos=buf16[0]
			if readpos < MIDPOINT: break # time to refill buffer
			checkcues(readpos+samplebase)
	fill(MIDPOINT,2+BUFSIZE)
	buf16[1]=BUFSIZE-1 # not 0, so that C code won't loop if we abort at this point
	samplebase+=BUFSIZE

