// attributes from vertShader.vert
varying vec4 vColor;
varying vec2 vTexCoord;

// uniforms
uniform sampler2D uTexture;
uniform float uTime;

void main() {
	float bpm = 126 /60;
	float slowt = uTime /20;
	float center = 1920 / 2.0;
	vColor = vec4(vColor.x + 0.25, vColor.y + 0.15 * sin(bpm*uTime), vColor.z + 0.51, vColor.w);
	float warp = pow(atan2(gl_FragCoord.y , gl_FragCoord.x + sin(vTexCoord.x) ),2);
	float coef = abs(cos(gl_FragCoord.y *2.0 )+1.0)*cos(30* gl_FragCoord.x)-3.0;
	vTexCoord.y =  (vTexCoord.y);
	float powOn = cos(coef*((slowt)))*.01;
	vTexCoord.x =  sqrt(warp - powOn)*sin(slowt)*.03 +1.0* vTexCoord.x;
	
	gl_FragColor = vColor * texture2D(uTexture, vTexCoord);
}
