; Race to the DeadLine by MX^Addict 2023 (mxadd@mxadd.org)
BITS 16
org 100h

;
; Config
;
%define TESTKEYEXIT    1				; Exit on keypress
%define RESTORETXTMODE 0				; Restore text mode on exit (usefull for debugging)
%define ASSUMEREGS     1                ; Assume: ax=0 bx=0 cx=255 si=100h
%define USESOUND       1				; Sound

;
; Defines
;
%define var_temp0   -4
%define var_temp1   -8
%define all_vars    16

;
; Entry point
;
start:

	; Room for temporary vars
	
	mov		bp, sp
	sub		sp, all_vars

	; Init gfx
	
	mov 	al, 0x13 
	int 	0x10
	push 	0xa000
	pop  	es

	; Frame counter
	
%if !ASSUMEREGS
	xor 	si, si
%endif
		
%if USESOUND

	mov 	dx, 0x331
	mov 	al, 0x3F
	out 	dx, al
	dec 	dx

    ; Call Instrument 126 (helicopter) with note 40 and loudness 100 on channel 0

	mov     al, 0xC0				; change instrument on channel 0
	out     dx, al

	mov     al, 126					; to this instrument (indexes of midi instruments http://www.midi.org/techspecs/gm1sound.php)
	out     dx, al

	mov     al, 0x90				; play note on channel 0
	out     dx, al		

    mov     al, 40					; play THIS note
	out     dx, al

	mov     al, 100					; play it THAT loud
	out     dx, al

%endif

	; Main loop
	
.top:

	inc     si						; next frame
	mov     di, 64000               ; frame buffer offset
	mov     cx, -127                ; y position (count backwards)

%if TESTKEYEXIT

	; Wait for key

	in      al, 0x60				; read a character from keyboard into AL
	dec     al
	jnz     .yloop                  ; return to top of loop if AL != 1 (ESC)

%if RESTORETXTMODE

	; Restore text mode (for debugging only)

	mov		ax, 0x3
	int		0x10
%endif

	; End!

	ret
%endif

	; YLoop

.yloop:

	mov     bx, -160                ; x position (count backwards)

	; XLoop

.xloop:

	dec		di						; decrease frame buffer offset (we draw from bottom-right to top-left)
	jz      .top

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	; bp == stack frame
	; si == frame index
	; di == pixel position [0 - 320*200]
	; bx == X [-160 ... 160]
	; cx == Y [-100 ... 100]
	; [es:di] == current pixel address
	; dx == free
	; ax == free

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ; Time = float(FrameIndex)* _0_02f
    ; 
    ; dx = float(X) / _160_0i
    ; dy = float(Y) / _160_0i
    ; v  = fld1 / (_0_1f-dy)
    ; qx = dx * v
    ; qy = dy * v
    ; qz = v
    ; k  = sinf(Time * fldlg2)
    ; qx-= _0_05f * k * k * k * qz * qz
    ; qx*= qx
    ; 
    ; qxx = short(qx * _90_0i)
    ; vxx = short(sinf(_4_0i * qz + _40_0i * Time) * _90_0i)

	pusha
	test	cx, cx
	jg		.SkyGradient

	fild	word [._160_0i+2]
	fild 	word [ebp-(all_vars+4)]		; cx
	fdiv	st0, st1
	fild 	word [ebp-(all_vars+8)]		; bx
	fdiv	st0, st2
	fild	word [ebp-(all_vars+14)]	; si
	fdivrp	st3, st0

	; st0 = dx
	; st1 = dy
	; st2 = Time
	; st3 = 0
	; st4 = 0
	; st5 = 0
	; st6 = 0
	; st7 = 0

    fld     st1
    fsubr   dword [_0_1f]
    fld1
    fdivrp	st1, st0

    ; st0 = v
	; st1 = dx
	; st2 = dy
	; st3 = Time
	; st4 = 0
	; st5 = 0
	; st6 = 0
	; st7 = 0
		
    fmul    st1, st0
    fmul    st2, st0

    ; st0 = qz
	; st1 = qx
	; st2 = qy
	; st3 = Time
	; st4 = 0
	; st5 = 0
	; st6 = 0
	; st7 = 0

    fldlg2
    fmul	st0, st4
    fsin

    ; st0 = k
    ; st1 = qz
	; st2 = qx
	; st3 = qy
	; st4 = Time
	; st5 = 0
	; st6 = 0
	; st7 = 0

    fld		st0
    fmul	dword [_0_05f]
    fmul	st0, st1          
    fmulp   st1, st0       
    fmul	st0, st1
    fmul	st0, st1          
	fsubp	st2, st0

    ; st0 = qz
	; st1 = qx
	; st2 = qy
	; st3 = Time
	; st4 = 0
	; st5 = 0
	; st6 = 0
    ; st7 = 0

    fimul	word [_0_05f]				; It's short(4) !
    fxch 	st3
    fimul	word [_0_1f]				; It's short(40) !

    ; st0 = _40_0i*Time
	; st1 = qx
	; st2 = qy
	; st3 = _4_0i*qz
	; st4 = 0
	; st5 = 0
	; st6 = 0
    ; st7 = 0

    faddp	st3, st0

	; st0 = qx
	; st1 = qy
	; st2 = _4_0i*qz + _40_0i*Time
	; st3 = 0
	; st4 = 0
	; st5 = 0
    ; st6 = 0
    ; st7 = 0

    fmul	st0, st0      
    fimul	word [_90_0i]
    fistp	dword [bp+var_temp0]		; qxx

	; st0 = qy
	; st1 = _4_0i*qz + _40_0i*Time
	; st2 = 0
	; st3 = 0
	; st4 = 0
    ; st5 = 0
    ; st6 = 0
    ; st7 = 0

    fstp	st0
    fsin
    fimul	word [_90_0i]
    fistp	word [bp+var_temp1]			; vxx

    ; FPU stack is empty at this point

    mov		ax, [bp+var_temp0]			; qxx
    mov		dx, [bp+var_temp1]			; vxx

	test	dx, dx
    jle		.VxxLE
    cmp		ax, 250
    jle .QxxLE0
        mov		cl, 0x02				; Dark stripes on grass
        jmp		.FinalResult
.QxxLE0:
    cmp		ax, 150
    jle .QxxLE1
        mov		cl, 0x0F				; White stripes on road border
        jmp		.FinalResult
.QxxLE1:
        mov		cl, 0x08				; Dark stripes on asphalt
        jmp		.FinalResult
.VxxLE:
    cmp		ax, 250
    jle .QxxLE2
        mov		cl, 0x0A				; Bright stripes on grass
        jmp		.FinalResult
.QxxLE2:
    cmp		ax, 150
    jle .QxxLE3
        mov		cl, 0x28				; Red stripes on road border
        jmp		.FinalResult
.QxxLE3:
	test ax, ax
    jle .QxxLE4
        mov		cl, 0x07				; Bright stripes on asphalt
        jmp		.FinalResult
.QxxLE4:
	mov		cl, 0x0F					; White stripes on asphalt
	jmp		.FinalResult
.SkyGradient:

	shr		cl, 2
	add		cl, 43

.FinalResult:
	mov		[es:di], cl
	popa

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	; Loop maintance

	inc     bx                          ; next X
._160_0i:
	cmp     bx, 160
	jne     .xloop
	inc     cx                          ; next Y
	jmp     .yloop

	;; EOP
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Data & BSS sections

_0_05f		dd      0x3d4c0004			; It's float(0.0498) and at the same time short(4)
_0_1f		dd      0x3dcc0028			; It's float(0.0996) and at the same time short(40)
_90_0i		dw		90
