; Odd Future
; x86 code: TomCat/Abaddon
; music: ern0/Abaddon
; GLSL prototype: Butadine, TomCat, Kamoshika

RESX EQU 640
RESY EQU 480

ORG 256

;FNINIT
 MOV BH,80H
 MOV GS,BX
 MOV DI,0A000H
 MOV FS,DI

setvideo:
 INC CX
 MOV AX,4F01H
 INT 10H
 MOV AL,[DI+11H]
 ADD AL,[DI+19H]
 CMP AL,10+32
 JNE setvideo
 MOV BX,CX
 MOV AX,4F02H
 INT 10H

 INC SI 			; Write Combine speedup
 PUSH SI			; (kills DOSBox)
 PUSH SI			; greets to Rrrola

 MOV CX,colors+1-257
extend:
 LODSB
 MOV [DI],AX
 FILD WORD [DI]
 FLD1
 FDIV ST0,ST1
 FSTP DWORD [DI+124]
 FSTP DWORD [DI]
 ADD DI,4
 LOOP extend

 POP EAX			; MOV EAX,01010101H
 DB 66H 			; greets to Ervin
 LEA CX,[259H]			; MOV ECX,00000259H
 CDQ				; MOV EDX,00000000H
 WRMSR				; greets to HellMood

 MOV SI,DI
 POP DI

 MOV AX,3508H
 INT 21H
 XCHG DI,BX
 MOV DH,46H
 PUSHA

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,97-90H
 CALL init

 FLDPI				; PI
 FDIV DWORD [BX-8]		; PI/8192
 FLDZ				; 0 PI/8192
singen:
 FLD ST0			; a a PI/8192
 FCOS				; cos a PI/8192
 FSTP DWORD [GS:BX]		; a PI/8192
 FADD ST0,ST1			; a+PI/8192 PI/8192
 ADD BX,4
 JNZ singen
 FDIV ST0,ST0			; 1 PI/8192
 FDIVRP ST1,ST0 		; 8192/PI
 FSTP DWORD [SI+16]
;FSTP QWORD [SI+16]

;PUSHA
;MOV BX,08000H
;MOV [GS:BX],BX
;POPA

nextframe:
 FILD WORD [COUNTER+1]		; time
 FMUL DWORD [SI+104]		; t

 MOV DX,2
 MOV AX,4F05H
 INT 10H
 MOV DI,8000H-16;SP
 MOV BP,RESY/2-64

;AX:00??H
;BX:0
;CX:xcoord (-RESX/2...RESX/2)
;DX:video bank
;SI:data offset (0A780H)
;DI:video offset
;BP:ycoord (RESY/2-64...-RESY/2+64)
;SP:-16
nextline:
 MOV CX,-RESX/2
self:
nextpixel:
 PUSHA				; -32:DI SI BP SP BX DX CX AX cos.4 ? 8192 sin.4

 MOV BP,-96			; BP:colorindex
 FILD WORD [BX-28]		; y t
 FMUL DWORD [SI+104]		; py t
 MOVAPS XMM1,[SI+BP]

 MOV AL,[COUNTER+2]
;MOV AX,[COUNTER+1]
;ADD AX,63
;SHR AX,8
 MOV DI,part2
 TEST AL,4
 JNZ .1
 MOV DI,part3
 TEST AL,8
 JNZ .1
 SALC
 MOV DI,part1
 FSUB ST0,ST0			; 0 t
 SHUFPS XMM1,XMM1,01010101B
.1:
 SUB CX,CX
 CALL DI

 POPA

 CVTPS2DQ XMM1,XMM1
 PACKSSDW XMM1,XMM1
 PACKUSWB XMM1,XMM1
 UNPCKHPS XMM1,XMM0
 SHUFPS XMM0,XMM1,10111001B

 INC CX
 TEST CL,3
 JNZ skip

putpixel:
 SUB DI,SP
 JNZ nobank
 INC DX
 MOV AX,4F05H
 INT 10H
nobank:
 MOVAPS [FS:DI],XMM0

skip:
 CMP CX,RESX/2
 JNE nextpixel
 DEC BP
 CMP BP,-RESY/2+64
 JNE nextline

 FSTP ST0

 IN AL,60H			; check for keypress
 DEC AX 			; if not pressed
 JNZ nextframe			; then go to next frame
;JMP nextframe			; then go to next frame

 POP DX
 PUSH ES
 POP DS
 PUSH AX

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN

;-------------------------------------------------------------------------------
part2:
 SHUFPS XMM1,XMM1,11101111B
 FILD WORD [BX-20]		; x py t
 FMUL DWORD [SI+104]		; px py t
 FLD ST2			; t px py t
 FADD ST0,ST0			; 2*t px py t
 CALL SINCOS			; c s px py t
 FSTP DWORD [SI+8]		; s px py t
 FST DWORD [SI+24]		; s px py t
 CALL ROTATE2D			; px py c t
 FLD DWORD [SI+8]		; c px py t
 CALL SINCOS			; cos(c) sin(c) px py t
 FSTP ST0			; sin(c) px py t
 FMUL DWORD [SI+88]		; .5*sin(c) px py t
 FADD DWORD [SI+88]		; .5*sin(c)+.5 px py t

 FLDLG2 			; .3 z px py t
 FMUL ST0,ST1			; .3*z z px py t
 FSTP DWORD [SI+12]		; z px py t
 FLD ST0			; r r px py t
 FMUL ST1,ST0			; r m px py t
 MOV DI,-16*4
nextobj:
 FLD DWORD [SI+88]		; .5 r m px py t
 FDIV ST0,ST1			; .5/r r m px py t
 FSTP DWORD [SI+8]		; r m px py t
 FLD ST3			; py r m px py t
 FMUL DWORD [SI+88]		; .5*py r m px py t
 FLD ST0			; .5*py .5*py r m px py t
 FCHS				; -.5*py .5*py r m px py t
.x2:
 CALL genmods
 JC .x2 			; mod((s*px+.5*py)/r,2)/2 mod((s*px-.5*py)...
 CWD
 INC DX
 FLD DWORD [SI+88]		; .5 mod((s*px+.5*py)/r,2)/2 mod((s*px-.5*py)...
 FCOMI ST0,ST1
 JAE .1
 INC DX
.1:
 FCOMIP ST0,ST2
 JBE .2
 CWD
.2:
 DEC DX
 JZ notfound2
 MOV [SI],DX
 FCOMPP 			; r m px py t
 FLD ST3			; py r m px py t
 FMUL ST0,ST0			; py*py r m px py t
 FLD ST1			; r py*py r m px py t
 FMUL ST0,ST0			; r*r py*py r m px py t
 FCOMI ST0,ST1			; r*r py*py r m px py t
 JBE notfound2
 FSUBRP ST1,ST0 		; d2 r m px py t
 FLD ST0			; d2 d2 r m px py t
 FIMUL WORD [SI]		; f*d2 d2 r m px py t
 FCOMI ST0,ST3
 JA notfound2
 FSTP ST3			; d2 r m px py t
 FSQRT				; pz r m px py t
 FLD ST4			; py pz r m px py t
 FIMUL WORD [SI]		; f*py pz r m px py t
 FCOMI ST0,ST1			; f*py pz r m px py t
 FSUBR ST0,ST1			; pz-f*py pz r m px py t
 JBE .3
 FSUB ST0,ST0			; max(0,pz-f*py) pz r m px py t
.3:
 FADD ST1,ST0			; cd cs r m px py t
 FLD DWORD [SI+8]		; .5/r cd cs r m px py t
 FMUL ST1,ST0			; .5/r cd/r/2 cs r m px py t
 FMUL ST0,ST2			; cs/r/2 cd/r/2 cs r m px py t
 FSTP DWORD [SI+4]		; cd/r/2 cs r m px py t
 FADD DWORD [SI+56]		; cd/r/2+.2 cs r m px py t
 FLD DWORD [SI+72]		; .1 cd/r/2+.2 cs r m px py t
 FIMUL WORD [SI]		; f*.1 cd/r/2+.2 cs r m px py t
 FSUBP ST1,ST0			; cd/r/2+.2-f*.1 cs r m px py t
 FST DWORD [SI+32]		; l cs r m px py t
 MOV BP,DI
 INC CX
notfound2:
 FCOMPP 			; r m px py t
notfound0:
 FLD DWORD [SI+24]		; s r m px py t
 FADD ST3,ST0			; s r m px+s py t
 FADDP ST3,ST0			; r m px+2s py t
 FSUB DWORD [SI+12]		; r m px py t
 ADD DI,16
 JNZ nextobj
 FCOMPP 			; px py t
 FCOMPP 			; t
 JCXZ background

 FLDLN2
 FADD DWORD [SI+88]
 FMUL DWORD [SI+4]		; cs t
 MOV CL,4
.x4:
 FMUL ST0,ST0			; cs16 cs t
 LOOP .x4
 FSTP DWORD [SI]		; t
 MOVAPS XMM1,[SI]
 SHUFPS XMM1,XMM1,0
addcolor:
 MOVAPS XMM2,[SI+32]
 SHUFPS XMM2,XMM2,0
 MULPS XMM2,[SI+BP]		; l*color
 ADDPS XMM1,XMM2
background:
RETN
;-------------------------------------------------------------------------------
part1:
nexti:
 PUSH AX
 FILD WORD [BX-28]		; y c t
 FILD WORD [BX-20]		; x y c t
 FLDPI				; PI px y c t
 FMUL DWORD [SI+88]		; .5*PI x y c t
 FLD ST4			; t .5*PI x y c t
 FSUB DWORD [SI+88]		; t-.5 .5*PI x y c t
 FRNDINT			; round(t-.5) .5*PI x y c t
 FISUBR WORD [BX-36]		; i-round(t-.5) .5*PI x y c t
 FMUL ST1,ST0			; b b*.5*PI x y c t
 FADD ST0,ST5			; b+t b*.5*PI x y c t
 FMUL DWORD [SI+104]		; (b+t)/RESY b*.5*PI x y c t
 FMUL ST2,ST0			; (b+t)/RESY b*.5*PI px y c t
 FMULP ST3,ST0			; b*.5*PI px py c t
 FLD ST4			; t b*.5*PI px py c t
 FMUL DWORD [SI-84]		; 4*t b*.5*PI px py c t
 FADDP ST1,ST0			; 4*t+b*.5*PI px py c t
 CALL SINCOS			; cos sin px py c t
 FSUBR ST0,ST2			; px-cos sin px py c t
 FMUL ST0,ST0			; x2 sin px py c t
 FXCH ST1			; sin x2 px py c t
 FSUBR ST0,ST3			; py-sin x2 px py c t
 FMUL ST0,ST0			; y2 x2 px py c t
 FADDP ST1,ST0			; y2+x2 px py c t
 FMUL ST1,ST0
 FMULP ST2,ST0			; px py c t
 MOV CL,12
nextj:
.x2:
 FABS				; abs(px) py c t
 FSUB DWORD [SI+72]		; abs(px)-.1 py c t
 FXCH ST1			; py abs(px)-.1 c t
 CMC
 JC .x2 			; abs(px)-.1 abs(py)-.1 c t
 FLD DWORD [SI+56]		; .2 px py c t
 FADD ST0,ST0			; .4 px py c t
 CALL ROTATE2D			; px py c t
 LOOP nextj
 FABS				; abs(px) py c t

 FLD DWORD [SI+72]		; .1 px py c t
 FLDLN2 			; .7 .1 px py c t
 FMUL ST0,ST1			; .07 .1 px py c t
 FSUBP ST2,ST0			; .1 px-.07 py c t

 FMUL ST0,ST0			; .01 px py c t
 FDIVRP ST1,ST0 		; .01/px py c t
 FABS				; abs(.01/px) py c t
 FADDP ST2,ST0			; py c t
 FSTP ST0			; c t
 POP AX
 INC AX
 JPO nexti

 FSTP DWORD [SI+32]		; t
 JMP addcolor
;-------------------------------------------------------------------------------
part3:
 XORPS XMM1,XMM1		; XMM1 = vec4(0)
 FLD1				; 1 Ry t
 FCHS				; -1 Ry t
 FLDLN2 			; .7(.69315) Ry -1 t
 CALL ROTATE2D
 MOV BP,-16*5
 FLDZ				; i Ry Rz t
nextplane:
 FADD DWORD [SI+72]		; i+.1 Ry Rz t
 FLD DWORD [SI-68]		; 5 i Ry Rz t
 FMUL ST0,ST1			; i*5 i Ry Rz t
 FADD DWORD [SI+72]		; .1+i*5 i Ry Rz t
 FDIV ST0,ST2			; d i Ry Rz t

 FILD WORD [BX-20]		; x d i Ry Rz t
 FMUL DWORD [SI+104]		; x/RESY d i Ry Rz t
 FMUL ST0,ST1			; py d i Ry Rz t
 FLD ST4			; Rz py d i Ry Rz t
 FMUL ST0,ST2			; px py d i Ry Rz t
 FSUB ST0,ST6			; px-t py d i Ry Rz t

 MOV CL,3;5
nextsize:
 FLD ST1
 FIST WORD [SI]
 IMUL DI,[SI],79
 FADDP ST2,ST0
 FIST WORD [SI]
 IMUL DX,[SI],13
 FADD ST0,ST0
 ADD DI,DX
 JPO .1
 LOOP nextsize
.1:

 CLC
.x2:
 FSUB DWORD [SI+88]		; px-.5 py d i Ry Rz t
 FLD ST0			; px-.5 px-.5 py d i Ry Rz t

;FRNDINT			; round(px-.5) px-.5 py d i Ry Rz t
;FSUBP ST1,ST0			; fract(px)-.5 py d i Ry Rz t
;FXCH ST1			; py fract(px)-.5 d i Ry Rz t
;CMC
 CALL fract

 JC .x2
 FCOMI ST0,ST1			; fract(px)-.5 fract(py)-.5 d i Ry Rz t
 FCMOVB ST0,ST1 		; max(px,py) py d i Ry Rz t
 FCOMIP ST0,ST3 		; py d i Ry Rz t

 FSTP ST0			; d i Ry Rz t
 FMUL ST0,ST0			; d2 i Ry Rz t
 FDIVR DWORD [SI+40]		; c/d2 i Ry Rz t

 FSTP DWORD [SI+32]		; i Ry Rz t
 JAE .2
 ADD DI,BP
 JPO .2
 CALL addcolor
.2:
 ADD BP,16
 JNZ nextplane

 FCOMPP
 FSTP ST0			; t
RETN

genmods:
 FLD ST4			; px -.5*py .5*py r m px py t
 FMUL DWORD [SI+24]		; s*px -.5*py .5*py r m px py t
 FSUBRP ST1,ST0 		; s*px+.5*py .5*py r m px py t
 FMUL DWORD [SI+8]		; (s*px+.5*py)/r/2 .5*py r m px py t
 FLD ST0
 FSUB DWORD [SI+88]
fract:
 FRNDINT
 FSUBP ST1,ST0			; mod((s*px+.5*py)/r,2)/2 .5*py r m px py t
 FXCH ST1			; .5*py mod((s*px+.5*py)/r,2)/2 r m px py t
 CMC
RETN
; --------------------------- music please ! -------------------------------
IRQ:
 PUSHA
 PUSH DS
 PUSH CS
 POP DS
 MOV SI,COUNTER
 MOV DI,COUNTER+1
 INC DWORD [SI]

 IMUL AX,[DI],-64
 CMP AH,16
 JB .1
 SUB AX,AX
.1:
 MOV BX,AX
 MUL WORD [SI]
 XCHG BX,AX
 AND BH,16

 SHR AX,4
 ADD AX,-RESX/2
 MOV [self-2],AX

 CALL SAMPLE

 MOV AL,167
.2:
 MUL BH

;CMP [GS:8000H],AH
;JAE @F
;MOV [GS:8000H],AH
;@@:

 SHR AX,8
 JZ ENDIRQ
 OUT 42H,AL			; out the 6bit sample
ENDIRQ:

 MOV AL,20H
 OUT 20H,AL
 POP DS
 POPA
IRET

SAMPLE:
 MOV AX,[DI]
 SHLD CX,AX,16-3		; CX: RANDOM SEED

 MOV BL,63			; BH: SAMPLE
 PUSH AX
 TEST AL,8
 JNZ noBASS
 CALL NOTE
noBASS:

 MOV BL,31
 CALL NOTE0
 PUSH BX
 SUB BH,BH
 SUB WORD [DI],8
 CALL NOTE0
 ADD WORD [DI],8
 POP DX
 SHR BH,1
 ADD BH,DH

 POP AX
 AND AL,7*8
 CMP AL,4*8
 JNE noKICK
 LODSW
 MOV CL,AH
 SHR AX,CL
 AND AL,16
 ADD BH,AL
 RETN
noKICK:

 CMP AL,3*8
 JNE .1
 INC CX
 JPE SEED
 RETN
.1:
 AND AL,3*8
 CMP AL,2*8
 JNE noSNARE

SEED:
 MOV DX,1
 IMUL DX,DX,117
 MOV [SI-COUNTER+SEED+1],DX
 MOV DL,DH

ENV:
 IMUL AX,[SI],-32
 AND DL,BL
 MOV DH,0
 MUL DX
 ADD BH,DL
RETURN:
noSNARE:
noSOLO:
RETN

NOTE0:
 MOV AX,[DI]
 SHR AH,1
 JC noSOLO
 SHL AL,1
 JNC noSOLO
NOTE:
 SHR AL,4
 CMP AL,9
 JA RETURN
 CMP AL,5
 JNE .1
 INC CX
 JPO RETURN
.1:
 AND AX,7
 XCHG BP,AX
 SALC

 MOV DH,3
 AND DX,[DI]
 CMP DH,2
 JNE .2
 SUB BP,8
.2:

 MOV AH,[SI-COUNTER+NOTES+BP]
 MUL WORD [SI]
JMP ENV

ROTATE2D:
 CALL SINCOS			; c s x y
 FMUL ST0,ST3			; cy s x y
 FXCH ST3			; y s x cy
 FMUL ST0,ST1			; sy s x cy
 FXCH ST2			; x s sy cy
 FMUL ST1,ST0			; x sx sy cy
 FMUL DWORD [GS:DI]		; cx sx sy cy
 FADDP ST2,ST0			; sx cx+sy cy
 FSUBP ST2,ST0			; cx+sy cy-sx
RETN

SINCOS:
 FMUL DWORD [SI+16]		; a*8192/PI
;FMUL QWORD [SI+16]		; a*8192/PI
 FISTP DWORD [SI]
;FISTP QWORD [SI]
 MOV DI,[SI]
 SHL DI,2
 CLC
 FLD DWORD [GS:DI-16384]	; sin
 FLD DWORD [GS:DI]		; cos sin
RETN

COUNTER: DB 0,0,0;DD 0

NOTE2 DB 251,251,0,0,0,188,188,188
NOTES DB 224,224,0,0,0,168,168;,168

 DB 168,19,39,4     ;-84 +40
 DB 102,255,132,5   ;-68 +56
 DB 255,163,102,10  ;-52 +72
 DB 193,102,255,2   ;-36 +88
 DB 102,255,224,240 ;-20 +104
 DB 51,102,255;,0
colors:














